/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.math.BigDecimal;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.naming.InitialContext;
import org.modeshape.web.client.JcrService;
import org.modeshape.web.client.RemoteException;
import org.modeshape.web.jcr.RepositoryManager;
import org.modeshape.web.server.JcrServiceImpl;
import org.modeshape.web.shared.JcrAccessControlList;
import org.modeshape.web.shared.JcrNode;
import org.modeshape.web.shared.JcrNodeType;
import org.modeshape.web.shared.JcrPermission;
import org.modeshape.web.shared.JcrPolicy;
import org.modeshape.web.shared.JcrProperty;
import org.modeshape.web.shared.JcrRepositoryDescriptor;
import org.modeshape.web.shared.ResultSet;

public class JcrServiceImpl
extends RemoteServiceServlet
implements JcrService {
    private static final Logger log = Logger.getLogger("JcrServiceImpl");

    public boolean login(String jndiName, String userName, String password, String workspace) throws RemoteException {
        Repository repository = null;
        try {
            repository = RepositoryManager.getRepository((String)jndiName);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                InitialContext context = new InitialContext();
                repository = (Repository)context.lookup(jndiName);
            }
            catch (Exception ex) {
                throw new RemoteException(e.getMessage() + " or " + ex.getMessage());
            }
        }
        try {
            Session session;
            if (userName != null && userName.length() > 0) {
                SimpleCredentials creds = new SimpleCredentials(userName, password.toCharArray());
                session = repository.login((Credentials)creds, workspace);
            } else {
                session = repository.login(workspace);
            }
            this.getThreadLocalRequest().getSession().setAttribute("session", (Object)session);
            return true;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    private Session session() throws RemoteException {
        Session session = (Session)this.getThreadLocalRequest().getSession().getAttribute("session");
        if (session == null) {
            throw new RemoteException("Session has expired");
        }
        return session;
    }

    public JcrNode getRootNode() throws RemoteException {
        try {
            Node root = this.session().getRootNode();
            JcrNode node = new JcrNode("root", root.getPath(), root.getPrimaryNodeType().getName());
            node.setProperties(this.getProperties(root));
            node.setAcessControlList(this.getAccessList(this.session().getAccessControlManager(), root));
            return node;
        }
        catch (RepositoryException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public List<JcrNode> childNodes(String path) throws RemoteException {
        ArrayList<JcrNode> children = null;
        if (path == null || path.trim().length() == 0) {
            return Collections.emptyList();
        }
        try {
            Node node = (Node)this.session().getItem(path);
            NodeIterator it = node.getNodes();
            children = new ArrayList<JcrNode>((int)it.getSize());
            while (it.hasNext()) {
                Node n = it.nextNode();
                JcrNode childNode = new JcrNode(n.getName(), n.getPath(), n.getPrimaryNodeType().getName());
                childNode.setProperties(this.getProperties(n));
                childNode.setAcessControlList(this.getAccessList(this.session().getAccessControlManager(), node));
                childNode.setMixins(this.mixins(n));
                childNode.setPropertyDefs(this.propertyDefs(n));
                children.add(childNode);
            }
        }
        catch (PathNotFoundException e) {
            log.log(Level.FINER, e.getLocalizedMessage());
        }
        catch (RepositoryException e) {
            log.log(Level.SEVERE, "Unexpected error", e);
            throw new RemoteException(e.getMessage());
        }
        return children;
    }

    private String[] propertyDefs(Node node) throws RepositoryException {
        NodeType[] mixinType;
        PropertyDefinition[] defs;
        ArrayList<String> list = new ArrayList<String>();
        NodeType primaryType = node.getPrimaryNodeType();
        for (PropertyDefinition def : defs = primaryType.getPropertyDefinitions()) {
            if (def.isProtected()) continue;
            list.add(def.getName());
        }
        for (NodeType type : mixinType = node.getMixinNodeTypes()) {
            for (PropertyDefinition def : defs = type.getPropertyDefinitions()) {
                if (def.isProtected()) continue;
                list.add(def.getName());
            }
        }
        String[] res = new String[list.size()];
        list.toArray(res);
        return res;
    }

    private String[] mixins(Node node) throws RepositoryException {
        NodeType[] mixins = node.getMixinNodeTypes();
        int len = mixins != null ? mixins.length : 0;
        String[] res = new String[len];
        for (int i = 0; i < res.length; ++i) {
            res[i] = mixins[i].getName();
        }
        return res;
    }

    private JcrAccessControlList getAccessList(AccessControlManager acm, Node node) throws RepositoryException {
        AccessControlEntry[] entries;
        AccessControlList accessList = this.findAccessList(acm, node);
        if (accessList == null) {
            return JcrAccessControlList.defaultInstance();
        }
        JcrAccessControlList acl = new JcrAccessControlList();
        for (AccessControlEntry entry : entries = accessList.getAccessControlEntries()) {
            Privilege[] privileges;
            JcrPolicy en = new JcrPolicy();
            en.setPrincipal(entry.getPrincipal().getName());
            for (Privilege p : privileges = entry.getPrivileges()) {
                en.add(new JcrPermission(p.getName()));
            }
        }
        return acl;
    }

    private AccessControlList findAccessList(AccessControlManager acm, Node node) throws RepositoryException {
        AccessControlPolicy[] policy = acm.getPolicies(node.getPath());
        if (policy != null && policy.length > 0) {
            return (AccessControlList)policy[0];
        }
        Node parent = null;
        try {
            parent = node.getParent();
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        return this.findAccessList(acm, parent);
    }

    private Collection<JcrProperty> getProperties(Node node) throws RepositoryException {
        ArrayList<JcrProperty> list = new ArrayList<JcrProperty>();
        PropertyIterator it = node.getProperties();
        while (it.hasNext()) {
            Property p = it.nextProperty();
            JcrProperty property = new JcrProperty(p.getName(), PropertyType.nameFromValue((int)p.getType()), this.values(p));
            property.setProtected(p.getDefinition().isProtected());
            property.setProtected(p.getDefinition().isMultiple());
            list.add(property);
        }
        return list;
    }

    private String values(Property p) throws RepositoryException {
        if (!p.isMultiple()) {
            return p.getString();
        }
        Value[] values = p.getValues();
        if (values == null || values.length == 0) {
            return "";
        }
        if (values.length == 1) {
            return values[0].getString();
        }
        String s = values[0].getString();
        for (int i = 1; i < values.length; ++i) {
            s = s + "," + values[i].getString();
        }
        return s;
    }

    public JcrRepositoryDescriptor repositoryInfo() {
        Session session = (Session)this.getThreadLocalRequest().getSession().getAttribute("session");
        JcrRepositoryDescriptor desc = new JcrRepositoryDescriptor();
        Repository repo = session.getRepository();
        try {
            String[] keys = session.getRepository().getDescriptorKeys();
            for (int i = 0; i < keys.length; ++i) {
                Value value = repo.getDescriptorValue(keys[i]);
                desc.add(keys[i], value != null ? value.getString() : "N/A");
            }
        }
        catch (RepositoryException e) {
            log.log(Level.SEVERE, "Error getting repository information", e);
        }
        return desc;
    }

    public ResultSet query(String text, String lang) {
        Session session = (Session)this.getThreadLocalRequest().getSession().getAttribute("session");
        ResultSet rs = new ResultSet();
        try {
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query q = qm.createQuery(text, lang);
            QueryResult qr = q.execute();
            rs.setColumnNames(qr.getColumnNames());
            ArrayList<String[]> rows = new ArrayList<String[]>();
            RowIterator it = qr.getRows();
            while (it.hasNext()) {
                Row row = it.nextRow();
                String[] list = new String[qr.getColumnNames().length];
                for (int i = 0; i < qr.getColumnNames().length; ++i) {
                    Value v = row.getValue(qr.getColumnNames()[i]);
                    list[i] = v != null ? v.getString() : "null";
                }
                rows.add(list);
            }
            rs.setRows(rows);
        }
        catch (RepositoryException e) {
            log.log(Level.SEVERE, "Error executing query: " + text, e);
        }
        return rs;
    }

    public String[] supportedQueryLanguages() {
        Session session = (Session)this.getThreadLocalRequest().getSession().getAttribute("session");
        try {
            QueryManager qm = session.getWorkspace().getQueryManager();
            return qm.getSupportedQueryLanguages();
        }
        catch (RepositoryException e) {
            log.log(Level.SEVERE, "Error getting supported query languages", e);
            return null;
        }
    }

    public void addNode(String path, String name, String primaryType) throws RemoteException {
        try {
            Node node = (Node)this.session().getItem(path);
            node.addNode(name, primaryType);
        }
        catch (RepositoryException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void removeNode(String path) throws RemoteException {
        try {
            Node node = (Node)this.session().getItem(path);
            node.remove();
        }
        catch (PathNotFoundException e) {
            log.log(Level.FINER, e.getLocalizedMessage());
        }
        catch (RepositoryException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void addMixin(String path, String mixin) throws RemoteException {
        try {
            Node node = (Node)this.session().getItem(path);
            node.addMixin(mixin);
        }
        catch (PathNotFoundException e) {
            log.log(Level.FINER, e.getLocalizedMessage());
        }
        catch (RepositoryException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void removeMixin(String path, String mixin) throws RemoteException {
        try {
            Node node = (Node)this.session().getItem(path);
            node.removeMixin(mixin);
        }
        catch (PathNotFoundException e) {
            log.log(Level.FINER, e.getLocalizedMessage());
        }
        catch (RepositoryException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void setProperty(String path, String name, String value) throws RemoteException {
        try {
            Node node = (Node)this.session().getItem(path);
            switch (this.type(node, name)) {
                case 6: {
                    node.setProperty(name, Boolean.parseBoolean(value));
                    break;
                }
                case 5: {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(new SimpleDateFormat("").parse(value));
                    node.setProperty(name, cal);
                    break;
                }
                case 12: {
                    node.setProperty(name, BigDecimal.valueOf(Double.parseDouble(value)));
                    break;
                }
                case 4: {
                    node.setProperty(name, Double.parseDouble(value));
                    break;
                }
                case 3: {
                    node.setProperty(name, Long.parseLong(value));
                    break;
                }
                case 7: {
                    node.setProperty(name, value);
                    break;
                }
                case 8: {
                    node.setProperty(name, value);
                    break;
                }
                case 1: {
                    node.setProperty(name, value);
                    break;
                }
                case 11: {
                    node.setProperty(name, value);
                }
            }
        }
        catch (PathNotFoundException e) {
            log.log(Level.FINER, e.getLocalizedMessage());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected error", e);
            throw new RemoteException(e.getMessage());
        }
    }

    private int type(Node node, String propertyName) throws RepositoryException {
        NodeType[] mixins;
        PropertyDefinition[] defs;
        for (PropertyDefinition def : defs = node.getPrimaryNodeType().getPropertyDefinitions()) {
            if (!def.getName().equals(propertyName)) continue;
            return def.getRequiredType();
        }
        for (NodeType type : mixins = node.getMixinNodeTypes()) {
            for (PropertyDefinition def : defs = type.getPropertyDefinitions()) {
                if (!def.getName().equals(propertyName)) continue;
                return def.getRequiredType();
            }
        }
        return -1;
    }

    public void addAccessList(String path, String principal) throws RemoteException {
        try {
            AccessControlManager acm = this.session().getAccessControlManager();
            AccessControlPolicy[] policies = acm.getPolicies(path);
            if (policies != null && policies.length > 0) {
                AccessControlList acl = (AccessControlList)policies[0];
                acl.addAccessControlEntry((Principal)new SimplePrincipal(this, principal), new Privilege[0]);
            }
        }
        catch (PathNotFoundException e) {
            log.log(Level.FINER, e.getLocalizedMessage());
        }
        catch (RepositoryException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void updateAccessList(String path, String principal, JcrPermission[] permissions) throws RemoteException {
        try {
            AccessControlManager acm = this.session().getAccessControlManager();
            AccessControlPolicy[] policies = acm.getPolicies(path);
            if (policies != null && policies.length > 0) {
                AccessControlList acl = (AccessControlList)policies[0];
                acl.removeAccessControlEntry(this.find(acl.getAccessControlEntries(), principal));
                acl.addAccessControlEntry((Principal)new SimplePrincipal(this, principal), this.privileges(acm, permissions));
            }
        }
        catch (PathNotFoundException e) {
            log.log(Level.FINER, e.getLocalizedMessage());
        }
        catch (RepositoryException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void removeAccessList(String path, String principal) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private AccessControlEntry find(AccessControlEntry[] entries, String principal) throws RemoteException {
        for (AccessControlEntry entry : entries) {
            if (!entry.getPrincipal().getName().equals(principal)) continue;
            return entry;
        }
        throw new RemoteException("Access list has been deleted");
    }

    private Privilege[] privileges(AccessControlManager acm, JcrPermission[] permissions) throws AccessControlException, RepositoryException {
        Privilege[] privileges = new Privilege[permissions.length];
        for (int i = 0; i < privileges.length; ++i) {
            privileges[i] = acm.privilegeFromName(permissions[i].getName());
        }
        return privileges;
    }

    public String[] getPrimaryTypes(boolean allowAbstract) throws RemoteException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            NodeTypeManager mgr = this.session().getWorkspace().getNodeTypeManager();
            NodeTypeIterator it = mgr.getPrimaryNodeTypes();
            while (it.hasNext()) {
                NodeType nodeType = it.nextNodeType();
                if (nodeType.isAbstract() && !allowAbstract) continue;
                list.add(nodeType.getName());
            }
            String[] res = new String[list.size()];
            list.toArray(res);
            return res;
        }
        catch (RepositoryException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public String[] getMixinTypes(boolean allowAbstract) throws RemoteException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            NodeTypeManager mgr = this.session().getWorkspace().getNodeTypeManager();
            NodeTypeIterator it = mgr.getMixinNodeTypes();
            while (it.hasNext()) {
                NodeType nodeType = it.nextNodeType();
                if (nodeType.isAbstract() && !allowAbstract) continue;
                list.add(nodeType.getName());
            }
            String[] res = new String[list.size()];
            list.toArray(res);
            return res;
        }
        catch (RepositoryException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void save() throws RemoteException {
        try {
            this.session().save();
        }
        catch (RepositoryException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void updateAccessList(String path, JcrAccessControlList acl) throws RemoteException {
        try {
            AccessControlManager acm = this.session().getAccessControlManager();
            AccessControlPolicy[] policies = acm.getPolicies(path);
            AccessControlList accessList = null;
            accessList = policies != null && policies.length > 0 ? (AccessControlList)policies[0] : (AccessControlList)acm.getApplicablePolicies(path).nextAccessControlPolicy();
            this.clean(accessList);
            this.update(acm, acl, accessList);
            acm.setPolicy(path, (AccessControlPolicy)accessList);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    private void update(AccessControlManager acm, JcrAccessControlList a1, AccessControlList a2) throws AccessControlException, RepositoryException {
        Collection policies = a1.entries();
        for (JcrPolicy policy : policies) {
            a2.addAccessControlEntry((Principal)new SimplePrincipal(this, policy.getPrincipal()), this.privileges(acm, policy.getPermissions()));
        }
    }

    private Privilege[] privileges(AccessControlManager acm, Collection<JcrPermission> permissions) throws AccessControlException, RepositoryException {
        Privilege[] privileges = new Privilege[permissions.size()];
        int i = 0;
        for (JcrPermission permission : permissions) {
            privileges[i++] = acm.privilegeFromName(permission.getName());
        }
        return privileges;
    }

    private void clean(AccessControlList acl) throws RepositoryException {
        AccessControlEntry[] entries;
        for (AccessControlEntry entry : entries = acl.getAccessControlEntries()) {
            acl.removeAccessControlEntry(entry);
        }
    }

    public Collection<JcrNodeType> nodeTypes() throws RemoteException {
        ArrayList<JcrNodeType> list = new ArrayList<JcrNodeType>();
        try {
            NodeTypeManager mgr = this.session().getWorkspace().getNodeTypeManager();
            NodeTypeIterator it = mgr.getAllNodeTypes();
            while (it.hasNext()) {
                NodeType type = it.nextNodeType();
                JcrNodeType jcrType = new JcrNodeType();
                jcrType.setName(type.getName());
                jcrType.setAbstract(type.isAbstract());
                jcrType.setPrimary(!type.isMixin());
                jcrType.setMixin(type.isMixin());
                list.add(jcrType);
            }
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return list;
    }

    public String getRequestedURI() {
        String uri = (String)this.getThreadLocalRequest().getSession(true).getAttribute("initial.uri");
        if (uri != null) {
            return uri;
        }
        uri = this.getThreadLocalRequest().getRequestURI();
        String servletPath = this.getThreadLocalRequest().getServletPath();
        return uri.substring(0, uri.indexOf(servletPath));
    }
}

