/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav;

import com.googlecode.sardine.DavResource;
import com.googlecode.sardine.Sardine;
import com.googlecode.sardine.SardineFactory;
import com.googlecode.sardine.util.SardineException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;

public class WebdavStoreClientTest {
    private static final String SERVER_CONTEXT = "http://localhost:8090/webdav";
    protected Sardine sardine;

    @Before
    public void beforeEach() throws Exception {
        this.sardine = this.initializeWebDavClient();
    }

    protected Sardine initializeWebDavClient() throws SardineException {
        return SardineFactory.begin();
    }

    @Test
    public void shouldConnectWithValidCredentials() throws Exception {
        String uri = this.resourceUri(null);
        Assert.assertTrue((boolean)this.sardine.exists(uri));
        try {
            Assert.assertNotNull((Object)this.sardine.getResources(uri));
        }
        catch (SardineException e) {
            Assert.assertEquals((long)302L, (long)e.getStatusCode());
        }
    }

    @Test
    public void shouldCreateFolder() throws Exception {
        String folderName = "testFolder" + UUID.randomUUID().toString();
        String uri = this.resourceUri(folderName);
        this.sardine.createDirectory(uri);
        Assert.assertTrue((boolean)this.sardine.exists(uri));
        DavResource folder = this.getResourceAtURI(uri);
        Assert.assertEquals((long)0L, (long)folder.getContentLength());
    }

    protected DavResource getResourceAtURI(String uri) throws SardineException {
        List resourcesList = this.sardine.getResources(uri);
        Assert.assertEquals((long)1L, (long)resourcesList.size());
        return (DavResource)resourcesList.get(0);
    }

    @Test
    public void shouldCreateFile() throws Exception {
        String folderUri = this.resourceUri("testDirectory" + UUID.randomUUID().toString());
        this.sardine.createDirectory(folderUri);
        InputStream fileStream = this.getClass().getClassLoader().getResourceAsStream("textfile.txt");
        Assert.assertNotNull((Object)fileStream);
        String fileUri = folderUri + "/testFile" + UUID.randomUUID().toString();
        this.sardine.put(fileUri, fileStream);
        Assert.assertTrue((boolean)this.sardine.exists(fileUri));
        DavResource file = this.getResourceAtURI(fileUri);
        byte[] fileBytes = IoUtil.readBytes((InputStream)this.getClass().getClassLoader().getResourceAsStream("textfile.txt"));
        Assert.assertEquals((long)fileBytes.length, (long)file.getContentLength());
    }

    protected String resourceUri(String resourceName) {
        return !StringUtil.isBlank((String)resourceName) ? this.getServerContext() + "/" + resourceName : this.getServerContext();
    }

    protected String getServerContext() {
        return SERVER_CONTEXT;
    }
}

