/*
 * Decompiled with CFR 0.152.
 */
package com.github.jezza.lang;

import com.github.jezza.Toml;
import com.github.jezza.TomlArray;
import com.github.jezza.TomlTable;
import com.github.jezza.lang.Token;
import com.github.jezza.lang.Tokens;
import com.github.jezza.lang._TomlLexer;
import com.github.jezza.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;

public class TomlParser {
    private final _TomlLexer lexer;
    private Token current;

    public TomlParser(String in) {
        this(new StringReader(in));
    }

    public TomlParser(InputStream in) {
        this(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public TomlParser(Reader in) {
        this.lexer = new _TomlLexer(in);
    }

    protected final Token current() throws IOException {
        Token current = this.current;
        if (current == null) {
            this.current = current = this.lexer.next();
        }
        return current;
    }

    protected final boolean match(int type) throws IOException {
        if (this.is(type)) {
            this.current = null;
            return true;
        }
        return false;
    }

    protected final boolean is(int type) throws IOException {
        return this.current().type == type;
    }

    protected final boolean not(int type) throws IOException {
        return this.current().type != type;
    }

    protected final Token consume() throws IOException {
        Token current = this.current;
        if (current == null) {
            return this.lexer.next();
        }
        this.current = null;
        return current;
    }

    protected final Token consume(int type) throws IOException {
        Token token = this.current();
        if (token.type == type) {
            this.current = null;
            return token;
        }
        throw TomlParser.unexpected(token, type);
    }

    private static RuntimeException unexpected(Token token, int type) {
        throw new IllegalStateException(Strings.format("Unexpected token: {}, expected {}.", token, Tokens.name(type)));
    }

    public final TomlTable parse() throws IOException {
        TomlTable table = new TomlTable(4);
        this.parse(table);
        return table;
    }

    public TomlTable parse(TomlTable root) throws IOException {
        Token c;
        TomlTable current = root;
        while ((c = this.current()) != Token.EOS) {
            int type = c.type;
            if (type == 28) {
                Object value;
                TomlTable context;
                this.consume();
                boolean array = this.match(28);
                boolean relative = Toml.NONSTANDARD_EXTENSIONS && this.match(25);
                List<String> key = this.key();
                this.consume(29);
                TomlTable tomlTable = context = relative ? current : root;
                if (array) {
                    this.consume(29);
                    value = context.computeIfAbsent(key, k -> new TomlArray(0));
                    if (!(value instanceof TomlArray)) {
                        throw new IllegalStateException("Attempted to redefine " + key + " as array. [Already defined as " + value.getClass().getName() + "]");
                    }
                    TomlArray newArray = (TomlArray)value;
                    current = new TomlTable();
                    newArray.add(current);
                    continue;
                }
                value = context.computeIfAbsent(key, k -> new TomlTable(4));
                if (!(value instanceof TomlTable)) {
                    throw new IllegalStateException("Attempted to redefine " + key + " as table. [Already defined as " + value.getClass().getName() + "]");
                }
                current = (TomlTable)value;
                continue;
            }
            if (TomlParser.isKey(type)) {
                int row = c.row;
                List<String> key = this.key();
                if (this.consume((int)27).row != row || this.current().row != row) {
                    throw new IllegalStateException("[ERROR] Key-Value pair not on same line: " + row);
                }
                Object value = this.value();
                Object old = current.put(key, value);
                if (old == null || old.getClass() == value.getClass()) continue;
                throw new IllegalStateException("Attempted to redefine " + key + " as " + value.getClass().getName() + ". [Already defined as " + old.getClass().getName() + "]");
            }
            throw new IllegalStateException("[ERROR] unexpected token: " + c + " ['{KEY}' | '{STRING}' | '[']");
        }
        return root;
    }

    protected TomlArray array() throws IOException {
        this.consume(28);
        TomlArray array = new TomlArray(0);
        while (!this.match(29)) {
            array.add(this.value());
            if (this.match(26)) continue;
            this.consume(29);
            return array;
        }
        return array;
    }

    protected TomlTable inlineTable() throws IOException {
        int row = this.consume((int)30).row;
        TomlTable table = new TomlTable(0);
        if (this.is(31)) {
            if (this.consume().row != row) {
                throw new IllegalStateException("[ERROR] Inline table not on same line: " + row);
            }
            return table;
        }
        do {
            List<String> key = this.key();
            this.consume(27);
            if (this.current().row != row) {
                throw new IllegalStateException("[ERROR] Inline table not on same line: " + row);
            }
            Object value = this.value();
            Object old = table.put(key, value);
            if (old == null) continue;
            if (old.getClass() != value.getClass()) {
                throw new IllegalStateException("Attempted to redefine " + key + " as " + value.getClass().getName() + ". [Already defined as " + old.getClass().getName() + "]");
            }
            throw new IllegalStateException("Duplicate key " + key + ". [Defined as " + old.getClass().getName() + "]");
        } while (this.match(26));
        if (this.consume((int)31).row != row) {
            throw new IllegalStateException("[ERROR] Inline table not on same line: " + row);
        }
        return table;
    }

    private static boolean isKey(int type) {
        return type == 20 || type == 3 || type == 10 || type == 11 || type == 12 || type == 13 || type == 15;
    }

    protected List<String> key() throws IOException {
        String[] segments;
        Token t = this.consume();
        int row = t.row;
        if (!TomlParser.isKey(t.type)) {
            throw new IllegalStateException("[ERROR] unexpected token: " + t + " ['{KEY}' | '{STRING}']");
        }
        if (t.type == 15) {
            String value = t.value;
            int i = value.indexOf(46);
            String first = value.substring(0, i);
            String second = value.substring(i + 1);
            segments = new String[]{first, second};
        } else {
            segments = new String[]{t.value};
        }
        while (this.current().type == 25) {
            if (this.consume().row != row) {
                throw new IllegalStateException("[ERROR] Dotted key not on same line: " + row);
            }
            Token next = this.current();
            if (!TomlParser.isKey(next.type)) {
                throw new IllegalStateException("[ERROR] unexpected token: " + next + " ['{KEY}' | '{STRING}']");
            }
            if (this.consume().row != row) {
                throw new IllegalStateException("[ERROR] Dotted key not on same line: " + row);
            }
            String value = next.value;
            if (next.type == 15) {
                int i = value.indexOf(46);
                int length = segments.length;
                segments = Arrays.copyOf(segments, length + 2);
                segments[length] = value.substring(0, i);
                segments[length + 1] = value.substring(i + 1);
                continue;
            }
            int length = segments.length;
            segments = Arrays.copyOf(segments, length + 1);
            segments[length] = value;
        }
        return List.of(segments);
    }

    protected Object value() throws IOException {
        Token c = this.current();
        switch (c.type) {
            case 4: 
            case 6: {
                throw new IllegalStateException("[ERROR] Illegal string starting at [" + c.row + ":" + c.col + "]");
            }
            case 3: 
            case 5: {
                this.consume();
                return c.value;
            }
            case 32: {
                this.consume();
                return Boolean.TRUE;
            }
            case 33: {
                this.consume();
                return Boolean.FALSE;
            }
            case 28: {
                return this.array();
            }
            case 30: {
                return this.inlineTable();
            }
            case 34: {
                this.consume();
                return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(c.value.replace(' ', 'T'));
            }
            case 35: {
                this.consume();
                return DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse(c.value.replace(' ', 'T'));
            }
            case 36: {
                this.consume();
                return DateTimeFormatter.ISO_LOCAL_DATE.parse(c.value);
            }
            case 37: {
                this.consume();
                return DateTimeFormatter.ISO_LOCAL_TIME.parse(c.value);
            }
            case 16: {
                this.consume();
                return c.value.charAt(0) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            case 17: {
                this.consume();
                return Double.NaN;
            }
            case 15: {
                this.consume();
                return TomlParser.intoDouble(c);
            }
            case 13: {
                this.consume();
                return TomlParser.intoLong(c, 2, 2);
            }
            case 12: {
                this.consume();
                return TomlParser.intoLong(c, 2, 8);
            }
            case 10: {
                this.consume();
                return TomlParser.intoLong(c, 0, 10);
            }
            case 11: {
                this.consume();
                return TomlParser.intoLong(c, 2, 16);
            }
        }
        throw new IllegalStateException("[ERROR] unexpected token: " + c + " ['{STRING}' | '{ML_STRING}' | '{BOOLEAN}' | '{LBRACKET}' | '{DATE}' | '{FLOAT}' | '{INTEGER_(BIN|OCT|DEC|HEX)}']");
    }

    protected static Long intoLong(Token token, int offset, int radix) {
        String input = token.value.replace("_", "");
        return Long.valueOf(offset > 0 ? input.substring(offset) : input, radix);
    }

    protected static Double intoDouble(Token token) {
        String input = token.value.replace("_", "");
        return Double.valueOf(input);
    }
}

