/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.config;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import kr.motd.maven.os.Detector;
import org.moditect.layrry.config.LayersConfig;
import org.moditect.layrry.config.LayersConfigParser;
import org.moditect.layrry.config.UrlDownloader;

public class LayersConfigLoader {
    private static final String OS_DETECTED_JFXNAME = "os.detected.jfxname";
    private static final String OS_DETECTED_LWJGLNAME = "os.detected.lwjglname";

    public static LayersConfig loadConfig(URL layersConfigUrl) {
        return LayersConfigLoader.loadConfig(layersConfigUrl, new Properties());
    }

    public static LayersConfig loadConfig(URL layersConfigUrl, Path propertiesFile) {
        Properties properties = new Properties();
        try (InputStream inputStream = propertiesFile.toUri().toURL().openStream();){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error reading properties file: " + propertiesFile, e);
        }
        return LayersConfigLoader.loadConfig(layersConfigUrl, properties);
    }

    public static LayersConfig loadConfig(URL layersConfigUrl, URL propertiesFileUrl) {
        Properties properties = new Properties();
        try (InputStream inputStream = propertiesFileUrl.openStream();){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error reading properties from: " + propertiesFileUrl, e);
        }
        return LayersConfigLoader.loadConfig(layersConfigUrl, properties);
    }

    public static LayersConfig loadConfig(Path layersConfigFile) {
        return LayersConfigLoader.loadConfig(layersConfigFile, new Properties());
    }

    public static LayersConfig loadConfig(Path layersConfigFile, Path propertiesFile) {
        Properties properties = new Properties();
        try (InputStream inputStream = propertiesFile.toUri().toURL().openStream();){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error reading properties file: " + propertiesFile, e);
        }
        return LayersConfigLoader.loadConfig(layersConfigFile, properties);
    }

    public static LayersConfig loadConfig(Path layersConfigFile, URL propertiesFileUrl) {
        Properties properties = new Properties();
        try (InputStream inputStream = propertiesFileUrl.openStream();){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error reading properties from: " + propertiesFileUrl, e);
        }
        return LayersConfigLoader.loadConfig(layersConfigFile, properties);
    }

    private static LayersConfig loadConfig(URL layersConfigUrl, Properties properties) {
        if (LayersConfigLoader.isLocalUrl(layersConfigUrl)) {
            return LayersConfigLoader.loadConfig(LayersConfigLoader.convertToPath(layersConfigUrl));
        }
        return LayersConfigLoader.loadConfig(UrlDownloader.download(layersConfigUrl, properties), properties);
    }

    private static LayersConfig loadConfig(Path layersConfigFile, Properties properties) {
        ServiceLoader<LayersConfigParser> parsers = ServiceLoader.load(LayersConfigParser.class, LayersConfigLoader.class.getClassLoader());
        for (LayersConfigParser parser : parsers) {
            LayersConfig layersConfig;
            block9: {
                if (!parser.supports(layersConfigFile)) continue;
                InputStream inputStream = layersConfigFile.toUri().toURL().openStream();
                try {
                    layersConfig = parser.parse(LayersConfigLoader.replacePlaceholders(properties, inputStream));
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Unexpected error parsing config file. " + layersConfigFile, e);
                    }
                }
                inputStream.close();
            }
            return layersConfig;
        }
        throw new IllegalArgumentException("Unsupported config format. " + layersConfigFile);
    }

    private static InputStream replacePlaceholders(Properties properties, InputStream inputStream) {
        OsDetector detector = new OsDetector();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)properties);
        props.putAll((Map<?, ?>)System.getProperties());
        props.putAll((Map<?, ?>)detector.getProperties());
        String javafxClassifier = LayersConfigLoader.resolveJavaFxClassifier(detector.get("os.detected.name"));
        if (null != javafxClassifier) {
            props.put(OS_DETECTED_JFXNAME, javafxClassifier);
        }
        String lwjglClassifier = LayersConfigLoader.resolveLwjglClassifier(detector.get("os.detected.name"), detector.get("os.detected.arch"));
        if (null != javafxClassifier) {
            props.put(OS_DETECTED_LWJGLNAME, lwjglClassifier);
        }
        StringWriter input = new StringWriter();
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile(new InputStreamReader(inputStream), "layrry");
        mustache.execute((Writer)input, props);
        input.flush();
        return new ByteArrayInputStream(input.toString().getBytes());
    }

    private static String resolveJavaFxClassifier(String os) {
        switch (os) {
            case "linux": {
                return "linux";
            }
            case "windows": {
                return "win";
            }
            case "osx": {
                return "mac";
            }
        }
        return null;
    }

    private static String resolveLwjglClassifier(String os, String arch) {
        switch (os) {
            case "linux": {
                return "linux" + ("arm_32".equals(arch) ? "-arm32" : "");
            }
            case "windows": {
                return "windows" + ("x86_32".equals(arch) ? "-x86" : "");
            }
            case "osx": {
                return "macosx";
            }
        }
        return null;
    }

    private static boolean isLocalUrl(URL url) {
        return "file".equalsIgnoreCase(url.getProtocol());
    }

    private static Path convertToPath(URL url) {
        try {
            return new File(url.toURI()).toPath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unsupported error converting URL to Path. " + url);
        }
    }

    private static class OsDetector
    extends Detector {
        private final Properties props = new Properties();

        private OsDetector() {
            this.props.put("failOnUnknownOS", "false");
            this.detect(this.props, Collections.emptyList());
        }

        private Properties getProperties() {
            return this.props;
        }

        private String get(String key) {
            return this.props.getProperty(key);
        }

        @Override
        protected void log(String message) {
        }

        @Override
        protected void logProperty(String name, String value) {
        }
    }
}

