/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.config;

import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Properties;
import java.util.ServiceLoader;
import org.moditect.layrry.config.LayersConfigLoader;
import org.moditect.layrry.config.LayersConfigParser;

class UrlDownloader {
    private static final String JAVA_NET_USE_SYSTEM_PROXIES = "java.net.useSystemProxies";

    UrlDownloader() {
    }

    static Path download(URL url, Properties properties) {
        HttpClient.Builder builder = HttpClient.newBuilder().connectTimeout(Duration.of(UrlDownloader.getLong("connection.timeout", properties, 30000L), ChronoUnit.MILLIS)).followRedirects(HttpClient.Redirect.ALWAYS);
        builder = UrlDownloader.setupProxy(builder, url, properties);
        builder = UrlDownloader.setupAuthentication(builder, url, properties);
        HttpClient client = builder.build();
        HttpRequest request = UrlDownloader.createRequest(url);
        try {
            HttpResponse<Path> response = client.send(request, UrlDownloader.fileBodyHandler(url));
            return response.body();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            throw new IllegalStateException("Unexpected error when downloading from " + url, e);
        }
    }

    private static HttpRequest createRequest(URL url) {
        try {
            return HttpRequest.newBuilder().uri(url.toURI()).build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
    }

    private static HttpResponse.BodyHandler<Path> fileBodyHandler(URL url) {
        return responseInfo -> {
            try {
                if (responseInfo.headers().firstValue("Content-Disposition").isPresent()) {
                    Path layrryTmpDirPath = Files.createTempDirectory("layrry-download", new FileAttribute[0]);
                    return HttpResponse.BodyHandlers.ofFileDownload(layrryTmpDirPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE).apply(responseInfo);
                }
                Object fileName = UrlDownloader.resolveFileName(url);
                String fileExtension = UrlDownloader.resolveFileExtension((String)fileName, responseInfo.headers());
                if (fileExtension != null) {
                    fileName = (String)fileName + fileExtension;
                }
                Path layersConfigFilePath = File.createTempFile("layrry", (String)fileName).toPath();
                return HttpResponse.BodyHandlers.ofFile(layersConfigFilePath).apply(responseInfo);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Unexpected I/O error", ioe);
            }
        };
    }

    private static HttpClient.Builder setupProxy(HttpClient.Builder builder, URL url, Properties properties) {
        if (UrlDownloader.getBoolean("http.proxy", properties)) {
            UrlDownloader.setIfUndefined("http.proxyHost", properties, "");
            UrlDownloader.setIfUndefined("http.proxyPort", properties, "80");
            UrlDownloader.setIfUndefined("http.nonProxyHosts", properties, "localhost|127.*|[::1]");
        }
        if (UrlDownloader.getBoolean("https.proxy", properties)) {
            UrlDownloader.setIfUndefined("https.proxyHost", properties, "");
            UrlDownloader.setIfUndefined("https.proxyPort", properties, "443");
            UrlDownloader.setIfUndefined("http.nonProxyHosts", properties, "localhost|127.*|[::1]");
        }
        if (UrlDownloader.getBoolean("socks.proxy", properties)) {
            UrlDownloader.setIfUndefined("socksProxyHost", properties.getProperty("socks.proxyHost", ""));
            UrlDownloader.setIfUndefined("socksProxyPort", properties.getProperty("socks.proxyPort", "1080"));
        }
        return builder.proxy(ProxySelector.of(new InetSocketAddress(url.getHost(), url.getPort())));
    }

    private static HttpClient.Builder setupAuthentication(HttpClient.Builder builder, final URL url, final Properties properties) {
        if (UrlDownloader.getBoolean("http.proxy", properties) || UrlDownloader.getBoolean("https.proxy", properties)) {
            return builder.authenticator(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    String protocol = url.getProtocol().toLowerCase();
                    String username = properties.getProperty(protocol + ".proxyUser", "");
                    String password = properties.getProperty(protocol + ".proxyPassword", "");
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
        if (UrlDownloader.getBoolean("socks.proxy", properties) && UrlDownloader.getBoolean("socks.proxy.auth", properties)) {
            final String username = properties.getProperty("socks.proxyUser", "");
            final String password = properties.getProperty("socks.proxyPassword", "");
            System.setProperty("java.net.socks.username", username);
            System.setProperty("java.net.socks.password", password);
            return builder.authenticator(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
        return builder;
    }

    private static void setIfUndefined(String key, Properties properties, String defaultValue) {
        if (null == System.getProperty(key)) {
            System.setProperty(key, properties.getProperty(key, defaultValue));
        }
    }

    private static void setIfUndefined(String key, String value) {
        if (null == System.getProperty(key)) {
            System.setProperty(key, value);
        }
    }

    private static String resolveFileName(URL url) {
        int index;
        String path = url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((index = path.lastIndexOf(47)) < 0) {
            return path;
        }
        return path.substring(index + 1);
    }

    private static String resolveFileExtension(String fileName, HttpHeaders headers) {
        int dot = fileName.lastIndexOf(46);
        if (dot > -1) {
            return null;
        }
        String contentType = headers.firstValue("Content-Type").orElse("text/plain");
        ServiceLoader<LayersConfigParser> parsers = ServiceLoader.load(LayersConfigParser.class, LayersConfigLoader.class.getClassLoader());
        for (LayersConfigParser parser : parsers) {
            for (String mimeType : parser.getSupportedMimeTypes()) {
                if (!mimeType.equals(contentType)) continue;
                return "." + parser.getPreferredFileExtension();
            }
        }
        return null;
    }

    private static void setupProxy(final Properties properties) {
        String useSystemProxies = properties.getProperty(JAVA_NET_USE_SYSTEM_PROXIES);
        if (useSystemProxies != null && UrlDownloader.getBoolean(JAVA_NET_USE_SYSTEM_PROXIES, properties)) {
            System.setProperty(JAVA_NET_USE_SYSTEM_PROXIES, "true");
            return;
        }
        if (UrlDownloader.getBoolean("http.proxy", properties) || UrlDownloader.getBoolean("https.proxy", properties)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                        String protocol = this.getRequestingProtocol().toLowerCase();
                        String host = properties.getProperty(protocol + ".proxyHost", "");
                        String port = properties.getProperty(protocol + ".proxyPort", "80");
                        String username = properties.getProperty(protocol + ".proxyUser", "");
                        String password = properties.getProperty(protocol + ".proxyPassword", "");
                        if (this.getRequestingHost().equalsIgnoreCase(host) && Integer.parseInt(port) == this.getRequestingPort()) {
                            return new PasswordAuthentication(username, password.toCharArray());
                        }
                    }
                    return null;
                }
            });
        }
        if (UrlDownloader.getBoolean("socks.proxy", properties)) {
            System.setProperty("socksProxyHost", properties.getProperty("socks.proxyHost"));
            System.setProperty("socksProxyPort", properties.getProperty("socks.proxyPort"));
            if (UrlDownloader.getBoolean("socks.proxy.auth", properties)) {
                final String username = properties.getProperty("socks.proxyUser", "");
                final String password = properties.getProperty("socks.proxyPassword", "");
                System.setProperty("java.net.socks.username", username);
                System.setProperty("java.net.socks.password", password);
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(username, password.toCharArray());
                    }
                });
            }
        }
    }

    static boolean getBoolean(String name, Properties properties) {
        try {
            return Boolean.parseBoolean(properties.getProperty(name));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            return false;
        }
    }

    static int getInteger(String name, Properties properties, int defaultValue) {
        try {
            return Integer.parseInt(properties.getProperty(name));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return defaultValue;
        }
    }

    static long getLong(String name, Properties properties, long defaultValue) {
        try {
            return Long.parseLong(properties.getProperty(name));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return defaultValue;
        }
    }
}

