/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.config.toml;

import com.github.jezza.Toml;
import com.github.jezza.TomlTable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.moditect.layrry.config.Layer;
import org.moditect.layrry.config.LayersConfig;
import org.moditect.layrry.config.LayersConfigParser;
import org.moditect.layrry.config.Main;
import org.moditect.layrry.config.Repository;
import org.moditect.layrry.config.Resolve;

public class TomlLayersConfigParser
implements LayersConfigParser {
    @Override
    public Set<String> getSupportedMimeTypes() {
        return Set.of("text/vnd.toml", "application/vnd.toml", "text/toml", "text/x-toml", "application/toml", "application/x-toml");
    }

    @Override
    public String getPreferredFileExtension() {
        return "toml";
    }

    @Override
    public boolean supports(Path layersConfigFile) {
        return layersConfigFile.getFileName().toString().endsWith(".toml");
    }

    @Override
    public LayersConfig parse(InputStream inputStream) throws IOException {
        return TomlLayersConfigParser.readFromToml(Toml.from(inputStream));
    }

    private static LayersConfig readFromToml(TomlTable toml) {
        LayersConfig config = new LayersConfig();
        TomlLayersConfigParser.readResolve(config, (TomlTable)toml.get("resolve"));
        TomlLayersConfigParser.readLayers(config, (TomlTable)toml.get("layers"));
        TomlLayersConfigParser.readMain(config, (TomlTable)toml.get("main"));
        return config;
    }

    private static void readMain(LayersConfig config, TomlTable table) {
        Main main = new Main();
        config.setMain(main);
        main.setModule(String.valueOf(table.get("module")));
        main.setClazz(String.valueOf(table.get("class")));
    }

    private static void readResolve(LayersConfig config, TomlTable table) {
        Resolve resolve = new Resolve();
        config.setResolve(resolve);
        if (table != null) {
            resolve.setRemote((Boolean)table.getOrDefault("remote", (Object)true));
            resolve.setWorkOffline((Boolean)table.getOrDefault("workOffline", (Object)false));
            resolve.setUseMavenCentral((Boolean)table.getOrDefault("useMavenCentral", (Object)true));
            resolve.setFromFile((String)table.get("fromFile"));
            TomlLayersConfigParser.readRepositories(resolve, (TomlTable)table.get("localRepositories"));
        }
    }

    private static void readRepositories(Resolve resolve, TomlTable table) {
        LinkedHashMap<String, Repository> repositories = new LinkedHashMap<String, Repository>();
        resolve.setLocalRepositories(repositories);
        if (table == null) {
            return;
        }
        table.entrySet().forEach(entry -> {
            Repository repository = new Repository();
            TomlTable repositoryTable = (TomlTable)entry.getValue();
            repository.setPath((String)repositoryTable.get("path"));
            repository.setLayout((String)repositoryTable.get("layout"));
            repositories.put((String)entry.getKey(), repository);
        });
    }

    private static void readLayers(LayersConfig config, TomlTable table) {
        LinkedHashMap<String, Layer> layers = new LinkedHashMap<String, Layer>();
        config.setLayers(layers);
        table.entrySet().forEach(entry -> {
            Layer layer = new Layer();
            TomlTable layerTable = (TomlTable)entry.getValue();
            if (layerTable.asMap().containsKey("parents")) {
                layer.setParents((List)layerTable.get("parents"));
            }
            if (layerTable.asMap().containsKey("modules")) {
                layer.setModules((List)layerTable.get("modules"));
            }
            if (layerTable.asMap().containsKey("directory")) {
                layer.setDirectory(String.valueOf(layerTable.get("directory")));
            }
            layers.put((String)entry.getKey(), layer);
        });
    }
}

