/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.internal;

import java.util.Collections;
import java.util.List;
import org.moditect.layrry.internal.Layer;
import org.moditect.layrry.internal.LayerBuilderImpl;
import org.moditect.layrry.internal.Plugin;

public abstract class Component {
    private final String name;
    private final List<String> parents;

    protected Component(String name, List<String> parents) {
        this.name = name;
        this.parents = Collections.unmodifiableList(parents);
    }

    public static Component fromLayer(LayerBuilderImpl layer) {
        if (layer.getLayerDir() != null) {
            return new Plugin(layer.getName(), layer.getLayerDir(), layer.getParents());
        }
        return new Layer(layer.getName(), layer.getModuleGavs(), layer.getParents());
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public abstract boolean isPlugin();
}

