/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.internal;

import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryWatcher;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.moditect.layrry.Layers;
import org.moditect.layrry.LocalResolve;
import org.moditect.layrry.RemoteResolve;
import org.moditect.layrry.internal.Component;
import org.moditect.layrry.internal.Layer;
import org.moditect.layrry.internal.LocalResolveImpl;
import org.moditect.layrry.internal.Plugin;
import org.moditect.layrry.internal.PluginsDirectory;
import org.moditect.layrry.internal.RemoteResolveImpl;
import org.moditect.layrry.internal.jfr.PluginLayerAddedEvent;
import org.moditect.layrry.internal.jfr.PluginLayerRemovedEvent;
import org.moditect.layrry.internal.resolver.ResolveImpl;
import org.moditect.layrry.internal.util.FilesHelper;

public class LayersImpl
implements Layers {
    private static final Pattern PLUGIN_ARTIFACT_PATTERN = Pattern.compile("(.*?)\\-(\\d[\\d+\\-_A-Za-z\\.]*?)\\.(jar|zip|tar|tar\\.gz)");
    private final Map<String, Component> components;
    private final Map<String, ModuleLayer> moduleLayers;
    private final Path pluginsWorkingDir;
    private final Set<PluginsDirectory> pluginsDirectories;
    private final ResolveImpl resolve = new ResolveImpl();
    private int pluginIndex = 0;

    public LayersImpl(Set<PluginsDirectory> pluginsDirectories, Map<String, Component> components, List<LocalResolve> localResolves, List<RemoteResolve> remoteResolves) {
        this.components = Collections.unmodifiableMap(components);
        this.moduleLayers = new ConcurrentHashMap<String, ModuleLayer>();
        this.pluginsDirectories = Collections.unmodifiableSet(pluginsDirectories);
        for (LocalResolve localResolve : localResolves) {
            ((LocalResolveImpl)localResolve).localRepositories().forEach(this.resolve.local()::withLocalRepo);
        }
        for (RemoteResolve remoteResolve : remoteResolves) {
            RemoteResolveImpl remote = (RemoteResolveImpl)remoteResolve;
            this.resolve.remote().enabled(remote.enabled());
            this.resolve.remote().workOffline(remote.workOffline());
            this.resolve.remote().withMavenCentralRepo(remote.useMavenCentral());
            if (null == remote.fromFile()) continue;
            this.resolve.remote().fromFile(remote.fromFile());
        }
        try {
            this.pluginsWorkingDir = Files.createTempDirectory("layrry-plugins", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run(String main, String ... args) {
        try {
            HashMap<String, ModuleLayer> pluginLayersByName = new HashMap<String, ModuleLayer>();
            for (Map.Entry<String, Component> entry : this.components.entrySet()) {
                Component component = entry.getValue();
                if (component.isPlugin()) {
                    pluginLayersByName.putAll(this.handlePluginComponent(entry.getKey(), (Plugin)component));
                    continue;
                }
                this.handleLayerComponent(entry.getKey(), (Layer)component);
            }
            if (!this.pluginsDirectories.isEmpty()) {
                Deployer deployer = new Deployer(this.pluginsDirectories);
                for (Map.Entry plugin : pluginLayersByName.entrySet()) {
                    deployer.deploy((String)plugin.getKey(), (ModuleLayer)plugin.getValue());
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't initialize layers", e);
        }
        try {
            Class<?> mainClass = this.getMainClass(main);
            Method mainMethod = mainClass.getDeclaredMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Couldn't run module main class", e);
        }
    }

    private void handleLayerComponent(String name, Layer component) {
        PluginLayerAddedEvent event = new PluginLayerAddedEvent();
        event.begin();
        List<Path> modulePathEntries = this.getModulePathEntries(component);
        List<ModuleLayer> parentLayers = this.getParentLayers(name, component.getParents());
        ModuleLayer moduleLayer = this.createModuleLayer(parentLayers, modulePathEntries);
        this.moduleLayers.put(name, moduleLayer);
        event.name = name;
        event.modules = moduleLayer.modules().stream().map(Module::getName).collect(Collectors.joining(", "));
        event.commit();
    }

    private Map<String, ModuleLayer> handlePluginComponent(String name, Plugin plugin) throws IOException {
        HashMap<String, ModuleLayer> pluginLayersByName = new HashMap<String, ModuleLayer>();
        Files.list(plugin.getLayerDir()).forEach(path -> {
            Matcher matcher = PLUGIN_ARTIFACT_PATTERN.matcher(path.getFileName().toString());
            if (!matcher.matches()) {
                return;
            }
            PluginLayerAddedEvent event = new PluginLayerAddedEvent();
            event.begin();
            String pluginArtifactId = matcher.group(1);
            String pluginVersion = matcher.group(2);
            String derivedFrom = plugin.getLayerDir().getFileName().toString();
            String pluginName = String.join((CharSequence)"-", derivedFrom, pluginArtifactId, pluginVersion);
            Path pluginDir = this.pluginsWorkingDir.resolve(this.pluginIndex++ + "-" + pluginName);
            List<Path> modulePathEntries = this.unpackPluginArtifact((Path)path, pluginDir);
            List<ModuleLayer> parentLayers = this.getParentLayers(name, plugin.getParents());
            ModuleLayer moduleLayer = this.createModuleLayer(parentLayers, modulePathEntries);
            this.moduleLayers.put(pluginName, moduleLayer);
            pluginLayersByName.put(pluginName, moduleLayer);
            event.name = pluginName;
            event.modules = moduleLayer.modules().stream().map(Module::getName).collect(Collectors.joining(", "));
            event.commit();
        });
        return pluginLayersByName;
    }

    private ModuleLayer createModuleLayer(List<ModuleLayer> parentLayers, List<Path> modulePathEntries) {
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        ModuleFinder finder = ModuleFinder.of((Path[])modulePathEntries.toArray(Path[]::new));
        Set<String> roots = finder.findAll().stream().map(m -> m.descriptor().name()).collect(Collectors.toSet());
        Configuration appConfig = Configuration.resolve(finder, parentLayers.stream().map(ModuleLayer::configuration).collect(Collectors.toList()), ModuleFinder.of(new Path[0]), roots);
        return ModuleLayer.defineModulesWithOneLoader(appConfig, parentLayers, scl).layer();
    }

    private List<Path> getModulePathEntries(Layer layer) {
        List<String> moduleGavs = layer.getModuleGavs();
        return Arrays.asList(this.resolve.resolve(moduleGavs).asPath());
    }

    private Class<?> getMainClass(String main) throws ClassNotFoundException {
        String[] parts = main.split("/");
        for (Map.Entry<String, ModuleLayer> entry : this.moduleLayers.entrySet()) {
            try {
                ClassLoader loader = entry.getValue().findLoader(parts[0]);
                return loader.loadClass(parts[1]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new IllegalArgumentException("Module " + parts[0] + " not found");
    }

    private List<ModuleLayer> getParentLayers(String name, List<String> parents) {
        ArrayList<ModuleLayer> parentLayers = new ArrayList<ModuleLayer>();
        for (String parent : parents) {
            ModuleLayer parentLayer = this.moduleLayers.get(parent);
            if (parentLayer == null) {
                throw new IllegalArgumentException("Layer '" + name + "': parent layer '" + parent + "' not configured yet");
            }
            parentLayers.add(parentLayer);
        }
        return parentLayers.isEmpty() ? List.of(ModuleLayer.boot()) : parentLayers;
    }

    private List<Path> unpackPluginArtifact(Path pluginArtifact, Path targetDir) {
        String fileName = pluginArtifact.getFileName().toString();
        if (fileName.endsWith(".jar")) {
            FilesHelper.copy(pluginArtifact, targetDir.resolve(fileName));
        } else if (fileName.endsWith(".zip") || fileName.endsWith(".tar")) {
            FilesHelper.unpack(pluginArtifact, targetDir);
        } else if (fileName.endsWith(".tar.gz")) {
            FilesHelper.unpackCompressed(pluginArtifact, targetDir);
        }
        return List.of(targetDir);
    }

    private class Deployer {
        private final Method notifyOnAddition;
        private final Method notifyOnRemoval;
        private final Object supportInstance;

        public Deployer(Set<PluginsDirectory> pluginsDirectories) {
            try {
                ModuleLayer platformLayer = this.getLayrryPlatformLayer(LayersImpl.this.moduleLayers);
                ClassLoader loader = platformLayer.findLoader("org.moditect.layrry.platform");
                Class<?> support = loader.loadClass("org.moditect.layrry.platform.internal.PluginLifecycleSupport");
                this.supportInstance = support.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.notifyOnAddition = support.getDeclaredMethod("notifyPluginListenersOnAddition", ModuleLayer.class, String.class, ModuleLayer.class);
                this.notifyOnRemoval = support.getDeclaredMethod("notifyPluginListenersOnRemoval", ModuleLayer.class, String.class, ModuleLayer.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ExecutorService executor = Executors.newFixedThreadPool(pluginsDirectories.size());
            for (PluginsDirectory pluginDirectory : pluginsDirectories) {
                executor.execute(() -> {
                    try {
                        DirectoryWatcher watcher = DirectoryWatcher.builder().path(pluginDirectory.getDirectory()).listener(event -> this.onDirectoryChange(event, pluginDirectory)).build();
                        watcher.watch();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                executor.shutdownNow();
                try {
                    if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                        System.out.println("Executor did not terminate in the specified time.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }));
        }

        private void onDirectoryChange(DirectoryChangeEvent event, PluginsDirectory pluginDirectory) {
            Matcher matcher = PLUGIN_ARTIFACT_PATTERN.matcher(event.path().getFileName().toString());
            if (!matcher.matches()) {
                return;
            }
            String pluginArtifactId = matcher.group(1);
            String pluginVersion = matcher.group(2);
            String derivedFrom = pluginDirectory.getName();
            String pluginName = String.join((CharSequence)"-", derivedFrom, pluginArtifactId, pluginVersion);
            if (event.eventType() == DirectoryChangeEvent.EventType.CREATE) {
                if (LayersImpl.this.moduleLayers.containsKey(pluginName)) {
                    return;
                }
                PluginLayerAddedEvent jfrEvent = new PluginLayerAddedEvent();
                jfrEvent.begin();
                Path pluginDir = LayersImpl.this.pluginsWorkingDir.resolve(LayersImpl.this.pluginIndex++ + "-" + pluginName);
                List<Path> modulePathEntries = LayersImpl.this.unpackPluginArtifact(event.path(), pluginDir);
                List<ModuleLayer> parentLayers = LayersImpl.this.getParentLayers(pluginName, pluginDirectory.getParents());
                ModuleLayer moduleLayer = LayersImpl.this.createModuleLayer(parentLayers, modulePathEntries);
                LayersImpl.this.moduleLayers.put(pluginName, moduleLayer);
                this.deploy(pluginName, moduleLayer);
                jfrEvent.name = pluginName;
                jfrEvent.modules = moduleLayer.modules().stream().map(Module::getName).collect(Collectors.joining(", "));
                jfrEvent.commit();
            } else if (event.eventType() == DirectoryChangeEvent.EventType.DELETE) {
                if (!LayersImpl.this.moduleLayers.containsKey(pluginName)) {
                    return;
                }
                PluginLayerRemovedEvent jfrEvent = new PluginLayerRemovedEvent();
                jfrEvent.begin();
                ModuleLayer pluginLayer = LayersImpl.this.moduleLayers.get(pluginName);
                this.undeploy(pluginName, pluginLayer);
                LayersImpl.this.moduleLayers.remove(pluginName);
                jfrEvent.name = pluginName;
                jfrEvent.modules = pluginLayer.modules().stream().map(Module::getName).collect(Collectors.joining(", "));
                jfrEvent.commit();
            }
        }

        public void deploy(String pluginName, ModuleLayer pluginLayer) {
            for (ModuleLayer moduleLayer : LayersImpl.this.moduleLayers.values()) {
                try {
                    this.notifyOnAddition.invoke(this.supportInstance, moduleLayer, pluginName, pluginLayer);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }

        public void undeploy(String pluginName, ModuleLayer pluginLayer) {
            for (ModuleLayer moduleLayer : LayersImpl.this.moduleLayers.values()) {
                try {
                    this.notifyOnRemoval.invoke(this.supportInstance, moduleLayer, pluginName, pluginLayer);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }

        private ModuleLayer getLayrryPlatformLayer(Map<String, ModuleLayer> moduleLayers) {
            for (Map.Entry<String, ModuleLayer> layer : moduleLayers.entrySet()) {
                Optional<Module> platformModule = layer.getValue().modules().stream().filter(m -> m.getName().equals("org.moditect.layrry.platform")).findFirst();
                if (!platformModule.isPresent()) continue;
                return layer.getValue();
            }
            throw new IllegalArgumentException("Layrry Platform module not found");
        }
    }
}

