/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.internal.resolver;

import java.nio.file.Path;
import java.util.Collection;
import org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.moditect.layrry.internal.resolver.ConfigurableRemoteArtifactResolverSystem;
import org.moditect.layrry.internal.resolver.EmptyFormatStage;
import org.moditect.layrry.internal.resolver.RemoteResolve;

public class ConfigurableRemoteArtifactResolverSystemImpl
implements ConfigurableRemoteArtifactResolverSystem {
    private final ConfigurableMavenResolverSystem delegate;
    private boolean enabled = true;

    public ConfigurableRemoteArtifactResolverSystemImpl(ConfigurableMavenResolverSystem delegate) {
        this.delegate = delegate;
    }

    @Override
    public RemoteResolve enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public RemoteResolve fromFile(Path file) throws IllegalArgumentException, InvalidConfigurationFileException {
        this.delegate.fromFile(file.toFile());
        return this;
    }

    @Override
    public RemoteResolve workOffline(boolean workOffline) {
        this.delegate.workOffline(workOffline);
        return this;
    }

    @Override
    public RemoteResolve withMavenCentralRepo(boolean useMavenCentral) {
        this.delegate.withMavenCentralRepo(useMavenCentral);
        return this;
    }

    @Override
    public MavenFormatStage resolve() throws IllegalStateException, ResolutionException {
        if (!this.enabled) {
            return new EmptyFormatStage();
        }
        return (MavenFormatStage)((MavenStrategyStage)this.delegate.resolve()).withoutTransitivity();
    }

    @Override
    public MavenFormatStage resolve(String canonicalForm) throws IllegalArgumentException, ResolutionException, CoordinateParseException {
        if (!this.enabled) {
            return new EmptyFormatStage();
        }
        return (MavenFormatStage)((MavenStrategyStage)this.delegate.resolve(canonicalForm)).withoutTransitivity();
    }

    @Override
    public MavenFormatStage resolve(String ... canonicalForms) throws IllegalArgumentException, ResolutionException, CoordinateParseException {
        if (!this.enabled) {
            return new EmptyFormatStage();
        }
        return (MavenFormatStage)((MavenStrategyStage)this.delegate.resolve(canonicalForms)).withoutTransitivity();
    }

    @Override
    public MavenFormatStage resolve(Collection<String> canonicalForms) throws IllegalArgumentException, ResolutionException, CoordinateParseException {
        if (!this.enabled) {
            return new EmptyFormatStage();
        }
        return (MavenFormatStage)((MavenStrategyStage)this.delegate.resolve(canonicalForms)).withoutTransitivity();
    }
}

