/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.internal.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class FilesHelper {
    private FilesHelper() {
    }

    public static void copyFolder(Path src, Path dest) {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> FilesHelper.copy(source, dest.resolve(src.relativize((Path)source))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copy(Path source, Path dest) {
        try {
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void unpack(Path src, Path dest) {
        File destinationDir = dest.toFile();
        try (InputStream fi = Files.newInputStream(src, new OpenOption[0]);
             BufferedInputStream bi = new BufferedInputStream(fi);
             ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream(bi);){
            String filename = src.getFileName().toString();
            filename = filename.substring(0, filename.length() - 4);
            FilesHelper.unpack(filename + "/", destinationDir, in);
        }
        catch (IOException | ArchiveException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void unpackCompressed(Path src, Path dest) {
        File destinationDir = dest.toFile();
        try (InputStream fi = Files.newInputStream(src, new OpenOption[0]);
             BufferedInputStream bi = new BufferedInputStream(fi);
             GzipCompressorInputStream gzi = new GzipCompressorInputStream(bi);
             TarArchiveInputStream in = new TarArchiveInputStream(gzi);){
            String filename = src.getFileName().toString();
            filename = filename.substring(0, filename.length() - 7);
            FilesHelper.unpack(filename + "/", destinationDir, in);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void unpack(String basename, File destinationDir, ArchiveInputStream in) throws IOException {
        ArchiveEntry entry = null;
        while ((entry = in.getNextEntry()) != null) {
            if (!in.canReadEntryData(entry)) continue;
            String entryName = entry.getName();
            if (entryName.startsWith(basename) && entryName.length() > basename.length() + 1) {
                entryName = entryName.substring(basename.length());
            }
            File file = new File(destinationDir, entryName);
            String destDirPath = destinationDir.getCanonicalPath();
            String destFilePath = file.getCanonicalPath();
            if (!destFilePath.startsWith(destDirPath + File.separator)) {
                throw new IOException("Entry is outside of the target dir: " + entry.getName());
            }
            if (entry.isDirectory()) {
                if (file.isDirectory() || file.mkdirs()) continue;
                throw new IOException("failed to create directory " + file);
            }
            File parent = file.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException("failed to create directory " + parent);
            }
            OutputStream o = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            try {
                IOUtils.copy(in, o);
            }
            finally {
                if (o == null) continue;
                o.close();
            }
        }
    }
}

