/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.launcher;

import com.beust.jcommander.JCommander;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.moditect.layrry.Layrry;
import org.moditect.layrry.launcher.internal.Args;

public final class LayrryLauncher {
    public static void main(String ... args) throws Exception {
        LayrryLauncher.launch(args);
    }

    public static void launch(String ... args) throws Exception {
        Args arguments = new Args();
        JCommander.newBuilder().addObject(arguments).build().parse(args);
        String[] parsedArgs = arguments.getMainArgs().toArray(new String[0]);
        File basedir = arguments.getBasedir();
        String propertiesFile = arguments.getProperties();
        URL propertiesFileUrl = LayrryLauncher.toUrl(propertiesFile);
        String layersConfig = arguments.getLayersConfig();
        URL layersConfigUrl = LayrryLauncher.toUrl(layersConfig);
        if (null != layersConfigUrl) {
            if (basedir == null) {
                basedir = new File(System.getProperty("user.dir"));
            }
            if (null == propertiesFile) {
                Layrry.run(layersConfigUrl, basedir.toPath(), parsedArgs);
            } else if (null != propertiesFileUrl) {
                Layrry.run(layersConfigUrl, basedir.toPath(), propertiesFileUrl, parsedArgs);
            } else {
                Layrry.run(layersConfigUrl, basedir.toPath(), Paths.get(propertiesFile, new String[0]).toAbsolutePath(), parsedArgs);
            }
        } else {
            Path layersConfigPath = Paths.get(layersConfig, new String[0]).toAbsolutePath();
            Path basedirPath = layersConfigPath.getParent();
            if (null != basedir) {
                basedirPath = basedir.toPath();
            }
            if (null == propertiesFile) {
                Layrry.run(layersConfigPath, basedirPath, parsedArgs);
            } else if (null != propertiesFileUrl) {
                Layrry.run(layersConfigPath, basedirPath, propertiesFileUrl, parsedArgs);
            } else {
                Layrry.run(layersConfigPath, basedirPath, Paths.get(propertiesFile, new String[0]).toAbsolutePath(), parsedArgs);
            }
        }
    }

    private static URL toUrl(String input) {
        try {
            return new URL(input);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

