/*
 * Decompiled with CFR 0.152.
 */
package com.github.jezza;

import com.github.jezza.TomlArray;
import com.github.jezza.util.Strings;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class TomlTable {
    private final Map<String, Object> table;

    public TomlTable() {
        this(new LinkedHashMap<String, Object>(0));
    }

    public TomlTable(int initialCapacity) {
        this(new LinkedHashMap<String, Object>(initialCapacity));
    }

    public TomlTable(int initialCapacity, float loadFactor) {
        this(new LinkedHashMap<String, Object>(initialCapacity, loadFactor));
    }

    public TomlTable(Map<String, Object> table) {
        this.table = Objects.requireNonNull(table);
    }

    public Map<String, Object> asMap() {
        return this.table;
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int size() {
        return this.table.size();
    }

    public boolean containsKey(Iterable<String> key) {
        Boolean result = this.locate(false, key, (t, k) -> t.table.containsKey(k));
        return result != null && result != false;
    }

    public Object get(String key) {
        return this.get(Strings.split(key));
    }

    public Object get(Iterable<String> key) {
        return this.locate(false, key, (t, k) -> t.table.get(k));
    }

    public Object put(String key, Object value) {
        return this.put(Strings.split(key), value);
    }

    public Object put(Iterable<String> key, Object value) {
        return this.locate(true, key, (table, k) -> table.table.put((String)k, value));
    }

    public Object remove(String key) {
        return this.remove(Strings.split(key));
    }

    public Object remove(Iterable<String> key) {
        return this.locate(false, key, (t, k) -> t.table.remove(k));
    }

    public Object getOrDefault(String key, Object defaultValue) {
        return this.getOrDefault(Strings.split(key), defaultValue);
    }

    public Object getOrDefault(Iterable<String> key, Object defaultValue) {
        Object value = this.get(key);
        return value != null ? value : defaultValue;
    }

    public void forEach(BiConsumer<? super String, ? super Object> action) {
        this.table.forEach(action);
    }

    public void replaceAll(BiFunction<? super String, ? super Object, ?> function) {
        this.table.replaceAll(function);
    }

    public Object putIfAbsent(String key, Object value) {
        return this.putIfAbsent(Strings.split(key), value);
    }

    public Object putIfAbsent(Iterable<String> key, Object value) {
        return this.locate(true, key, (t, k) -> t.table.putIfAbsent((String)k, value));
    }

    public Object replace(String key, Object value) {
        return this.replace(Strings.split(key), value);
    }

    public Object replace(Iterable<String> key, Object value) {
        return this.locate(false, key, (t, k) -> t.table.replace((String)k, value));
    }

    public boolean replace(String key, Object oldValue, Object newValue) {
        return this.replace(Strings.split(key), oldValue, newValue);
    }

    public boolean replace(Iterable<String> key, Object oldValue, Object newValue) {
        Boolean locate = this.locate(false, key, (t, k) -> t.table.replace((String)k, oldValue, newValue));
        return locate != null && locate != false;
    }

    public Object computeIfAbsent(String key, Function<? super String, ?> mappingFunction) {
        return this.computeIfAbsent(Strings.split(key), mappingFunction);
    }

    public Object computeIfAbsent(Iterable<String> key, Function<? super String, ?> mappingFunction) {
        return this.locate(true, key, (t, k) -> t.table.computeIfAbsent((String)k, (Function<String, Object>)mappingFunction));
    }

    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return this.computeIfPresent(Strings.split(key), remappingFunction);
    }

    public Object computeIfPresent(Iterable<String> key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return this.locate(true, key, (t, k) -> t.table.computeIfPresent((String)k, (BiFunction<String, Object, Object>)remappingFunction));
    }

    public Object compute(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return this.compute(Strings.split(key), remappingFunction);
    }

    public Object compute(Iterable<String> key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return this.locate(true, key, (t, k) -> t.table.compute((String)k, (BiFunction<String, Object, Object>)remappingFunction));
    }

    public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.merge(Strings.split(key), value, remappingFunction);
    }

    public Object merge(Iterable<String> key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.locate(true, key, (t, k) -> t.table.merge((String)k, value, (BiFunction<Object, Object, Object>)remappingFunction));
    }

    public void putAll(TomlTable table) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.table.clear();
    }

    public Set<String> keySet() {
        return this.table.keySet();
    }

    public Collection<Object> values() {
        return this.table.values();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.table.entrySet();
    }

    private <T> T locate(boolean create, Iterable<String> key, BiFunction<? super TomlTable, ? super String, T> action) {
        Iterator<String> it = key.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException("No key given...");
        }
        TomlTable table = this;
        while (true) {
            Object current;
            String s = it.next();
            if (!it.hasNext()) {
                return action.apply(table, s);
            }
            if (create) {
                current = table.table.computeIfAbsent(s, (? super K k) -> new TomlTable());
            } else {
                current = table.table.get(s);
                if (current == null) {
                    return null;
                }
            }
            if (current instanceof TomlArray) {
                current = ((TomlArray)current).get(((TomlArray)current).size() - 1);
            }
            if (!(current instanceof TomlTable)) {
                throw new IllegalStateException("Cannot insert into a non-table value: " + key + ":[" + s + "] => " + current.getClass());
            }
            table = (TomlTable)current;
        }
    }

    void write(StringBuilder b, int indent, int increment) {
        b.append("{\n");
        for (Map.Entry<String, Object> entry : this.table.entrySet()) {
            b.append(" ".repeat(indent * increment)).append(entry.getKey()).append(" = ");
            Object value = entry.getValue();
            if (value instanceof TomlTable) {
                ((TomlTable)value).write(b, indent + increment, increment);
            } else if (value instanceof TomlArray) {
                ((TomlArray)value).write(b, indent + increment, increment);
            } else if (value instanceof TemporalAccessor) {
                TemporalAccessor accessor = (TemporalAccessor)value;
                b.append(accessor.query(TemporalQueries.chronology())).append(':').append(accessor.query(TemporalQueries.localDate())).append(':').append(accessor.query(TemporalQueries.localTime())).append(':').append(accessor.query(TemporalQueries.precision())).append(':').append(accessor.query(TemporalQueries.zone()));
            } else if (value instanceof String) {
                b.append('\"').append(value).append('\"');
            } else {
                b.append(value);
            }
            b.append(',').append('\n');
        }
        int v = (indent - increment) * increment;
        if (v > 0) {
            b.append(" ".repeat(v));
        }
        b.append('}');
    }

    public String toString() {
        StringBuilder b = new StringBuilder("TomlTable ");
        this.write(b, 2, 2);
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TomlTable other = (TomlTable)o;
        return this.table.equals(other.table);
    }

    public int hashCode() {
        return this.table.hashCode();
    }
}

