/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry;

import java.net.URL;
import java.nio.file.Path;
import org.moditect.layrry.Layers;
import org.moditect.layrry.config.LayersConfig;
import org.moditect.layrry.config.LayersConfigLoader;
import org.moditect.layrry.internal.LayersFactory;

public final class Layrry {
    public static void run(URL layersConfigUrl, Path basedir, String ... args) {
        Layrry.launch(basedir, LayersConfigLoader.loadConfig(layersConfigUrl), args);
    }

    public static void run(URL layersConfigUrl, Path basedir, Path propertiesFile, String ... args) {
        if (!propertiesFile.toFile().exists()) {
            throw new IllegalArgumentException("Specified properties config file doesn't exist: " + propertiesFile);
        }
        Layrry.launch(basedir, LayersConfigLoader.loadConfig(layersConfigUrl, propertiesFile), args);
    }

    public static void run(URL layersConfigUrl, Path basedir, URL propertiesFileUrl, String ... args) {
        Layrry.launch(basedir, LayersConfigLoader.loadConfig(layersConfigUrl, propertiesFileUrl), args);
    }

    public static void run(Path layersConfigFile, Path basedir, String ... args) {
        if (!layersConfigFile.toFile().exists()) {
            throw new IllegalArgumentException("Specified layers config file doesn't exist: " + layersConfigFile);
        }
        Layrry.launch(basedir, LayersConfigLoader.loadConfig(layersConfigFile), args);
    }

    public static void run(Path layersConfigFile, Path basedir, Path propertiesFile, String ... args) {
        if (!layersConfigFile.toFile().exists()) {
            throw new IllegalArgumentException("Specified layers config file doesn't exist: " + layersConfigFile);
        }
        if (!propertiesFile.toFile().exists()) {
            throw new IllegalArgumentException("Specified properties config file doesn't exist: " + propertiesFile);
        }
        Layrry.launch(basedir, LayersConfigLoader.loadConfig(layersConfigFile, propertiesFile), args);
    }

    public static void run(Path layersConfigFile, Path basedir, URL propertiesFileUrl, String ... args) {
        if (!layersConfigFile.toFile().exists()) {
            throw new IllegalArgumentException("Specified layers config file doesn't exist: " + layersConfigFile);
        }
        Layrry.launch(basedir, LayersConfigLoader.loadConfig(layersConfigFile, propertiesFileUrl), args);
    }

    private static void launch(Path basedir, LayersConfig layersConfig, String ... args) {
        Layers layers = new LayersFactory().createLayers(layersConfig, basedir);
        layers.run(layersConfig.getMain().getModule() + "/" + layersConfig.getMain().getClazz(), args);
    }
}

