/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.moditect.layrry.LayerBuilder;
import org.moditect.layrry.Layers;
import org.moditect.layrry.internal.LayersBuilderImpl;

public class LayerBuilderImpl
implements LayerBuilder {
    private final LayersBuilderImpl layersBuilder;
    private final String name;
    private final String derivedFrom;
    private Path layerDir;
    private final List<String> moduleGavs;
    private final List<String> parents;

    public LayerBuilderImpl(LayersBuilderImpl layersBuilder, String name, String derivedFrom) {
        this.layersBuilder = layersBuilder;
        this.name = name;
        this.derivedFrom = derivedFrom;
        this.moduleGavs = new ArrayList<String>();
        this.parents = new ArrayList<String>();
    }

    @Override
    public LayerBuilder withModulesIn(Path layerDir) {
        this.layerDir = layerDir;
        return this;
    }

    @Override
    public LayerBuilder withModule(String moduleGav) {
        this.moduleGavs.add(moduleGav);
        return this;
    }

    @Override
    public LayerBuilder withParent(String parent) {
        this.parents.add(parent);
        return this;
    }

    @Override
    public LayerBuilder layer(String name) {
        return this.layersBuilder.layer(name);
    }

    @Override
    public Layers build() {
        return this.layersBuilder.build();
    }

    public Path getLayerDir() {
        return this.layerDir;
    }

    public String getName() {
        return this.name;
    }

    public String getDerivedFrom() {
        return this.derivedFrom;
    }

    public List<String> getModuleGavs() {
        return this.moduleGavs;
    }

    public List<String> getParents() {
        return this.parents;
    }
}

