/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.moditect.layrry.LayerBuilder;
import org.moditect.layrry.Layers;
import org.moditect.layrry.LayersBuilder;
import org.moditect.layrry.LocalResolve;
import org.moditect.layrry.RemoteResolve;
import org.moditect.layrry.internal.Component;
import org.moditect.layrry.internal.LayerBuilderImpl;
import org.moditect.layrry.internal.LayersImpl;
import org.moditect.layrry.internal.PluginsDirectory;

public class LayersBuilderImpl
implements LayersBuilder {
    private LayerBuilderImpl currentLayer;
    private final Map<String, Component> layers = new LinkedHashMap<String, Component>();
    private final Set<PluginsDirectory> pluginsDirectories = new HashSet<PluginsDirectory>();
    private final List<LocalResolve> localResolvers = new ArrayList<LocalResolve>();
    private final List<RemoteResolve> remoteResolvers = new ArrayList<RemoteResolve>();

    @Override
    public LayersBuilder pluginsDirectory(String name, Path directory, List<String> parents) {
        this.pluginsDirectories.add(new PluginsDirectory(name, directory, parents));
        return this;
    }

    @Override
    public LayerBuilder layer(String name) {
        return this.layer(name, null);
    }

    @Override
    public LayerBuilder layer(String name, String derivedFrom) {
        if (this.currentLayer != null) {
            this.addLayer(this.currentLayer);
        }
        this.currentLayer = new LayerBuilderImpl(this, name, derivedFrom);
        return this.currentLayer;
    }

    private void addLayer(LayerBuilderImpl layer) {
        this.layers.put((String)(layer.getDerivedFrom() != null ? layer.getDerivedFrom() + "-" + layer.getName() : layer.getName()), Component.fromLayer(layer));
    }

    @Override
    public LayersBuilder resolve(LocalResolve resolve) {
        if (null != resolve) {
            this.localResolvers.add(resolve);
        }
        return this;
    }

    @Override
    public LayersBuilder resolve(RemoteResolve resolve) {
        if (null != resolve) {
            this.remoteResolvers.add(resolve);
        }
        return this;
    }

    @Override
    public Layers build() {
        if (this.currentLayer != null) {
            this.addLayer(this.currentLayer);
        }
        return new LayersImpl(this.pluginsDirectories, this.layers, this.localResolvers, this.remoteResolvers);
    }
}

