/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.internal;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.moditect.layrry.LayerBuilder;
import org.moditect.layrry.Layers;
import org.moditect.layrry.LayersBuilder;
import org.moditect.layrry.LocalResolve;
import org.moditect.layrry.RemoteResolve;
import org.moditect.layrry.Resolvers;
import org.moditect.layrry.config.Layer;
import org.moditect.layrry.config.LayersConfig;
import org.moditect.layrry.config.Resolve;

public class LayersFactory {
    public Layers createLayers(LayersConfig layersConfig, Path layersConfigDir) {
        LayersBuilder builder = Layers.builder();
        for (Map.Entry<String, Layer> layer : layersConfig.getLayers().entrySet()) {
            if (layer.getValue().getDirectory() != null) {
                this.handlePluginLayer(layer, layersConfigDir, builder);
                continue;
            }
            this.handleLayer(layer, builder);
        }
        return this.configureResolve(layersConfig, layersConfigDir, builder);
    }

    private Layers configureResolve(LayersConfig layersConfig, Path layersConfigDir, LayersBuilder builder) {
        Resolve resolve = layersConfig.getResolve();
        if (resolve == null) {
            return builder.build();
        }
        RemoteResolve remote = Resolvers.remote();
        remote.enabled(resolve.isRemote());
        remote.workOffline(resolve.isWorkOffline());
        remote.withMavenCentralRepo(resolve.isUseMavenCentral());
        String fromFilePath = resolve.getFromFile();
        if (fromFilePath != null && !fromFilePath.isEmpty()) {
            remote.fromFile(layersConfigDir.resolve(resolve.getFromFile()).toAbsolutePath());
        }
        builder.resolve(remote);
        LocalResolve local = Resolvers.local();
        resolve.getLocalRepositories().forEach((id, repository) -> local.withLocalRepo((String)id, layersConfigDir.resolve(repository.getPath()), repository.getLayout()));
        builder.resolve(local);
        return builder.build();
    }

    private void handleLayer(Map.Entry<String, Layer> layer, LayersBuilder builder) {
        LayerBuilder layerBuilder = builder.layer(layer.getKey());
        for (String module : layer.getValue().getModules()) {
            layerBuilder.withModule(module);
        }
        for (String parent : layer.getValue().getParents()) {
            layerBuilder.withParent(parent);
        }
    }

    private void handlePluginLayer(Map.Entry<String, Layer> layer, Path layersConfigDir, LayersBuilder builder) {
        Path pluginDirectory = layersConfigDir.resolve(layer.getValue().getDirectory()).normalize();
        if (!Files.isDirectory(pluginDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Specified layer directory doesn't exist: " + pluginDirectory);
        }
        builder.pluginsDirectory(layer.getKey(), pluginDirectory, layer.getValue().getParents());
        LayerBuilder layerBuilder = builder.layer(layer.getKey());
        layerBuilder.withModulesIn(pluginDirectory);
        for (String parent : layer.getValue().getParents()) {
            layerBuilder.withParent(parent);
        }
    }
}

