/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.internal.resolver;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.moditect.layrry.internal.resolver.LocalResolvedArtifact;
import org.moditect.layrry.internal.resolver.LocalResolvedArtifactImpl;

class ArtifactUtils {
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("(.*?)\\-(\\d[\\d+\\.]*?)\\.jar");
    private static final Pattern ARTIFACT_PATTERN2 = Pattern.compile("(.*?)\\-(\\d[\\d+\\-_A-Za-z\\.]*?)\\.jar");

    ArtifactUtils() {
    }

    static LocalResolvedArtifact fromPaths(Path basedir, Path file) {
        String version = file.getParent().toFile().getName();
        String artifactId = file.getParent().getParent().toFile().getName();
        ArrayList<String> parts = new ArrayList<String>();
        Path path = file.getParent().getParent().getParent();
        while (!path.getFileName().equals(basedir.getFileName())) {
            parts.add(path.getFileName().toFile().getName());
            path = path.getParent();
        }
        Collections.reverse(parts);
        String groupId = String.join((CharSequence)".", parts);
        String classifier = null;
        Pattern pattern = Pattern.compile(artifactId + "\\-" + version + "\\-(.*?).jar");
        Matcher matcher = pattern.matcher(file.getFileName().toFile().getName());
        if (matcher.matches()) {
            classifier = matcher.group(1);
        }
        MavenCoordinate mavenCoordinate = MavenCoordinates.createCoordinate(groupId, artifactId, version, PackagingType.JAR, classifier);
        return new LocalResolvedArtifactImpl(mavenCoordinate, file.toFile());
    }

    static LocalResolvedArtifact fromFile(File file) {
        Matcher matcher = ARTIFACT_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            String artifactId = matcher.group(1);
            String version = matcher.group(2);
            MavenCoordinate mavenCoordinate = MavenCoordinates.createCoordinate("*", artifactId, version, PackagingType.JAR, null);
            return new LocalResolvedArtifactImpl(mavenCoordinate, file);
        }
        matcher = ARTIFACT_PATTERN2.matcher(file.getName());
        if (matcher.matches()) {
            String version;
            String artifactId = matcher.group(1);
            LocalResolvedArtifact artifact = ArtifactUtils.resolveFromPomProperties(file, artifactId, version = matcher.group(2));
            if (artifact != null) {
                return artifact;
            }
            MavenCoordinate mavenCoordinate = MavenCoordinates.createCoordinate("*", artifactId, version, PackagingType.JAR, null);
            return new LocalResolvedArtifactImpl(mavenCoordinate, file);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static LocalResolvedArtifact resolveFromPomProperties(File file, String artifactId, String version) {
        try (JarFile jarFile = new JarFile(file);){
            String v;
            Properties props;
            block11: {
                Iterator<JarEntry> iterator = Collections.list(jarFile.entries()).iterator();
                while (iterator.hasNext()) {
                    JarEntry entry = iterator.next();
                    if (!entry.getName().endsWith("pom.properties")) continue;
                    props = new Properties();
                    props.load(jarFile.getInputStream(entry));
                    if (!artifactId.equals(props.getProperty("artifactId")) || !version.startsWith(v = props.getProperty("version"))) {
                        continue;
                    }
                    break block11;
                }
                return null;
            }
            String classifier = null;
            if (!v.equals(version) && (classifier = version.substring(v.length())).startsWith("-")) {
                classifier = classifier.substring(1);
            }
            MavenCoordinate mavenCoordinate = MavenCoordinates.createCoordinate(props.getProperty("groupId"), artifactId, v, PackagingType.JAR, classifier);
            LocalResolvedArtifactImpl localResolvedArtifactImpl = new LocalResolvedArtifactImpl(mavenCoordinate, file);
            return localResolvedArtifactImpl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static boolean coordinatesMatch(MavenCoordinate a, MavenCoordinate b) {
        if (a.equals(b) && a.getVersion().equals(b.getVersion())) {
            return true;
        }
        if ("*".equals(a.getGroupId()) || "*".equals(b.getGroupId())) {
            a = MavenCoordinates.createCoordinate("*", a.getArtifactId(), a.getVersion(), a.getPackaging(), a.getClassifier());
            b = MavenCoordinates.createCoordinate("*", b.getArtifactId(), b.getVersion(), b.getPackaging(), b.getClassifier());
        }
        if (a.equals(b) && a.getVersion().equals(b.getVersion())) {
            return true;
        }
        String ac = a.getClassifier();
        String bc = b.getClassifier();
        if (!ArtifactUtils.isBlank(bc) && ArtifactUtils.isBlank(ac)) {
            b = MavenCoordinates.createCoordinate(b.getGroupId(), b.getArtifactId(), b.getVersion() + "-" + bc, b.getPackaging(), null);
        }
        return a.equals(b) && a.getVersion().equals(b.getVersion());
    }

    private static boolean isBlank(String s) {
        return s == null || s.isBlank();
    }
}

