/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.internal.resolver;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.moditect.layrry.internal.resolver.ConfigurableLocalArtifactResolverSystem;
import org.moditect.layrry.internal.resolver.LocalFormatStage;
import org.moditect.layrry.internal.resolver.LocalFormatStageImpl;
import org.moditect.layrry.internal.resolver.LocalRepositories;
import org.moditect.layrry.internal.resolver.LocalRepository;
import org.moditect.layrry.internal.resolver.LocalResolvedArtifact;

public class ConfigurableLocalArtifactResolverSystemImpl
implements ConfigurableLocalArtifactResolverSystem {
    private final Map<String, LocalRepository> localRepositories = new LinkedHashMap<String, LocalRepository>();

    public String toString() {
        return "ConfigurableLocalArtifactResolverSystem[repositories=" + this.localRepositories + "]";
    }

    @Override
    public ConfigurableLocalArtifactResolverSystem withLocalRepo(String id, String path, String layout) {
        this.withLocalRepo(LocalRepositories.createLocalRepository(id, path, layout));
        return this;
    }

    @Override
    public ConfigurableLocalArtifactResolverSystem withLocalRepo(String id, Path path, String layout) {
        this.withLocalRepo(LocalRepositories.createLocalRepository(id, path, layout));
        return this;
    }

    @Override
    public ConfigurableLocalArtifactResolverSystem withLocalRepo(LocalRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException("Repository must not be null");
        }
        if (this.localRepositories.containsKey(repository.getId())) {
            throw new IllegalArgumentException("Repository id must be unique. '" + repository.getId() + "'");
        }
        this.localRepositories.put(repository.getId(), repository);
        return this;
    }

    @Override
    public LocalFormatStage resolve() throws IllegalStateException, ResolutionException {
        ArrayList<LocalResolvedArtifact> artifacts = new ArrayList<LocalResolvedArtifact>();
        for (LocalRepository repository : this.localRepositories.values()) {
            artifacts.addAll(repository.resolve());
        }
        return new LocalFormatStageImpl(artifacts);
    }

    @Override
    public LocalFormatStage resolve(String canonicalForm) throws IllegalArgumentException, ResolutionException, CoordinateParseException {
        ArrayList<LocalResolvedArtifact> artifacts = new ArrayList<LocalResolvedArtifact>();
        for (LocalRepository repository : this.localRepositories.values()) {
            artifacts.addAll(repository.resolve(canonicalForm));
        }
        return new LocalFormatStageImpl(artifacts);
    }

    @Override
    public LocalFormatStage resolve(String ... canonicalForms) throws IllegalArgumentException, ResolutionException, CoordinateParseException {
        ArrayList<LocalResolvedArtifact> artifacts = new ArrayList<LocalResolvedArtifact>();
        for (LocalRepository repository : this.localRepositories.values()) {
            artifacts.addAll(repository.resolve(canonicalForms));
        }
        return new LocalFormatStageImpl(artifacts);
    }

    @Override
    public LocalFormatStage resolve(Collection<String> canonicalForms) throws IllegalArgumentException, ResolutionException, CoordinateParseException {
        ArrayList<LocalResolvedArtifact> artifacts = new ArrayList<LocalResolvedArtifact>();
        for (LocalRepository repository : this.localRepositories.values()) {
            artifacts.addAll(repository.resolve(canonicalForms));
        }
        return new LocalFormatStageImpl(artifacts);
    }
}

