/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.internal.resolver;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.moditect.layrry.internal.resolver.ArtifactUtils;
import org.moditect.layrry.internal.resolver.LocalRepository;
import org.moditect.layrry.internal.resolver.LocalResolvedArtifact;

public class DefaultLocalRepository
implements LocalRepository {
    private String id;
    private Path path;

    DefaultLocalRepository(String id, String path) {
        this(id, Paths.get(path, new String[0]));
    }

    DefaultLocalRepository(String id, Path path) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        this.id = id;
        this.path = path;
    }

    public String toString() {
        return "DefaultLocalRepository[id=" + this.id + ", path=" + this.path + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return "default";
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public Collection<LocalResolvedArtifact> resolve() throws IllegalStateException, ResolutionException {
        return this.getLocalMavenResolvedArtifacts().collect(Collectors.toSet());
    }

    @Override
    public Collection<LocalResolvedArtifact> resolve(String canonicalForm) throws IllegalStateException, ResolutionException {
        MavenCoordinate mavenCoordinate = MavenCoordinates.createCoordinate(canonicalForm);
        return this.getLocalMavenResolvedArtifacts().filter(a -> ArtifactUtils.coordinatesMatch(a.getCoordinate(), mavenCoordinate)).collect(Collectors.toSet());
    }

    @Override
    public Collection<LocalResolvedArtifact> resolve(String ... canonicalForms) throws IllegalStateException, ResolutionException {
        if (canonicalForms == null || canonicalForms.length == 0) {
            return Collections.emptySet();
        }
        Set mavenCoordinates = Arrays.stream(canonicalForms).map(MavenCoordinates::createCoordinate).collect(Collectors.toSet());
        return this.getLocalMavenResolvedArtifacts().filter(a -> mavenCoordinates.stream().anyMatch(m -> ArtifactUtils.coordinatesMatch(a.getCoordinate(), m))).collect(Collectors.toSet());
    }

    @Override
    public Collection<LocalResolvedArtifact> resolve(Collection<String> canonicalForms) throws IllegalStateException, ResolutionException {
        if (canonicalForms == null || canonicalForms.isEmpty()) {
            return Collections.emptySet();
        }
        Set mavenCoordinates = canonicalForms.stream().map(MavenCoordinates::createCoordinate).collect(Collectors.toSet());
        return this.getLocalMavenResolvedArtifacts().filter(a -> mavenCoordinates.stream().anyMatch(m -> ArtifactUtils.coordinatesMatch(a.getCoordinate(), m))).collect(Collectors.toSet());
    }

    private Stream<LocalResolvedArtifact> getLocalMavenResolvedArtifacts() {
        try {
            return Files.walk(this.path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toFile().getName().endsWith(".jar")).map(this::toLocalMavenResolvedArtifact);
        }
        catch (IOException e) {
            return Collections.emptySet().stream();
        }
    }

    private LocalResolvedArtifact toLocalMavenResolvedArtifact(Path file) {
        return ArtifactUtils.fromPaths(this.path, file);
    }
}

