/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.internal.resolver;

import java.nio.file.Path;
import org.moditect.layrry.internal.resolver.DefaultLocalRepository;
import org.moditect.layrry.internal.resolver.FlatLocalRepository;
import org.moditect.layrry.internal.resolver.LocalRepository;

public final class LocalRepositories {
    private LocalRepositories() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    public static LocalRepository createLocalRepository(String id, Path path, String layout) {
        if ("flat".equals(layout)) {
            return new FlatLocalRepository(id, path);
        }
        if ("default".equals(layout)) {
            return new DefaultLocalRepository(id, path);
        }
        throw new IllegalArgumentException("layout must be 'default' or 'flat.");
    }

    public static LocalRepository createLocalRepository(String id, String path, String layout) throws IllegalArgumentException {
        if ("flat".equals(layout)) {
            return new FlatLocalRepository(id, path);
        }
        if ("default".equals(layout)) {
            return new DefaultLocalRepository(id, path);
        }
        throw new IllegalArgumentException("layout must be 'default' or 'flat.");
    }
}

