/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.layrry.launcher;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.moditect.layrry.Layrry;
import org.moditect.layrry.config.LayersConfigParser;
import org.moditect.layrry.launcher.internal.Args;

public final class LayrryLauncher {
    public static void main(String ... args) throws Exception {
        LayrryLauncher.launch(args);
    }

    public static void launch(String ... args) throws Exception {
        Args arguments = new Args();
        JCommander jCommander = JCommander.newBuilder().programName(LayrryLauncher.class.getName()).addObject((Object)arguments).build();
        try {
            jCommander.parse(args);
        }
        catch (ParameterException e) {
            LayrryLauncher.printUsage(jCommander);
            return;
        }
        if (arguments.isHelp()) {
            LayrryLauncher.printUsage(jCommander);
            return;
        }
        if (arguments.isVersion()) {
            System.out.println(LayrryLauncher.class.getPackage().getImplementationVersion());
            return;
        }
        String[] parsedArgs = arguments.getMainArgs().toArray(new String[0]);
        File basedir = arguments.getBasedir();
        String propertiesFile = arguments.getProperties();
        URL propertiesFileUrl = LayrryLauncher.toUrl(propertiesFile);
        String layersConfig = arguments.getLayersConfig();
        if (null == layersConfig || layersConfig.isEmpty()) {
            layersConfig = LayrryLauncher.resolveLayersConfigFile(basedir);
        }
        if (null == layersConfig) {
            jCommander.getConsole().println("Missing --layers-config parameter or local file named layers[" + String.join((CharSequence)"|", LayrryLauncher.getSupportedConfigFormats()) + "]");
            jCommander.getConsole().println("");
            LayrryLauncher.printUsage(jCommander);
            return;
        }
        URL layersConfigUrl = LayrryLauncher.toUrl(layersConfig);
        if (null != layersConfigUrl) {
            if (basedir == null) {
                basedir = new File(System.getProperty("user.dir"));
            }
            if (null == propertiesFile) {
                Layrry.run((URL)layersConfigUrl, (Path)basedir.toPath(), (String[])parsedArgs);
            } else if (null != propertiesFileUrl) {
                Layrry.run((URL)layersConfigUrl, (Path)basedir.toPath(), (URL)propertiesFileUrl, (String[])parsedArgs);
            } else {
                Layrry.run((URL)layersConfigUrl, (Path)basedir.toPath(), (Path)Paths.get(propertiesFile, new String[0]).toAbsolutePath(), (String[])parsedArgs);
            }
        } else {
            Path layersConfigPath = Paths.get(layersConfig, new String[0]).toAbsolutePath();
            Path basedirPath = layersConfigPath.getParent();
            if (null != basedir) {
                basedirPath = basedir.toPath();
            }
            if (null == propertiesFile) {
                Layrry.run((Path)layersConfigPath, (Path)basedirPath, (String[])parsedArgs);
            } else if (null != propertiesFileUrl) {
                Layrry.run((Path)layersConfigPath, (Path)basedirPath, (URL)propertiesFileUrl, (String[])parsedArgs);
            } else {
                Layrry.run((Path)layersConfigPath, (Path)basedirPath, (Path)Paths.get(propertiesFile, new String[0]).toAbsolutePath(), (String[])parsedArgs);
            }
        }
    }

    private static URL toUrl(String input) {
        try {
            return new URL(input);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static void printUsage(JCommander jCommander) {
        jCommander.usage();
        StringBuilder sb = new StringBuilder("Supported config formats are ").append(LayrryLauncher.getSupportedConfigFormats());
        jCommander.getConsole().println(sb.toString());
    }

    private static Set<String> getSupportedConfigFormats() {
        LinkedHashSet<String> extensions = new LinkedHashSet<String>();
        ServiceLoader<LayersConfigParser> parsers = ServiceLoader.load(LayersConfigParser.class, LayrryLauncher.class.getClassLoader());
        for (LayersConfigParser parser : parsers) {
            extensions.add("." + parser.getPreferredFileExtension());
        }
        return extensions;
    }

    private static String resolveLayersConfigFile(File basedir) {
        if (basedir == null) {
            basedir = new File(System.getProperty("user.dir"));
        }
        ServiceLoader<LayersConfigParser> parsers = ServiceLoader.load(LayersConfigParser.class, LayrryLauncher.class.getClassLoader());
        for (LayersConfigParser parser : parsers) {
            File layersConfigFile = new File(basedir, "layers." + parser.getPreferredFileExtension());
            if (!layersConfigFile.exists()) continue;
            return layersConfigFile.getAbsolutePath();
        }
        return null;
    }
}

