/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.moments;

import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import lombok.Generated;
import lombok.NonNull;
import org.jmolecules.event.types.DomainEvent;
import org.moduliths.moments.Quarter;
import org.moduliths.moments.ShiftedQuarter;

public final class QuarterHasPassed
implements DomainEvent {
    @NonNull
    private final Year year;
    @NonNull
    private final ShiftedQuarter quarter;

    public static QuarterHasPassed of(Year year, Quarter quarter) {
        return QuarterHasPassed.of(year, ShiftedQuarter.of(quarter));
    }

    public static QuarterHasPassed of(Year year, Quarter quarter, Month startMonth) {
        return QuarterHasPassed.of(year, ShiftedQuarter.of(quarter, startMonth));
    }

    public LocalDate getStartDate() {
        return this.quarter.getStartDate(this.year);
    }

    public LocalDate getEndDate() {
        return this.quarter.getEndDate(this.year);
    }

    @Generated
    private QuarterHasPassed(@NonNull Year year, @NonNull ShiftedQuarter quarter) {
        if (year == null) {
            throw new IllegalArgumentException("year is marked non-null but is null");
        }
        if (quarter == null) {
            throw new IllegalArgumentException("quarter is marked non-null but is null");
        }
        this.year = year;
        this.quarter = quarter;
    }

    @Generated
    public static QuarterHasPassed of(@NonNull Year year, @NonNull ShiftedQuarter quarter) {
        return new QuarterHasPassed(year, quarter);
    }

    @NonNull
    @Generated
    public Year getYear() {
        return this.year;
    }

    @NonNull
    @Generated
    public ShiftedQuarter getQuarter() {
        return this.quarter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuarterHasPassed)) {
            return false;
        }
        QuarterHasPassed other = (QuarterHasPassed)o;
        Year this$year = this.getYear();
        Year other$year = other.getYear();
        if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
            return false;
        }
        ShiftedQuarter this$quarter = this.getQuarter();
        ShiftedQuarter other$quarter = other.getQuarter();
        return !(this$quarter == null ? other$quarter != null : !((Object)this$quarter).equals(other$quarter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Year $year = this.getYear();
        result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
        ShiftedQuarter $quarter = this.getQuarter();
        result = result * 59 + ($quarter == null ? 43 : ((Object)$quarter).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QuarterHasPassed(year=" + this.getYear() + ", quarter=" + this.getQuarter() + ")";
    }
}

