/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.moments;

import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.moduliths.moments.Quarter;
import org.springframework.util.Assert;

public final class ShiftedQuarter {
    private static final MonthDay FIRST_DAY = MonthDay.of(Month.JANUARY, 1);
    private static final MonthDay LAST_DAY = MonthDay.of(Month.DECEMBER, 31);
    @NonNull
    private final Quarter quarter;
    @NonNull
    private final Month startMonth;

    public static ShiftedQuarter of(Quarter quarter) {
        return new ShiftedQuarter(quarter, Month.JANUARY);
    }

    public ShiftedQuarter next() {
        return new ShiftedQuarter(this.quarter.next(), this.startMonth);
    }

    public boolean contains(LocalDate date) {
        Assert.notNull((Object)date, (String)"Reference date must not be null!");
        MonthDay shiftedStart = this.getStart();
        MonthDay shiftedEnd = this.getEnd();
        MonthDay reference = MonthDay.from(date);
        Stream<Range> ranges = shiftedEnd.isAfter(shiftedStart) ? Stream.of(Range.of(shiftedStart, shiftedEnd)) : Stream.of(Range.of(shiftedStart, LAST_DAY), Range.of(FIRST_DAY, shiftedEnd));
        return ranges.anyMatch(it -> it.contains(reference));
    }

    public MonthDay getStart() {
        return this.getShifted(this.quarter.getStart());
    }

    public MonthDay getEnd() {
        return this.getShifted(this.quarter.getEnd());
    }

    public boolean isLastDay(LocalDate date) {
        return MonthDay.from(date).equals(this.getEnd());
    }

    public LocalDate getStartDate(Year year) {
        Assert.notNull((Object)year, (String)"Year must not be null!");
        return this.quarter.getStart().atYear(year.getValue()).plusMonths(this.startMonth.getValue() - 1);
    }

    public LocalDate getEndDate(Year year) {
        Assert.notNull((Object)year, (String)"Year must not be null!");
        return this.getStartDate(year).plusMonths(3L).minusDays(1L);
    }

    private MonthDay getShifted(MonthDay source) {
        return source.with(source.getMonth().plus(this.startMonth.getValue() - 1));
    }

    @Generated
    private ShiftedQuarter(@NonNull Quarter quarter, @NonNull Month startMonth) {
        if (quarter == null) {
            throw new IllegalArgumentException("quarter is marked non-null but is null");
        }
        if (startMonth == null) {
            throw new IllegalArgumentException("startMonth is marked non-null but is null");
        }
        this.quarter = quarter;
        this.startMonth = startMonth;
    }

    @Generated
    public static ShiftedQuarter of(@NonNull Quarter quarter, @NonNull Month startMonth) {
        return new ShiftedQuarter(quarter, startMonth);
    }

    @NonNull
    @Generated
    public Quarter getQuarter() {
        return this.quarter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShiftedQuarter)) {
            return false;
        }
        ShiftedQuarter other = (ShiftedQuarter)o;
        Quarter this$quarter = this.getQuarter();
        Quarter other$quarter = other.getQuarter();
        if (this$quarter == null ? other$quarter != null : !((Object)((Object)this$quarter)).equals((Object)other$quarter)) {
            return false;
        }
        Month this$startMonth = this.startMonth;
        Month other$startMonth = other.startMonth;
        return !(this$startMonth == null ? other$startMonth != null : !this$startMonth.equals(other$startMonth));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Quarter $quarter = this.getQuarter();
        result = result * 59 + ($quarter == null ? 43 : ((Object)((Object)$quarter)).hashCode());
        Month $startMonth = this.startMonth;
        result = result * 59 + ($startMonth == null ? 43 : $startMonth.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ShiftedQuarter(quarter=" + (Object)((Object)this.getQuarter()) + ", startMonth=" + this.startMonth + ")";
    }

    private static final class Range {
        private final MonthDay start;
        private final MonthDay end;

        public boolean contains(MonthDay day) {
            boolean isAfterStart = this.start.equals(day) || this.start.isBefore(day);
            boolean isBeforeEnd = this.end.equals(day) || this.end.isAfter(day);
            return isAfterStart && isBeforeEnd;
        }

        @Generated
        private Range(MonthDay start, MonthDay end) {
            this.start = start;
            this.end = end;
        }

        @Generated
        public static Range of(MonthDay start, MonthDay end) {
            return new Range(start, end);
        }

        @Generated
        public MonthDay getStart() {
            return this.start;
        }

        @Generated
        public MonthDay getEnd() {
            return this.end;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            MonthDay this$start = this.getStart();
            MonthDay other$start = other.getStart();
            if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
                return false;
            }
            MonthDay this$end = this.getEnd();
            MonthDay other$end = other.getEnd();
            return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MonthDay $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
            MonthDay $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ShiftedQuarter.Range(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
        }
    }
}

