/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.moments.autoconfigure;

import java.time.Clock;
import org.moduliths.moments.support.Moments;
import org.moduliths.moments.support.MomentsProperties;
import org.moduliths.moments.support.TimeMachine;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@EnableConfigurationProperties(value={MomentsProperties.class})
@ConditionalOnProperty(name={"moduliths.moments.enabled"}, havingValue="true", matchIfMissing=true)
@Configuration(proxyBeanMethods=false)
class MomentsAutoConfiguration {
    MomentsAutoConfiguration() {
    }

    @Bean
    @ConditionalOnProperty(name={"moduliths.moments.enable-time-machine"}, havingValue="false", matchIfMissing=true)
    Moments moments(ObjectProvider<Clock> clockProvider, ApplicationEventPublisher events, MomentsProperties properties) {
        Clock clock = (Clock)clockProvider.getIfAvailable(() -> Clock.systemUTC());
        return new Moments(clock, events, properties);
    }

    @Bean
    @ConditionalOnProperty(name={"moduliths.moments.enable-time-machine"}, havingValue="true", matchIfMissing=false)
    TimeMachine timeMachine(ObjectProvider<Clock> clockProvider, ApplicationEventPublisher events, MomentsProperties properties) {
        Clock clock = (Clock)clockProvider.getIfAvailable(() -> Clock.systemUTC());
        return new TimeMachine(clock, events, properties);
    }
}

