/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.moments.support;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import lombok.Generated;
import lombok.NonNull;
import org.moduliths.moments.DayHasPassed;
import org.moduliths.moments.HourHasPassed;
import org.moduliths.moments.MonthHasPassed;
import org.moduliths.moments.QuarterHasPassed;
import org.moduliths.moments.ShiftedQuarter;
import org.moduliths.moments.WeekHasPassed;
import org.moduliths.moments.YearHasPassed;
import org.moduliths.moments.support.MomentsProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.annotation.Scheduled;

public class Moments {
    private static final MonthDay DEC_31ST = MonthDay.of(Month.DECEMBER, 31);
    @NonNull
    private final Clock clock;
    @NonNull
    private final ApplicationEventPublisher events;
    @NonNull
    private final MomentsProperties properties;
    private Duration shift = Duration.ZERO;

    @Scheduled(cron="@hourly")
    void everyHour() {
        if (this.properties.isHourly()) {
            this.emitEventsFor(this.now().minusHours(1L));
        }
    }

    @Scheduled(cron="@daily")
    void everyMidnight() {
        this.emitEventsFor(this.now().toLocalDate().minusDays(1L));
    }

    void emitEventsFor(LocalDateTime time) {
        this.events.publishEvent((Object)HourHasPassed.of(time.truncatedTo(ChronoUnit.HOURS)));
    }

    void emitEventsFor(LocalDate date) {
        ShiftedQuarter quarter;
        this.events.publishEvent((Object)DayHasPassed.of(date));
        int week = this.getWeekOfYear(date);
        Year year = Year.from(date);
        if (this.getWeekOfYear(date.plusDays(1L)) > week) {
            this.events.publishEvent((Object)WeekHasPassed.of(year, week, this.properties.getLocale()));
        }
        if (date.getDayOfMonth() == date.lengthOfMonth()) {
            this.events.publishEvent((Object)MonthHasPassed.of(YearMonth.from(date)));
        }
        if ((quarter = this.properties.getShiftedQuarter(date)).isLastDay(date)) {
            this.events.publishEvent((Object)QuarterHasPassed.of(year, quarter));
        }
        if (MonthDay.from(date).equals(DEC_31ST)) {
            this.events.publishEvent((Object)YearHasPassed.of(year));
        }
    }

    Moments shiftBy(Duration duration) {
        LocalDateTime before = this.now();
        LocalDateTime after = before.plus(duration);
        this.shift = this.shift.plus(duration);
        if (duration.isNegative()) {
            return this;
        }
        LocalDateTime current = before.truncatedTo(ChronoUnit.HOURS);
        boolean hourly = this.properties.isHourly();
        while (current.isBefore(after.truncatedTo(ChronoUnit.HOURS))) {
            LocalDateTime next;
            LocalDateTime localDateTime = next = hourly ? current.plusHours(1L) : current.plusDays(1L);
            if (hourly) {
                this.emitEventsFor(next);
            }
            if (current.toLocalDate().isBefore(next.toLocalDate())) {
                this.emitEventsFor(current.toLocalDate());
            }
            current = next;
        }
        return this;
    }

    LocalDateTime now() {
        Instant instant = this.clock.instant().plus(this.shift);
        return LocalDateTime.ofInstant(instant, this.properties.getZoneId());
    }

    private int getWeekOfYear(LocalDate date) {
        return date.get(WeekFields.of(this.properties.getLocale()).weekOfYear());
    }

    @Generated
    public Moments(@NonNull Clock clock, @NonNull ApplicationEventPublisher events, @NonNull MomentsProperties properties) {
        if (clock == null) {
            throw new IllegalArgumentException("clock is marked non-null but is null");
        }
        if (events == null) {
            throw new IllegalArgumentException("events is marked non-null but is null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        this.clock = clock;
        this.events = events;
        this.properties = properties;
    }
}

