/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.moments;

import java.time.LocalDate;
import java.time.Year;
import java.time.temporal.ChronoField;
import java.time.temporal.WeekFields;
import java.util.Locale;
import lombok.Generated;
import lombok.NonNull;
import org.jmolecules.event.types.DomainEvent;

public final class WeekHasPassed
implements DomainEvent {
    @NonNull
    private final Year year;
    private final int week;
    @NonNull
    private final Locale locale;

    public static WeekHasPassed of(Year year, int week) {
        return WeekHasPassed.of(year, week, Locale.getDefault());
    }

    public LocalDate getStartDate() {
        return LocalDate.of(this.year.getValue(), 1, 1).with(WeekFields.of(this.locale).weekOfYear(), this.week).with(ChronoField.DAY_OF_WEEK, 1L);
    }

    public LocalDate getEndDate() {
        return this.getStartDate().plusDays(6L);
    }

    @Generated
    private WeekHasPassed(@NonNull Year year, int week, @NonNull Locale locale) {
        if (year == null) {
            throw new IllegalArgumentException("year is marked non-null but is null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale is marked non-null but is null");
        }
        this.year = year;
        this.week = week;
        this.locale = locale;
    }

    @Generated
    public static WeekHasPassed of(@NonNull Year year, int week, @NonNull Locale locale) {
        return new WeekHasPassed(year, week, locale);
    }

    @NonNull
    @Generated
    public Year getYear() {
        return this.year;
    }

    @Generated
    public int getWeek() {
        return this.week;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeekHasPassed)) {
            return false;
        }
        WeekHasPassed other = (WeekHasPassed)o;
        if (this.getWeek() != other.getWeek()) {
            return false;
        }
        Year this$year = this.getYear();
        Year other$year = other.getYear();
        if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
            return false;
        }
        Locale this$locale = this.locale;
        Locale other$locale = other.locale;
        return !(this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWeek();
        Year $year = this.getYear();
        result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
        Locale $locale = this.locale;
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WeekHasPassed(year=" + this.getYear() + ", week=" + this.getWeek() + ", locale=" + this.locale + ")";
    }
}

