/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.moments.support;

import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import org.moduliths.moments.Quarter;
import org.moduliths.moments.ShiftedQuarter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.bind.DefaultValue;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="moduliths.moments")
public class MomentsProperties {
    public static final MomentsProperties DEFAULTS = new MomentsProperties(null, null, null, null, false);
    private final Granularity granularity;
    private final ZoneId zoneId;
    private final Locale locale;
    private final boolean enableTimeMachine;
    private final ShiftedQuarters quarters;

    @ConstructorBinding
    private MomentsProperties(@Nullable @DefaultValue(value={"hours"}) Granularity granularity, @Nullable ZoneId zoneId, @Nullable Locale locale, @Nullable Month quarterStartMonth, @DefaultValue(value={"false"}) boolean enableTimeMachine) {
        this.granularity = granularity == null ? Granularity.HOURS : granularity;
        this.zoneId = zoneId == null ? ZoneOffset.UTC : zoneId;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.quarters = ShiftedQuarters.of(quarterStartMonth == null ? Month.JANUARY : quarterStartMonth);
        this.enableTimeMachine = enableTimeMachine;
    }

    boolean isHourly() {
        return Granularity.HOURS.equals((Object)this.granularity);
    }

    public ShiftedQuarter getShiftedQuarter(LocalDate reference) {
        Assert.notNull((Object)reference, (String)"Reference date must not be null!");
        return this.quarters.getCurrent(reference);
    }

    @Generated
    private MomentsProperties(Granularity granularity, ZoneId zoneId, Locale locale, boolean enableTimeMachine, ShiftedQuarters quarters) {
        this.granularity = granularity;
        this.zoneId = zoneId;
        this.locale = locale;
        this.enableTimeMachine = enableTimeMachine;
        this.quarters = quarters;
    }

    @Generated
    public MomentsProperties withGranularity(Granularity granularity) {
        return this.granularity == granularity ? this : new MomentsProperties(granularity, this.zoneId, this.locale, this.enableTimeMachine, this.quarters);
    }

    @Generated
    public MomentsProperties withZoneId(ZoneId zoneId) {
        return this.zoneId == zoneId ? this : new MomentsProperties(this.granularity, zoneId, this.locale, this.enableTimeMachine, this.quarters);
    }

    @Generated
    public ZoneId getZoneId() {
        return this.zoneId;
    }

    @Generated
    public MomentsProperties withLocale(Locale locale) {
        return this.locale == locale ? this : new MomentsProperties(this.granularity, this.zoneId, locale, this.enableTimeMachine, this.quarters);
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public boolean isEnableTimeMachine() {
        return this.enableTimeMachine;
    }

    static enum Granularity {
        HOURS,
        DAYS;

    }

    private static class ShiftedQuarters {
        private final List<ShiftedQuarter> quarters;

        public ShiftedQuarter getCurrent(LocalDate reference) {
            return this.quarters.stream().filter(it -> it.contains(reference)).findFirst().orElseThrow(() -> new IllegalStateException());
        }

        public static ShiftedQuarters of(Month shift) {
            return new ShiftedQuarters(Arrays.stream(Quarter.values()).map(it -> ShiftedQuarter.of(it, shift)).collect(Collectors.toList()));
        }

        @Generated
        public ShiftedQuarters(List<ShiftedQuarter> quarters) {
            this.quarters = quarters;
        }
    }
}

