/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.amazon.bucket.client;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.amazon.bucket.client.AmazonBucketClient;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.excel.ExcelFileExtensions;
import org.molgenis.file.FileStore;
import org.springframework.stereotype.Component;

@Component
public class AmazonBucketClientImpl
implements AmazonBucketClient {
    @Override
    public AmazonS3 getClient(String accessKey, String secretKey, String region) {
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(accessKey, secretKey);
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).withRegion(region)).build();
    }

    @Override
    public File downloadFile(AmazonS3 s3Client, FileStore fileStore, String jobIdentifier, String bucketName, String keyName, String extension, boolean isExpression, String targetEntityType) throws IOException, AmazonClientException {
        String key = isExpression ? this.getMostRecentMatchingKey(s3Client, bucketName, keyName) : keyName;
        S3Object s3Object = s3Client.getObject(new GetObjectRequest(bucketName, key));
        S3ObjectInputStream in = s3Object.getObjectContent();
        return this.storeFile(fileStore, key, extension, targetEntityType, jobIdentifier, (InputStream)in);
    }

    private File storeFile(FileStore fileStore, String key, String extension, String targetEntityName, String jobIdentifier, InputStream in) throws IOException {
        String filename;
        if (!StringUtils.isNotEmpty((CharSequence)extension)) {
            extension = "xlsx";
        }
        String relativePath = "bucket_" + jobIdentifier;
        File folder = new File(fileStore.getStorageDir(), relativePath);
        folder.mkdir();
        if (StringUtils.isNotEmpty((CharSequence)targetEntityName) && !ExcelFileExtensions.getExcel().contains(extension)) {
            filename = String.format("%s%s%s.%s", relativePath, Character.valueOf(File.separatorChar), targetEntityName, extension);
        } else {
            String fileRoot = key.replaceAll("[\\/:*?\"<>|]", "_");
            filename = String.format("%s%s%s.%s", relativePath, Character.valueOf(File.separatorChar), fileRoot, extension);
        }
        return fileStore.store(in, filename);
    }

    private String getMostRecentMatchingKey(AmazonS3 s3Client, String bucketName, String regex) {
        ObjectListing objectListing = s3Client.listObjects(bucketName);
        TreeMap<Date, String> keys = new TreeMap<Date, String>();
        for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
            if (!objectSummary.getKey().matches(regex)) continue;
            keys.put(objectSummary.getLastModified(), objectSummary.getKey());
        }
        if (keys.size() == 0) {
            throw new MolgenisDataException("No key matching regular expression: " + regex);
        }
        return (String)keys.lastEntry().getValue();
    }
}

