/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.amazon.bucket;

import java.util.Objects;
import org.molgenis.amazon.bucket.AmazonBucketIngester;
import org.molgenis.amazon.bucket.meta.AmazonBucketJobExecution;
import org.molgenis.amazon.bucket.meta.AmazonBucketJobExecutionMetadata;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.jobs.Job;
import org.molgenis.jobs.JobFactory;
import org.molgenis.jobs.model.ScheduledJobType;
import org.molgenis.jobs.model.ScheduledJobTypeFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

@Configuration
@Import(value={AmazonBucketIngester.class})
public class AmazonBucketConfig {
    private final AmazonBucketIngester ingester;
    private final ScheduledJobTypeFactory scheduledJobTypeFactory;
    private final AmazonBucketJobExecutionMetadata amazonBucketJobExecutionMetadata;

    public AmazonBucketConfig(AmazonBucketIngester ingester, ScheduledJobTypeFactory scheduledJobTypeFactory, AmazonBucketJobExecutionMetadata amazonBucketJobExecutionMetadata) {
        this.ingester = Objects.requireNonNull(ingester);
        this.scheduledJobTypeFactory = Objects.requireNonNull(scheduledJobTypeFactory);
        this.amazonBucketJobExecutionMetadata = Objects.requireNonNull(amazonBucketJobExecutionMetadata);
    }

    @Bean
    public JobFactory<AmazonBucketJobExecution> amazonBucketJobFactory() {
        return new JobFactory<AmazonBucketJobExecution>(){

            public Job createJob(AmazonBucketJobExecution amazonBucketJobExecution) {
                String targetEntityId = amazonBucketJobExecution.getTargetEntityId();
                String jobExecutionID = amazonBucketJobExecution.getIdentifier();
                String bucket = amazonBucketJobExecution.getBucket();
                String key = amazonBucketJobExecution.getKey();
                String extension = amazonBucketJobExecution.getExtension();
                String accessKey = amazonBucketJobExecution.getAccessKey();
                String secretKey = amazonBucketJobExecution.getSecretKey();
                String region = amazonBucketJobExecution.getRegion();
                boolean isExpression = amazonBucketJobExecution.isExpression();
                return progress -> AmazonBucketConfig.this.ingester.ingest(jobExecutionID, targetEntityId, bucket, key, extension, accessKey, secretKey, region, isExpression, progress);
            }
        };
    }

    @Bean
    @Lazy
    public ScheduledJobType bucketIngest() {
        ScheduledJobType result = (ScheduledJobType)this.scheduledJobTypeFactory.create((Object)"BucketIngest");
        result.setLabel("Bucket ingest");
        result.setDescription("This job downloads a file from a URL and imports it into MOLGENIS.");
        result.setSchema("{'title': 'Bucket Ingest Job','type': 'object','properties': { 'bucket': {'type': 'string', 'description': 'The name of the bucket.'},'key': {'type': 'string', 'description': 'Expression to match the file key'}, 'accessKey': { 'type': 'string', 'description': 'the access key to be used to login to the amazon bucket'},'secretKey': {'type': 'string', 'description': 'the secretkey to be used to login to the amazon bucket'},'expression': {'type': 'boolean', 'description': 'Is the key an expression or an exact match'},'extension': {'type': 'string', 'description': 'Optional extension of the file, is not part of the key in the bucket'},'region': {'type': 'string', 'description': 'The region where the amazon bucket is located'},'targetEntityId': {'type': 'string', 'description': 'Target EntityType ID'}},'required': ['bucket','key','accessKey','secretKey','expression','region']}");
        result.setJobExecutionType((EntityType)this.amazonBucketJobExecutionMetadata);
        return result;
    }
}

