/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.amazon.bucket.meta;

import java.util.Objects;
import org.molgenis.data.file.model.FileMetaMetadata;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.jobs.model.JobExecutionMetaData;
import org.molgenis.jobs.model.JobPackage;
import org.springframework.stereotype.Component;

@Component
public class AmazonBucketJobExecutionMetadata
extends SystemEntityType {
    private static final String SIMPLE_NAME = "AmazonBucketJobExecution";
    public static final String FILE = "file";
    public static final String BUCKET = "bucket";
    public static final String KEY = "key";
    public static final String EXPRESSION = "expression";
    public static final String ACCESS_KEY = "accessKey";
    public static final String SECRET_KEY = "secretKey";
    public static final String TARGET_ENTITY_ID = "targetEntityId";
    public static final String REGION = "region";
    public static final String EXTENSION = "extension";
    private final FileMetaMetadata fileMetaMetadata;
    private final JobExecutionMetaData jobExecutionMetaData;
    private final JobPackage jobPackage;
    public static final String AMAZON_BUCKET_JOB_TYPE = "AmazonBucketJob";

    AmazonBucketJobExecutionMetadata(FileMetaMetadata fileMetaMetadata, JobExecutionMetaData jobExecutionMetaData, JobPackage jobPackage) {
        super(SIMPLE_NAME, "sys_job");
        this.fileMetaMetadata = Objects.requireNonNull(fileMetaMetadata);
        this.jobExecutionMetaData = Objects.requireNonNull(jobExecutionMetaData);
        this.jobPackage = Objects.requireNonNull(jobPackage);
    }

    public void init() {
        this.setLabel("Amazon Bucket file ingest job execution");
        this.setExtends((EntityType)this.jobExecutionMetaData);
        this.setPackage((Package)this.jobPackage);
        this.addAttribute(BUCKET, new EntityType.AttributeRole[0]).setLabel("Bucket name").setDescription("The name of the amazon bucket.").setNillable(false);
        this.addAttribute(KEY, new EntityType.AttributeRole[0]).setLabel("Key").setDescription("Expression to match the file key").setNillable(false);
        this.addAttribute(EXPRESSION, new EntityType.AttributeRole[0]).setDataType(AttributeType.BOOL).setLabel("Is key expression").setDescription("Is the key an expression or an exact match").setNillable(false).setDefaultValue(Boolean.FALSE.toString());
        this.addAttribute(ACCESS_KEY, new EntityType.AttributeRole[0]).setLabel("the access key to be used to login to the amazon bucket").setNillable(false).setVisible(false);
        this.addAttribute(SECRET_KEY, new EntityType.AttributeRole[0]).setLabel("the secret key to be used to login to the amazon bucket").setNillable(false).setVisible(false);
        this.addAttribute(REGION, new EntityType.AttributeRole[0]).setLabel("Region").setDescription("The region of the amazon bucket.").setNillable(false);
        this.addAttribute(TARGET_ENTITY_ID, new EntityType.AttributeRole[0]).setLabel("Target EntityType ID").setNillable(true);
        this.addAttribute(FILE, new EntityType.AttributeRole[0]).setLabel("File").setDescription("The imported file.").setDataType(AttributeType.XREF).setRefEntity((EntityType)this.fileMetaMetadata).setNillable(true);
        this.addAttribute(EXTENSION, new EntityType.AttributeRole[0]).setLabel("Extension").setDescription("Optional extension of the file, is not part of the key in the bucket").setNillable(true);
    }
}

