/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.fair.controller;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Objects;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.IllegalAttributeTypeException;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.semantic.LabeledResource;
import org.molgenis.data.semantic.Relation;
import org.molgenis.data.semantic.SemanticTag;
import org.molgenis.semanticsearch.service.TagService;
import org.springframework.stereotype.Component;

@Component
public class EntityModelWriter {
    private static final String KEYWORD = "http://www.w3.org/ns/dcat#keyword";
    private final IRI rdfTypePredicate;
    private final SimpleValueFactory valueFactory;
    private final TagService<LabeledResource, LabeledResource> tagService;
    private static final DatatypeFactory DATATYPE_FACTORY;

    public EntityModelWriter(TagService<LabeledResource, LabeledResource> tagService, SimpleValueFactory valueFactory) {
        this.valueFactory = Objects.requireNonNull(valueFactory);
        this.tagService = Objects.requireNonNull(tagService);
        this.rdfTypePredicate = valueFactory.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    }

    private void setNamespacePrefixes(Model model) {
        model.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        model.setNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        model.setNamespace("dcat", "http://www.w3.org/ns/dcat#");
        model.setNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
        model.setNamespace("owl", "http://www.w3.org/2002/07/owl#");
        model.setNamespace("dct", "http://purl.org/dc/terms/");
        model.setNamespace("lang", "http://id.loc.gov/vocabulary/iso639-1/");
        model.setNamespace("fdpo", "http://rdf.biosemantics.org/ontologies/fdp-o#");
        model.setNamespace("ldp", "http://www.w3.org/ns/ldp#");
        model.setNamespace("foaf", "http://xmlns.com/foaf/0.1/");
        model.setNamespace("orcid", "http://orcid.org/");
        model.setNamespace("r3d", "http://www.re3data.org/schema/3-0#");
        model.setNamespace("sio", "http://semanticscience.org/resource/");
    }

    public Model createRdfModel(String subjectIRI, Entity objectEntity) {
        Model model = this.createEmptyModel();
        this.addEntityToModel(subjectIRI, objectEntity, model);
        return model;
    }

    public Model createEmptyModel() {
        LinkedHashModel model = new LinkedHashModel();
        this.setNamespacePrefixes((Model)model);
        return model;
    }

    public void addEntityToModel(String subjectIRI, Entity objectEntity, Model model) {
        IRI subject = this.valueFactory.createIRI(subjectIRI);
        EntityType entityType = objectEntity.getEntityType();
        this.addStatementsForAttributeTags(objectEntity, model, (Resource)subject, entityType);
        this.addStatementsForEntityTags(model, (Resource)subject, entityType);
    }

    private void addStatementsForAttributeTags(Entity objectEntity, Model model, Resource subject, EntityType entityType) {
        for (Attribute objectAttribute : entityType.getAtomicAttributes()) {
            Object value = objectEntity.get(objectAttribute.getName());
            if (value == null) continue;
            for (LabeledResource tag : this.tagService.getTagsForAttribute(entityType, objectAttribute).get((Object)Relation.isAssociatedWith)) {
                IRI predicate = this.valueFactory.createIRI(tag.getIri());
                this.addRelationForAttribute(model, subject, predicate, objectEntity, objectAttribute);
            }
        }
    }

    void addStatementsForEntityTags(Model model, Resource subject, EntityType entityType) {
        for (SemanticTag tag : this.tagService.getTagsForEntity(entityType)) {
            if (tag.getRelation() != Relation.isAssociatedWith) continue;
            LabeledResource object = (LabeledResource)tag.getObject();
            model.add(subject, this.rdfTypePredicate, (Value)this.valueFactory.createIRI(object.getIri()), new Resource[0]);
        }
    }

    private void addRelationForAttribute(Model model, Resource subject, IRI predicate, Entity objectEntity, Attribute objectAttribute) {
        String name = objectAttribute.getName();
        AttributeType attributeType = objectAttribute.getDataType();
        switch (attributeType) {
            case MREF: 
            case CATEGORICAL_MREF: {
                this.addRelationForMrefTypeAttribute(model, subject, predicate, objectEntity.getEntities(name));
                break;
            }
            case BOOL: {
                model.add(subject, predicate, (Value)this.valueFactory.createLiteral(objectEntity.getBoolean(name).booleanValue()), new Resource[0]);
                break;
            }
            case DATE: {
                XMLGregorianCalendar calendar = DATATYPE_FACTORY.newXMLGregorianCalendar(objectEntity.getLocalDate(name).toString());
                model.add(subject, predicate, (Value)this.valueFactory.createLiteral(calendar), new Resource[0]);
                break;
            }
            case DATE_TIME: {
                XMLGregorianCalendar calendar = DATATYPE_FACTORY.newXMLGregorianCalendar(objectEntity.getInstant(name).toString());
                model.add(subject, predicate, (Value)this.valueFactory.createLiteral(calendar), new Resource[0]);
                break;
            }
            case DECIMAL: {
                model.add(subject, predicate, (Value)this.valueFactory.createLiteral(objectEntity.getDouble(name).doubleValue()), new Resource[0]);
                break;
            }
            case LONG: {
                model.add(subject, predicate, (Value)this.valueFactory.createLiteral(objectEntity.getLong(name).longValue()), new Resource[0]);
                break;
            }
            case INT: {
                model.add(subject, predicate, (Value)this.valueFactory.createLiteral(objectEntity.getInt(name).intValue()), new Resource[0]);
                break;
            }
            case ENUM: 
            case EMAIL: 
            case HTML: 
            case TEXT: 
            case SCRIPT: 
            case STRING: {
                this.addRelationForStringTypeAttribute(model, subject, predicate, objectEntity.getString(name));
                break;
            }
            case HYPERLINK: {
                model.add(subject, predicate, (Value)this.valueFactory.createIRI(objectEntity.getString(name)), new Resource[0]);
                break;
            }
            case XREF: 
            case CATEGORICAL: 
            case FILE: {
                this.addRelationForXrefTypeAttribute(model, subject, predicate, objectEntity.getEntity(name));
                break;
            }
            default: {
                throw new IllegalAttributeTypeException(attributeType);
            }
        }
    }

    private void addRelationForXrefTypeAttribute(Model model, Resource subject, IRI predicate, Entity objectEntity) {
        if (Iterables.contains((Iterable)objectEntity.getEntityType().getAttributeNames(), (Object)"IRI")) {
            model.add(subject, predicate, (Value)this.valueFactory.createIRI(objectEntity.getString("IRI")), new Resource[0]);
        } else {
            model.add(subject, predicate, (Value)this.valueFactory.createIRI(subject.stringValue() + '/' + objectEntity.getIdValue()), new Resource[0]);
        }
    }

    private void addRelationForStringTypeAttribute(Model model, Resource subject, IRI predicate, String value) {
        if (predicate.stringValue().equals(KEYWORD)) {
            Arrays.stream(value.split(",")).map(String::trim).forEach(keyword -> model.add(subject, predicate, (Value)this.valueFactory.createLiteral(keyword), new Resource[0]));
        } else {
            model.add(subject, predicate, (Value)this.valueFactory.createLiteral(value), new Resource[0]);
        }
    }

    private void addRelationForMrefTypeAttribute(Model model, Resource subject, IRI predicate, Iterable<Entity> objectEntities) {
        for (Entity objectEntity : objectEntities) {
            model.add(subject, predicate, (Value)this.valueFactory.createIRI(subject.stringValue() + '/' + objectEntity.getIdValue()), new Resource[0]);
        }
    }

    static {
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new Error("Could not instantiate javax.xml.datatype.DatatypeFactory", e);
        }
    }
}

