/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.identities;

import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.molgenis.api.identities.AddGroupMemberCommand;
import org.molgenis.api.identities.GroupCommand;
import org.molgenis.api.identities.GroupMemberResponse;
import org.molgenis.api.identities.GroupResponse;
import org.molgenis.api.identities.RoleResponse;
import org.molgenis.api.identities.UpdateGroupMemberCommand;
import org.molgenis.api.identities.UpdateIncludeCommand;
import org.molgenis.api.identities.UserResponse;
import org.molgenis.data.security.GroupIdentity;
import org.molgenis.data.security.auth.Group;
import org.molgenis.data.security.auth.GroupPermission;
import org.molgenis.data.security.auth.GroupPermissionService;
import org.molgenis.data.security.auth.GroupService;
import org.molgenis.data.security.auth.Role;
import org.molgenis.data.security.auth.RoleService;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.exception.GroupNameNotAvailableException;
import org.molgenis.data.security.exception.GroupPermissionDeniedException;
import org.molgenis.data.security.permission.RoleMembershipService;
import org.molgenis.data.security.user.UserService;
import org.molgenis.security.core.GroupValueFactory;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.molgenis.security.core.model.GroupValue;
import org.molgenis.security.core.model.RoleValue;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@Validated
@Api(value="Group")
public class GroupRestController {
    public static final String USER = "/user";
    private static final String SECURITY_API_PATH = "/api/identities";
    static final String GROUP_END_POINT = "/api/identities/group";
    private static final String GROUP_MEMBER_END_POINT = "/api/identities/group/{groupName}/member";
    private static final String ROLE_EXTEND_END_POINT = "/api/identities/group/{groupName}/role";
    private static final String GROUP_PERMISSION_END_POINT = "/api/identities/group/{groupName}/permission";
    static final String TEMP_USER_END_POINT = "/api/identities/user";
    private final GroupValueFactory groupValueFactory;
    private final GroupService groupService;
    private final RoleMembershipService roleMembershipService;
    private final RoleService roleService;
    private final UserService userService;
    private final UserPermissionEvaluator userPermissionEvaluator;
    private final GroupPermissionService groupPermissionService;

    GroupRestController(GroupValueFactory groupValueFactory, GroupService groupService, RoleMembershipService roleMembershipService, RoleService roleService, UserService userService, UserPermissionEvaluator userPermissionEvaluator, GroupPermissionService groupPermissionService) {
        this.groupValueFactory = Objects.requireNonNull(groupValueFactory);
        this.groupService = Objects.requireNonNull(groupService);
        this.roleMembershipService = Objects.requireNonNull(roleMembershipService);
        this.roleService = Objects.requireNonNull(roleService);
        this.userService = Objects.requireNonNull(userService);
        this.userPermissionEvaluator = Objects.requireNonNull(userPermissionEvaluator);
        this.groupPermissionService = Objects.requireNonNull(groupPermissionService);
    }

    @PostMapping(value={"/api/identities/group"})
    @ApiOperation(value="Create a new group", response=ResponseEntity.class)
    @Transactional
    @ApiResponses(value={@ApiResponse(code=201, message="New group created", response=ResponseEntity.class), @ApiResponse(code=400, message="Group name not available", response=ResponseEntity.class)})
    public ResponseEntity createGroup(@RequestBody GroupCommand group) {
        GroupValue groupValue = this.groupValueFactory.createGroup(group.getName(), group.getLabel(), (Collection)GroupService.DEFAULT_ROLES);
        if (!this.groupService.isGroupNameAvailable(groupValue)) {
            throw new GroupNameNotAvailableException(group.getName());
        }
        this.groupService.persist(groupValue);
        this.groupPermissionService.grantDefaultPermissions(groupValue);
        this.roleMembershipService.addUserToRole(SecurityUtils.getCurrentUsername(), this.getManagerRoleName(groupValue));
        URI location = ServletUriComponentsBuilder.fromCurrentRequest().path("/{name}").buildAndExpand(new Object[]{groupValue.getName()}).toUri();
        return ResponseEntity.created((URI)location).build();
    }

    @DeleteMapping(value={"/api/identities/group/{groupName}"})
    @ApiOperation(value="Delete a group", response=ResponseEntity.class)
    @Transactional
    @ApiResponses(value={@ApiResponse(code=204, message="Group deleted", response=ResponseEntity.class)})
    public ResponseEntity deleteGroup(@PathVariable(value="groupName") String groupName) {
        this.groupService.deleteGroup(groupName);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/api/identities/group"})
    @ApiOperation(value="Get list with groups", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=200, message="List of groupResponse object available to user", response=List.class)})
    @ResponseBody
    public List<GroupResponse> getGroups() {
        return this.groupService.getGroups().stream().filter(group -> this.userPermissionEvaluator.hasPermission((ObjectIdentity)new GroupIdentity(group), (Permission)GroupPermission.VIEW)).map(GroupResponse::fromEntity).collect(Collectors.toList());
    }

    @GetMapping(value={"/api/identities/group/{groupName}/member"})
    @ApiOperation(value="Get group members", response=Collection.class)
    @ResponseBody
    public Collection<GroupMemberResponse> getMembers(@PathVariable(value="groupName") String groupName) {
        this.checkGroupPermission(groupName, GroupPermission.VIEW_MEMBERSHIP);
        Iterable roles = this.groupService.getGroup(groupName).getRoles();
        return this.roleMembershipService.getMemberships((Collection)Lists.newArrayList((Iterable)roles)).stream().map(GroupMemberResponse::fromEntity).collect(Collectors.toList());
    }

    @PostMapping(value={"/api/identities/group/{groupName}/member"})
    @ApiOperation(value="Add member to group", response=ResponseEntity.class)
    @Transactional
    @ApiResponses(value={@ApiResponse(code=201, message="Member added to group", response=ResponseEntity.class)})
    public ResponseEntity addMember(@PathVariable(value="groupName") String groupName, @RequestBody AddGroupMemberCommand addMemberCommand) {
        this.checkGroupPermission(groupName, GroupPermission.ADD_MEMBERSHIP);
        Group group = this.groupService.getGroup(groupName);
        String username = addMemberCommand.getUsername();
        String roleName = addMemberCommand.getRoleName();
        Role role = this.roleService.getRole(roleName);
        User user = this.userService.getUser(username);
        this.groupService.addMember(group, user, role);
        URI location = ServletUriComponentsBuilder.fromCurrentRequest().path("/{group}/member/{member}").buildAndExpand(new Object[]{groupName, username}).toUri();
        return ResponseEntity.created((URI)location).build();
    }

    @DeleteMapping(value={"/api/identities/group/{groupName}/member/{memberName}"})
    @ApiOperation(value="Remove member from group", response=ResponseEntity.class)
    @Transactional
    @ApiResponses(value={@ApiResponse(code=204, message="Member removed from group", response=ResponseEntity.class)})
    public ResponseEntity removeMember(@PathVariable(value="groupName") String groupName, @PathVariable(value="memberName") String memberName) {
        this.checkGroupPermission(groupName, GroupPermission.REMOVE_MEMBERSHIP);
        Group group = this.groupService.getGroup(groupName);
        User member = this.userService.getUser(memberName);
        this.groupService.removeMember(group, member);
        return ResponseEntity.noContent().build();
    }

    @PutMapping(value={"/api/identities/group/{groupName}/member/{memberName}"})
    @ApiOperation(value="Change membership role", response=ResponseEntity.class)
    @Transactional
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Updated membership role", response=ResponseEntity.class)})
    public void updateMember(@PathVariable(value="groupName") String groupName, @PathVariable(value="memberName") String memberName, @RequestBody UpdateGroupMemberCommand groupMember) {
        this.checkGroupPermission(groupName, GroupPermission.UPDATE_MEMBERSHIP);
        Group group = this.groupService.getGroup(groupName);
        User member = this.userService.getUser(memberName);
        Role newRole = this.roleService.getRole(groupMember.getRoleName());
        this.groupService.updateMemberRole(group, member, newRole);
    }

    @PutMapping(value={"/api/identities/group/{groupName}/role/{roleName}"})
    @ApiOperation(value="Change group role extension", response=ResponseEntity.class)
    @Transactional
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Updated membership role", response=ResponseEntity.class)})
    public void updateExtends(@PathVariable(value="groupName") String groupName, @PathVariable(value="roleName") String roleName, @RequestBody UpdateIncludeCommand updateExtendsCommand) {
        this.checkGroupPermission(groupName, GroupPermission.UPDATE_MEMBERSHIP);
        Group group = this.groupService.getGroup(groupName);
        String groupRoleName = updateExtendsCommand.getRole();
        Role includingRole = this.roleService.getRole(roleName);
        Role groupRole = this.roleService.getRole(groupRoleName);
        this.groupService.updateExtendsRole(group, groupRole, includingRole);
    }

    @DeleteMapping(value={"/api/identities/group/{groupName}/role/{roleName}"})
    @ApiOperation(value="Remove extension from a grouprole from a role", response=ResponseEntity.class)
    @Transactional
    @ApiResponses(value={@ApiResponse(code=204, message="Group role extension removed from role", response=ResponseEntity.class)})
    public ResponseEntity removeExtends(@PathVariable(value="groupName") String groupName, @PathVariable(value="roleName") String includingRoleName) {
        this.checkGroupPermission(groupName, GroupPermission.REMOVE_MEMBERSHIP);
        Group group = this.groupService.getGroup(groupName);
        Role includingRole = this.roleService.getRole(includingRoleName);
        this.groupService.removeExtendsRole(group, includingRole);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/api/identities/group/{groupName}/role"})
    @ApiOperation(value="Get group roles", response=Collection.class)
    @ResponseBody
    public Collection<RoleResponse> getGroupRoles(@PathVariable(value="groupName") String groupName) {
        this.checkGroupPermission(groupName, GroupPermission.VIEW);
        Iterable roles = this.groupService.getGroup(groupName).getRoles();
        ArrayList roleCollection = new ArrayList();
        roles.forEach(roleCollection::add);
        return roleCollection.stream().map(RoleResponse::fromEntity).collect(Collectors.toList());
    }

    @GetMapping(value={"/api/identities/user"})
    @ApiOperation(value="Get all users", response=Collection.class)
    @ResponseBody
    @PreAuthorize(value="hasAnyRole('SU', 'MANAGER')")
    public Collection<UserResponse> getUsers() {
        return this.userService.getUsers().stream().filter(u -> !u.getUsername().equals("anonymous")).map(UserResponse::fromEntity).collect(Collectors.toList());
    }

    @GetMapping(value={"/api/identities/group/{groupName}/permission"})
    @ApiOperation(value="Get group permissions", response=Collection.class)
    @ApiResponses(value={@ApiResponse(code=200, message="List of permissions for current user on group", response=Collection.class)})
    @ResponseBody
    public Collection<Permission> getPermissions(@PathVariable(value="groupName") String groupName) {
        return this.userPermissionEvaluator.getPermissions((ObjectIdentity)new GroupIdentity(groupName), (Permission[])GroupPermission.values());
    }

    private String getManagerRoleName(GroupValue groupValue) {
        return groupValue.getRoles().stream().filter(role -> role.getLabel().equals("Manager")).map(RoleValue::getName).findFirst().orElseThrow(() -> new IllegalStateException("Manager role is missing"));
    }

    private void checkGroupPermission(@PathVariable(value="groupName") String groupName, GroupPermission permission) {
        if (!this.userPermissionEvaluator.hasPermission((ObjectIdentity)new GroupIdentity(groupName), (Permission)permission)) {
            throw new GroupPermissionDeniedException(permission, groupName);
        }
    }
}

