package org.molgenis.api.metadata.v3.model;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.molgenis.api.model.Sort;
import org.molgenis.api.model.response.LinksResponse;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AttributeResponseData extends AttributeResponseData {

  private final String id;

  private final String label;

  private final I18nValue labelI18n;

  private final String description;

  private final I18nValue descriptionI18n;

  private final String name;

  private final Integer sequenceNr;

  private final String type;

  private final boolean idAttribute;

  private final boolean labelAttribute;

  private final Integer lookupAttributeIndex;

  private final LinksResponse refEntityType;

  private final Boolean cascadeDelete;

  private final AttributeResponse mappedBy;

  private final List<Sort> orderBy;

  private final boolean nullable;

  private final boolean auto;

  private final boolean visible;

  private final boolean unique;

  private final boolean readOnly;

  private final boolean aggregatable;

  private final String expression;

  private final List<String> enumOptions;

  private final List<Category> categoricalOptions;

  private final Range range;

  private final String parentAttributeId;

  private final String nullableExpression;

  private final String visibleExpression;

  private final String validationExpression;

  private final String defaultValue;

  private AutoValue_AttributeResponseData(
      String id,
      @Nullable String label,
      @Nullable I18nValue labelI18n,
      @Nullable String description,
      @Nullable I18nValue descriptionI18n,
      String name,
      Integer sequenceNr,
      String type,
      boolean idAttribute,
      boolean labelAttribute,
      @Nullable Integer lookupAttributeIndex,
      @Nullable LinksResponse refEntityType,
      @Nullable Boolean cascadeDelete,
      @Nullable AttributeResponse mappedBy,
      @Nullable List<Sort> orderBy,
      boolean nullable,
      boolean auto,
      boolean visible,
      boolean unique,
      boolean readOnly,
      boolean aggregatable,
      @Nullable String expression,
      @Nullable List<String> enumOptions,
      @Nullable List<Category> categoricalOptions,
      @Nullable Range range,
      @Nullable String parentAttributeId,
      @Nullable String nullableExpression,
      @Nullable String visibleExpression,
      @Nullable String validationExpression,
      @Nullable String defaultValue) {
    this.id = id;
    this.label = label;
    this.labelI18n = labelI18n;
    this.description = description;
    this.descriptionI18n = descriptionI18n;
    this.name = name;
    this.sequenceNr = sequenceNr;
    this.type = type;
    this.idAttribute = idAttribute;
    this.labelAttribute = labelAttribute;
    this.lookupAttributeIndex = lookupAttributeIndex;
    this.refEntityType = refEntityType;
    this.cascadeDelete = cascadeDelete;
    this.mappedBy = mappedBy;
    this.orderBy = orderBy;
    this.nullable = nullable;
    this.auto = auto;
    this.visible = visible;
    this.unique = unique;
    this.readOnly = readOnly;
    this.aggregatable = aggregatable;
    this.expression = expression;
    this.enumOptions = enumOptions;
    this.categoricalOptions = categoricalOptions;
    this.range = range;
    this.parentAttributeId = parentAttributeId;
    this.nullableExpression = nullableExpression;
    this.visibleExpression = visibleExpression;
    this.validationExpression = validationExpression;
    this.defaultValue = defaultValue;
  }

  @Override
  public String getId() {
    return id;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getLabel() {
    return label;
  }

  @Nullable
  @CheckForNull
  @Override
  public I18nValue getLabelI18n() {
    return labelI18n;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getDescription() {
    return description;
  }

  @Nullable
  @CheckForNull
  @Override
  public I18nValue getDescriptionI18n() {
    return descriptionI18n;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public Integer getSequenceNr() {
    return sequenceNr;
  }

  @Override
  public String getType() {
    return type;
  }

  @Override
  public boolean isIdAttribute() {
    return idAttribute;
  }

  @Override
  public boolean isLabelAttribute() {
    return labelAttribute;
  }

  @Nullable
  @CheckForNull
  @Override
  public Integer getLookupAttributeIndex() {
    return lookupAttributeIndex;
  }

  @Nullable
  @CheckForNull
  @Override
  public LinksResponse getRefEntityType() {
    return refEntityType;
  }

  @Nullable
  @CheckForNull
  @Override
  public Boolean getCascadeDelete() {
    return cascadeDelete;
  }

  @Nullable
  @CheckForNull
  @Override
  public AttributeResponse getMappedBy() {
    return mappedBy;
  }

  @Nullable
  @CheckForNull
  @Override
  public List<Sort> getOrderBy() {
    return orderBy;
  }

  @Override
  public boolean isNullable() {
    return nullable;
  }

  @Override
  public boolean isAuto() {
    return auto;
  }

  @Override
  public boolean isVisible() {
    return visible;
  }

  @Override
  public boolean isUnique() {
    return unique;
  }

  @Override
  public boolean isReadOnly() {
    return readOnly;
  }

  @Override
  public boolean isAggregatable() {
    return aggregatable;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getExpression() {
    return expression;
  }

  @Nullable
  @CheckForNull
  @Override
  public List<String> getEnumOptions() {
    return enumOptions;
  }

  @Nullable
  @CheckForNull
  @Override
  public List<Category> getCategoricalOptions() {
    return categoricalOptions;
  }

  @Nullable
  @CheckForNull
  @Override
  public Range getRange() {
    return range;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getParentAttributeId() {
    return parentAttributeId;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getNullableExpression() {
    return nullableExpression;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getVisibleExpression() {
    return visibleExpression;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getValidationExpression() {
    return validationExpression;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getDefaultValue() {
    return defaultValue;
  }

  @Override
  public String toString() {
    return "AttributeResponseData{"
         + "id=" + id + ", "
         + "label=" + label + ", "
         + "labelI18n=" + labelI18n + ", "
         + "description=" + description + ", "
         + "descriptionI18n=" + descriptionI18n + ", "
         + "name=" + name + ", "
         + "sequenceNr=" + sequenceNr + ", "
         + "type=" + type + ", "
         + "idAttribute=" + idAttribute + ", "
         + "labelAttribute=" + labelAttribute + ", "
         + "lookupAttributeIndex=" + lookupAttributeIndex + ", "
         + "refEntityType=" + refEntityType + ", "
         + "cascadeDelete=" + cascadeDelete + ", "
         + "mappedBy=" + mappedBy + ", "
         + "orderBy=" + orderBy + ", "
         + "nullable=" + nullable + ", "
         + "auto=" + auto + ", "
         + "visible=" + visible + ", "
         + "unique=" + unique + ", "
         + "readOnly=" + readOnly + ", "
         + "aggregatable=" + aggregatable + ", "
         + "expression=" + expression + ", "
         + "enumOptions=" + enumOptions + ", "
         + "categoricalOptions=" + categoricalOptions + ", "
         + "range=" + range + ", "
         + "parentAttributeId=" + parentAttributeId + ", "
         + "nullableExpression=" + nullableExpression + ", "
         + "visibleExpression=" + visibleExpression + ", "
         + "validationExpression=" + validationExpression + ", "
         + "defaultValue=" + defaultValue
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AttributeResponseData) {
      AttributeResponseData that = (AttributeResponseData) o;
      return this.id.equals(that.getId())
          && (this.label == null ? that.getLabel() == null : this.label.equals(that.getLabel()))
          && (this.labelI18n == null ? that.getLabelI18n() == null : this.labelI18n.equals(that.getLabelI18n()))
          && (this.description == null ? that.getDescription() == null : this.description.equals(that.getDescription()))
          && (this.descriptionI18n == null ? that.getDescriptionI18n() == null : this.descriptionI18n.equals(that.getDescriptionI18n()))
          && this.name.equals(that.getName())
          && this.sequenceNr.equals(that.getSequenceNr())
          && this.type.equals(that.getType())
          && this.idAttribute == that.isIdAttribute()
          && this.labelAttribute == that.isLabelAttribute()
          && (this.lookupAttributeIndex == null ? that.getLookupAttributeIndex() == null : this.lookupAttributeIndex.equals(that.getLookupAttributeIndex()))
          && (this.refEntityType == null ? that.getRefEntityType() == null : this.refEntityType.equals(that.getRefEntityType()))
          && (this.cascadeDelete == null ? that.getCascadeDelete() == null : this.cascadeDelete.equals(that.getCascadeDelete()))
          && (this.mappedBy == null ? that.getMappedBy() == null : this.mappedBy.equals(that.getMappedBy()))
          && (this.orderBy == null ? that.getOrderBy() == null : this.orderBy.equals(that.getOrderBy()))
          && this.nullable == that.isNullable()
          && this.auto == that.isAuto()
          && this.visible == that.isVisible()
          && this.unique == that.isUnique()
          && this.readOnly == that.isReadOnly()
          && this.aggregatable == that.isAggregatable()
          && (this.expression == null ? that.getExpression() == null : this.expression.equals(that.getExpression()))
          && (this.enumOptions == null ? that.getEnumOptions() == null : this.enumOptions.equals(that.getEnumOptions()))
          && (this.categoricalOptions == null ? that.getCategoricalOptions() == null : this.categoricalOptions.equals(that.getCategoricalOptions()))
          && (this.range == null ? that.getRange() == null : this.range.equals(that.getRange()))
          && (this.parentAttributeId == null ? that.getParentAttributeId() == null : this.parentAttributeId.equals(that.getParentAttributeId()))
          && (this.nullableExpression == null ? that.getNullableExpression() == null : this.nullableExpression.equals(that.getNullableExpression()))
          && (this.visibleExpression == null ? that.getVisibleExpression() == null : this.visibleExpression.equals(that.getVisibleExpression()))
          && (this.validationExpression == null ? that.getValidationExpression() == null : this.validationExpression.equals(that.getValidationExpression()))
          && (this.defaultValue == null ? that.getDefaultValue() == null : this.defaultValue.equals(that.getDefaultValue()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= (label == null) ? 0 : label.hashCode();
    h$ *= 1000003;
    h$ ^= (labelI18n == null) ? 0 : labelI18n.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= (descriptionI18n == null) ? 0 : descriptionI18n.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= sequenceNr.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= idAttribute ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= labelAttribute ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (lookupAttributeIndex == null) ? 0 : lookupAttributeIndex.hashCode();
    h$ *= 1000003;
    h$ ^= (refEntityType == null) ? 0 : refEntityType.hashCode();
    h$ *= 1000003;
    h$ ^= (cascadeDelete == null) ? 0 : cascadeDelete.hashCode();
    h$ *= 1000003;
    h$ ^= (mappedBy == null) ? 0 : mappedBy.hashCode();
    h$ *= 1000003;
    h$ ^= (orderBy == null) ? 0 : orderBy.hashCode();
    h$ *= 1000003;
    h$ ^= nullable ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= auto ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= visible ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= unique ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= readOnly ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= aggregatable ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (expression == null) ? 0 : expression.hashCode();
    h$ *= 1000003;
    h$ ^= (enumOptions == null) ? 0 : enumOptions.hashCode();
    h$ *= 1000003;
    h$ ^= (categoricalOptions == null) ? 0 : categoricalOptions.hashCode();
    h$ *= 1000003;
    h$ ^= (range == null) ? 0 : range.hashCode();
    h$ *= 1000003;
    h$ ^= (parentAttributeId == null) ? 0 : parentAttributeId.hashCode();
    h$ *= 1000003;
    h$ ^= (nullableExpression == null) ? 0 : nullableExpression.hashCode();
    h$ *= 1000003;
    h$ ^= (visibleExpression == null) ? 0 : visibleExpression.hashCode();
    h$ *= 1000003;
    h$ ^= (validationExpression == null) ? 0 : validationExpression.hashCode();
    h$ *= 1000003;
    h$ ^= (defaultValue == null) ? 0 : defaultValue.hashCode();
    return h$;
  }

  static final class Builder extends AttributeResponseData.Builder {
    private String id;
    private String label;
    private I18nValue labelI18n;
    private String description;
    private I18nValue descriptionI18n;
    private String name;
    private Integer sequenceNr;
    private String type;
    private Boolean idAttribute;
    private Boolean labelAttribute;
    private Integer lookupAttributeIndex;
    private LinksResponse refEntityType;
    private Boolean cascadeDelete;
    private AttributeResponse mappedBy;
    private List<Sort> orderBy;
    private Boolean nullable;
    private Boolean auto;
    private Boolean visible;
    private Boolean unique;
    private Boolean readOnly;
    private Boolean aggregatable;
    private String expression;
    private List<String> enumOptions;
    private List<Category> categoricalOptions;
    private Range range;
    private String parentAttributeId;
    private String nullableExpression;
    private String visibleExpression;
    private String validationExpression;
    private String defaultValue;
    Builder() {
    }
    @Override
    public AttributeResponseData.Builder setId(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setLabel(String label) {
      this.label = label;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setLabelI18n(I18nValue labelI18n) {
      this.labelI18n = labelI18n;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setDescription(String description) {
      this.description = description;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setDescriptionI18n(I18nValue descriptionI18n) {
      this.descriptionI18n = descriptionI18n;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setSequenceNr(Integer sequenceNr) {
      if (sequenceNr == null) {
        throw new NullPointerException("Null sequenceNr");
      }
      this.sequenceNr = sequenceNr;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setType(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setIdAttribute(boolean idAttribute) {
      this.idAttribute = idAttribute;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setLabelAttribute(boolean labelAttribute) {
      this.labelAttribute = labelAttribute;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setLookupAttributeIndex(Integer lookupAttributeIndex) {
      this.lookupAttributeIndex = lookupAttributeIndex;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setRefEntityType(LinksResponse refEntityType) {
      this.refEntityType = refEntityType;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setCascadeDelete(Boolean cascadeDelete) {
      this.cascadeDelete = cascadeDelete;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setMappedBy(AttributeResponse mappedBy) {
      this.mappedBy = mappedBy;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setOrderBy(List<Sort> orderBy) {
      this.orderBy = orderBy;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setNullable(boolean nullable) {
      this.nullable = nullable;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setAuto(boolean auto) {
      this.auto = auto;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setVisible(boolean visible) {
      this.visible = visible;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setUnique(boolean unique) {
      this.unique = unique;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setReadOnly(boolean readOnly) {
      this.readOnly = readOnly;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setAggregatable(boolean aggregatable) {
      this.aggregatable = aggregatable;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setExpression(String expression) {
      this.expression = expression;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setEnumOptions(List<String> enumOptions) {
      this.enumOptions = enumOptions;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setCategoricalOptions(List<Category> categoricalOptions) {
      this.categoricalOptions = categoricalOptions;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setRange(Range range) {
      this.range = range;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setParentAttributeId(String parentAttributeId) {
      this.parentAttributeId = parentAttributeId;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setNullableExpression(String nullableExpression) {
      this.nullableExpression = nullableExpression;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setVisibleExpression(String visibleExpression) {
      this.visibleExpression = visibleExpression;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setValidationExpression(String validationExpression) {
      this.validationExpression = validationExpression;
      return this;
    }
    @Override
    public AttributeResponseData.Builder setDefaultValue(String defaultValue) {
      this.defaultValue = defaultValue;
      return this;
    }
    @Override
    public AttributeResponseData build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.sequenceNr == null) {
        missing += " sequenceNr";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (this.idAttribute == null) {
        missing += " idAttribute";
      }
      if (this.labelAttribute == null) {
        missing += " labelAttribute";
      }
      if (this.nullable == null) {
        missing += " nullable";
      }
      if (this.auto == null) {
        missing += " auto";
      }
      if (this.visible == null) {
        missing += " visible";
      }
      if (this.unique == null) {
        missing += " unique";
      }
      if (this.readOnly == null) {
        missing += " readOnly";
      }
      if (this.aggregatable == null) {
        missing += " aggregatable";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AttributeResponseData(
          this.id,
          this.label,
          this.labelI18n,
          this.description,
          this.descriptionI18n,
          this.name,
          this.sequenceNr,
          this.type,
          this.idAttribute,
          this.labelAttribute,
          this.lookupAttributeIndex,
          this.refEntityType,
          this.cascadeDelete,
          this.mappedBy,
          this.orderBy,
          this.nullable,
          this.auto,
          this.visible,
          this.unique,
          this.readOnly,
          this.aggregatable,
          this.expression,
          this.enumOptions,
          this.categoricalOptions,
          this.range,
          this.parentAttributeId,
          this.nullableExpression,
          this.visibleExpression,
          this.validationExpression,
          this.defaultValue);
    }
  }

}
