package org.molgenis.api.metadata.v3.model;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.molgenis.api.model.response.LinksResponse;
import org.molgenis.api.model.response.PageResponse;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EntityTypesResponse extends EntityTypesResponse {

  private final LinksResponse links;

  private final List<EntityTypeResponse> items;

  private final PageResponse page;

  private AutoValue_EntityTypesResponse(
      LinksResponse links,
      @Nullable List<EntityTypeResponse> items,
      @Nullable PageResponse page) {
    this.links = links;
    this.items = items;
    this.page = page;
  }

  @Override
  public LinksResponse getLinks() {
    return links;
  }

  @Nullable
  @CheckForNull
  @Override
  public List<EntityTypeResponse> getItems() {
    return items;
  }

  @Nullable
  @CheckForNull
  @Override
  public PageResponse getPage() {
    return page;
  }

  @Override
  public String toString() {
    return "EntityTypesResponse{"
         + "links=" + links + ", "
         + "items=" + items + ", "
         + "page=" + page
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EntityTypesResponse) {
      EntityTypesResponse that = (EntityTypesResponse) o;
      return this.links.equals(that.getLinks())
          && (this.items == null ? that.getItems() == null : this.items.equals(that.getItems()))
          && (this.page == null ? that.getPage() == null : this.page.equals(that.getPage()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= links.hashCode();
    h$ *= 1000003;
    h$ ^= (items == null) ? 0 : items.hashCode();
    h$ *= 1000003;
    h$ ^= (page == null) ? 0 : page.hashCode();
    return h$;
  }

  static final class Builder extends EntityTypesResponse.Builder {
    private LinksResponse links;
    private List<EntityTypeResponse> items;
    private PageResponse page;
    Builder() {
    }
    @Override
    public EntityTypesResponse.Builder setLinks(LinksResponse links) {
      if (links == null) {
        throw new NullPointerException("Null links");
      }
      this.links = links;
      return this;
    }
    @Override
    public EntityTypesResponse.Builder setItems(List<EntityTypeResponse> items) {
      this.items = items;
      return this;
    }
    @Override
    public EntityTypesResponse.Builder setPage(PageResponse page) {
      this.page = page;
      return this;
    }
    @Override
    public EntityTypesResponse build() {
      String missing = "";
      if (this.links == null) {
        missing += " links";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EntityTypesResponse(
          this.links,
          this.items,
          this.page);
    }
  }

}
