/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.molgenis.api.metadata.v3.model.I18nValue;
import org.molgenis.data.InvalidValueTypeException;

class I18nValueMapper {
    private I18nValueMapper() {
    }

    static I18nValue toI18nValue(Object value) {
        I18nValue.Builder builder = I18nValue.builder();
        if (value instanceof Map) {
            Object translations;
            Map valueMap = (Map)value;
            Object defaultValue = valueMap.get("defaultValue");
            if (defaultValue != null) {
                builder.setDefaultValue(defaultValue.toString());
            }
            if ((translations = valueMap.get("translations")) instanceof Map) {
                builder.setTranslations((Map<String, String>)ImmutableMap.copyOf((Map)((Map)translations)));
            }
        } else {
            throw new InvalidValueTypeException(value.toString(), "I18nValue", null);
        }
        return builder.build();
    }
}

