/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3.job;

import java.util.Objects;
import org.molgenis.api.metadata.v3.job.EntityTypeSerializer;
import org.molgenis.api.metadata.v3.job.MetadataUpsertJobExecution;
import org.molgenis.api.metadata.v3.job.MetadataUpsertJobExecutionMetadata;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.jobs.Job;
import org.molgenis.jobs.JobFactory;
import org.molgenis.util.UnexpectedEnumException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetadataUpsertConfig {
    private final MetaDataService metadataService;
    private final EntityTypeSerializer entityTypeSerializer;

    public MetadataUpsertConfig(MetaDataService metadataService, EntityTypeSerializer entityTypeSerializer) {
        this.metadataService = Objects.requireNonNull(metadataService);
        this.entityTypeSerializer = Objects.requireNonNull(entityTypeSerializer);
    }

    @Bean
    public JobFactory<MetadataUpsertJobExecution> metadataUpsertJobExecutionJobFactory() {
        return new JobFactory<MetadataUpsertJobExecution>(){

            public Job createJob(MetadataUpsertJobExecution metadataUpsertJobExecution) {
                String entityTypeData = metadataUpsertJobExecution.getEntityTypeData();
                EntityType entityType = MetadataUpsertConfig.this.entityTypeSerializer.deserializeEntityType(entityTypeData);
                MetadataUpsertJobExecutionMetadata.Action action = metadataUpsertJobExecution.getAction();
                switch (action) {
                    case CREATE: {
                        throw new UnsupportedOperationException();
                    }
                    case UPDATE: {
                        return progress -> MetadataUpsertConfig.this.updateEntityType(entityType);
                    }
                }
                throw new UnexpectedEnumException((Enum)action);
            }
        };
    }

    private Void updateEntityType(EntityType entityType) {
        this.metadataService.updateEntityType(entityType);
        return null;
    }
}

