package org.molgenis.api.metadata.v3;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.molgenis.data.meta.model.EntityType;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EntityTypeCollection extends EntityTypeCollection {

  private final List<EntityType> entityTypes;

  private final EntityTypeCollection.Page page;

  private final String entityId;

  private AutoValue_EntityTypeCollection(
      List<EntityType> entityTypes,
      @Nullable EntityTypeCollection.Page page,
      @Nullable String entityId) {
    this.entityTypes = entityTypes;
    this.page = page;
    this.entityId = entityId;
  }

  @Override
  List<EntityType> getEntityTypes() {
    return entityTypes;
  }

  @Nullable
  @CheckForNull
  @Override
  EntityTypeCollection.Page getPage() {
    return page;
  }

  @Nullable
  @CheckForNull
  @Override
  String getEntityId() {
    return entityId;
  }

  @Override
  public String toString() {
    return "EntityTypeCollection{"
         + "entityTypes=" + entityTypes + ", "
         + "page=" + page + ", "
         + "entityId=" + entityId
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EntityTypeCollection) {
      EntityTypeCollection that = (EntityTypeCollection) o;
      return this.entityTypes.equals(that.getEntityTypes())
          && (this.page == null ? that.getPage() == null : this.page.equals(that.getPage()))
          && (this.entityId == null ? that.getEntityId() == null : this.entityId.equals(that.getEntityId()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= entityTypes.hashCode();
    h$ *= 1000003;
    h$ ^= (page == null) ? 0 : page.hashCode();
    h$ *= 1000003;
    h$ ^= (entityId == null) ? 0 : entityId.hashCode();
    return h$;
  }

  static final class Builder extends EntityTypeCollection.Builder {
    private List<EntityType> entityTypes;
    private EntityTypeCollection.Page page;
    private String entityId;
    Builder() {
    }
    @Override
    EntityTypeCollection.Builder setEntityTypes(List<EntityType> entityTypes) {
      if (entityTypes == null) {
        throw new NullPointerException("Null entityTypes");
      }
      this.entityTypes = entityTypes;
      return this;
    }
    @Override
    EntityTypeCollection.Builder setPage(EntityTypeCollection.Page page) {
      this.page = page;
      return this;
    }
    @Override
    EntityTypeCollection.Builder setEntityId(String entityId) {
      this.entityId = entityId;
      return this;
    }
    @Override
    EntityTypeCollection build() {
      String missing = "";
      if (this.entityTypes == null) {
        missing += " entityTypes";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EntityTypeCollection(
          this.entityTypes,
          this.page,
          this.entityId);
    }
  }

}
