/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.api.data.SortMapper;
import org.molgenis.api.metadata.v3.AttributeRequestMapper;
import org.molgenis.api.metadata.v3.I18nValueMapper;
import org.molgenis.api.metadata.v3.MetadataUtils;
import org.molgenis.api.metadata.v3.exception.InvalidKeyException;
import org.molgenis.api.metadata.v3.exception.UnsupportedFieldException;
import org.molgenis.api.metadata.v3.model.CreateAttributeRequest;
import org.molgenis.api.metadata.v3.model.CreateEntityTypeRequest;
import org.molgenis.api.metadata.v3.model.I18nValue;
import org.molgenis.api.metadata.v3.model.Range;
import org.molgenis.api.model.Order;
import org.molgenis.data.DataConverter;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityManager;
import org.molgenis.data.Repository;
import org.molgenis.data.Sort;
import org.molgenis.data.UnknownAttributeException;
import org.molgenis.data.UnknownEntityTypeException;
import org.molgenis.data.UnknownRepositoryException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeMetadata;
import org.molgenis.util.i18n.LanguageService;
import org.springframework.stereotype.Component;

@Component
class AttributeRequestMapperImpl
implements AttributeRequestMapper {
    private final AttributeFactory attributeFactory;
    private final MetaDataService metaDataService;
    private final SortMapper sortMapper;
    private final EntityManager entityManager;
    private final EntityTypeMetadata entityTypeMetadata;

    AttributeRequestMapperImpl(AttributeFactory attributeFactory, MetaDataService metaDataService, SortMapper sortMapper, EntityManager entityManager, EntityTypeMetadata entityTypeMetadata) {
        this.attributeFactory = Objects.requireNonNull(attributeFactory);
        this.metaDataService = Objects.requireNonNull(metaDataService);
        this.sortMapper = Objects.requireNonNull(sortMapper);
        this.entityManager = Objects.requireNonNull(entityManager);
        this.entityTypeMetadata = Objects.requireNonNull(entityTypeMetadata);
    }

    @Override
    public Attribute toAttribute(CreateAttributeRequest attributeRequest, EntityType entityType) {
        return this.toAttribute(attributeRequest, entityType, null);
    }

    private Attribute toAttribute(CreateAttributeRequest attributeRequest, EntityType entityType, @Nullable @CheckForNull Integer index) {
        Boolean unique;
        Boolean readonly;
        Range range;
        List<String> enumOptions;
        Boolean visible;
        Boolean auto;
        ImmutableList<Order> orderBy;
        String refEntityTypeId;
        String type;
        Attribute attribute = this.attributeFactory.create();
        attribute.setIdAttribute(attributeRequest.getIdAttribute());
        attribute.setLabelAttribute(attributeRequest.getLabelAttribute());
        attribute.setLookupAttributeIndex(attributeRequest.getLookupAttributeIndex());
        String id = attributeRequest.getId();
        if (id != null) {
            attribute.setIdentifier(id);
        }
        attribute.setName(attributeRequest.getName());
        attribute.setEntity(entityType);
        Integer sequenceNumber = attributeRequest.getSequenceNr();
        if (sequenceNumber == null) {
            sequenceNumber = index;
        }
        if (sequenceNumber != null) {
            attribute.setSequenceNumber(sequenceNumber.intValue());
        }
        if ((type = attributeRequest.getType()) != null) {
            attribute.setDataType(AttributeType.toEnum((String)type));
        }
        if ((refEntityTypeId = attributeRequest.getRefEntityType()) != null) {
            EntityType refEntityType = (EntityType)this.entityManager.getReference((EntityType)this.entityTypeMetadata, (Object)refEntityTypeId);
            attribute.setRefEntity(refEntityType);
        }
        if (attributeRequest.getCascadeDelete() != null) {
            attribute.setCascadeDelete(attributeRequest.getCascadeDelete());
        }
        attribute.setOrderBy((orderBy = attributeRequest.getOrderBy()) != null ? this.sortMapper.map(org.molgenis.api.model.Sort.create(orderBy), entityType) : null);
        attribute.setExpression(attributeRequest.getExpression());
        Boolean nullable = attributeRequest.getNullable();
        if (nullable != null) {
            attribute.setNillable(nullable.booleanValue());
        }
        if ((auto = attributeRequest.getAuto()) != null) {
            attribute.setAuto(auto.booleanValue());
        }
        if ((visible = attributeRequest.getVisible()) != null) {
            attribute.setVisible(visible.booleanValue());
        }
        this.processI18nLabel(attributeRequest.getLabel(), attribute);
        this.processI18nDescription(attributeRequest.getDescription(), attribute);
        Boolean aggregatable = attributeRequest.getAggregatable();
        if (aggregatable != null) {
            attribute.setAggregatable(aggregatable.booleanValue());
        }
        if ((enumOptions = attributeRequest.getEnumOptions()) != null) {
            attribute.setEnumOptions(enumOptions);
        }
        if ((range = attributeRequest.getRange()) != null) {
            attribute.setRange(this.map(range));
        }
        if ((readonly = attributeRequest.getReadonly()) != null) {
            attribute.setReadOnly(readonly.booleanValue());
        }
        if ((unique = attributeRequest.getUnique()) != null) {
            attribute.setUnique(unique.booleanValue());
        }
        attribute.setNullableExpression(attributeRequest.getNullableExpression());
        attribute.setVisibleExpression(attributeRequest.getVisibleExpression());
        attribute.setValidationExpression(attributeRequest.getValidationExpression());
        attribute.setDefaultValue(attributeRequest.getDefaultValue());
        return attribute;
    }

    @Override
    public Map<String, Attribute> toAttributes(List<Map<String, Object>> attributeValueMaps, EntityType entityType) {
        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
        int index = 0;
        for (Map<String, Object> attributeValueMap : attributeValueMaps) {
            Attribute attr = this.toAttribute(attributeValueMap, entityType);
            if (attr.getSequenceNumber() == null) {
                attr.setSequenceNumber(index);
            }
            attributes.put(attr.getIdentifier(), attr);
            ++index;
        }
        for (Map<String, Object> attributeValueMap : attributeValueMaps) {
            this.processParentAndMappedby(attributeValueMap, attributes, entityType);
        }
        return attributes;
    }

    private void processParentAndMappedby(Map<String, Object> attributeRequest, Map<String, Attribute> attributes, EntityType entityType) {
        String attributeId = attributeRequest.get("id").toString();
        for (Map.Entry<String, Object> entry : attributeRequest.entrySet()) {
            Attribute attribute;
            if (entry.getKey().equals("mappedByAttribute")) {
                String mappedByAttrId = MetadataUtils.getStringValue(entry.getValue());
                Attribute mappedByAttr = attributes.get(mappedByAttrId);
                if (mappedByAttr == null) {
                    Repository repository = (Repository)this.metaDataService.getRepository("sys_md_Attribute", Attribute.class).orElseThrow(() -> new UnknownRepositoryException("sys_md_Attribute"));
                    mappedByAttr = (Attribute)repository.findOneById((Object)mappedByAttrId);
                }
                if (mappedByAttr == null) {
                    throw new UnknownAttributeException(entityType, mappedByAttrId);
                }
                attribute = attributes.get(attributeId);
                attribute.setMappedBy(mappedByAttr);
                continue;
            }
            if (!entry.getKey().equals("parent")) continue;
            String parentId = MetadataUtils.getStringValue(entry.getValue());
            Attribute parentAttr = attributes.get(parentId);
            if (parentAttr == null) {
                parentAttr = this.getAttributeFromParent(entityType.getExtends(), parentId);
            }
            attribute = attributes.get(attributeId);
            attribute.setParent(parentAttr);
        }
    }

    @Override
    public void updateAttribute(Attribute attribute, Map<String, Object> attributeValues) {
        attributeValues.forEach((key, value) -> this.updateAttributeValue(attribute, (String)key, value));
    }

    private void updateAttributeValue(Attribute attribute, String key, Object value) {
        switch (key) {
            case "id": {
                attribute.setIdentifier(MetadataUtils.getStringValue(value));
                break;
            }
            case "name": {
                attribute.setName(MetadataUtils.getStringValue(value));
                break;
            }
            case "sequenceNr": {
                MetadataUtils.setSequenceNumber(attribute, value);
                break;
            }
            case "type": {
                MetadataUtils.setAttributeType(attribute, value);
                break;
            }
            case "refEntityType": {
                this.setRefEntityType(attribute, value);
                break;
            }
            case "cascadeDelete": {
                String cascadeValue = MetadataUtils.getStringValue(value);
                Boolean isCascade = cascadeValue != null ? Boolean.valueOf(cascadeValue) : null;
                attribute.setCascadeDelete(isCascade);
                break;
            }
            case "orderBy": {
                this.mapOrderBy(value).ifPresent(arg_0 -> ((Attribute)attribute).setOrderBy(arg_0));
                break;
            }
            case "expression": {
                attribute.setExpression(MetadataUtils.getStringValue(value));
                break;
            }
            case "nullable": {
                String nullableValue = MetadataUtils.getStringValue(value);
                attribute.setNillable(Boolean.parseBoolean(nullableValue));
                break;
            }
            case "auto": {
                String autoValue = MetadataUtils.getStringValue(value);
                attribute.setAuto(Boolean.parseBoolean(autoValue));
                break;
            }
            case "visible": {
                String visibleValue = MetadataUtils.getStringValue(value);
                attribute.setVisible(Boolean.parseBoolean(visibleValue));
                break;
            }
            case "label": {
                I18nValue i18Label = I18nValueMapper.toI18nValue(value);
                this.processI18nLabel(i18Label, attribute);
                break;
            }
            case "description": {
                I18nValue i18Description = I18nValueMapper.toI18nValue(value);
                this.processI18nDescription(i18Description, attribute);
                break;
            }
            case "aggregatable": {
                attribute.setAggregatable(Boolean.parseBoolean(value.toString()));
                break;
            }
            case "enumOptions": {
                MetadataUtils.setEnumOptions(attribute, value);
                break;
            }
            case "range": {
                Range range = this.mapRange(value);
                if (range == null) break;
                attribute.setRange(this.map(range));
                break;
            }
            case "readonly": {
                MetadataUtils.setBooleanValue((Entity)attribute, value, "isReadOnly");
                break;
            }
            case "unique": {
                MetadataUtils.setBooleanValue((Entity)attribute, value, "isUnique");
                break;
            }
            case "defaultValue": {
                attribute.setDefaultValue(MetadataUtils.getStringValue(value));
                break;
            }
            case "nullableExpression": {
                attribute.setNullableExpression(MetadataUtils.getStringValue(value));
                break;
            }
            case "visibleExpression": {
                attribute.setVisibleExpression(MetadataUtils.getStringValue(value));
                break;
            }
            case "validationExpression": {
                attribute.setValidationExpression(MetadataUtils.getStringValue(value));
                break;
            }
            case "mappedByAttribute": 
            case "parent": {
                break;
            }
            case "tags": {
                throw new UnsupportedFieldException(key);
            }
            case "idAttribute": {
                attribute.setIdAttribute(DataConverter.toBoolean((Object)value));
                break;
            }
            case "labelAttribute": {
                attribute.setLabelAttribute(DataConverter.toBoolean((Object)value));
                break;
            }
            case "lookupAttributeIndex": {
                attribute.setLookupAttributeIndex(DataConverter.toInt((Object)value));
                break;
            }
            default: {
                throw new InvalidKeyException("attribute", key);
            }
        }
    }

    private Attribute toAttribute(Map<String, Object> attributeRequest, EntityType entityType) {
        Attribute attribute = this.attributeFactory.create();
        attribute.setEntity(entityType);
        this.updateAttribute(attribute, attributeRequest);
        return attribute;
    }

    private void setRefEntityType(Attribute attribute, Object value) {
        String refEntityTypeId = MetadataUtils.getStringValue(value);
        if (refEntityTypeId == null) {
            throw new UnknownEntityTypeException(refEntityTypeId);
        }
        EntityType refEntityType = (EntityType)this.entityManager.getReference((EntityType)this.entityTypeMetadata, (Object)refEntityTypeId);
        attribute.setRefEntity(refEntityType);
    }

    private Optional<Sort> mapOrderBy(Object value) {
        List values = (List)value;
        ImmutableList orders = (ImmutableList)values.stream().map((? super T item) -> this.mapOrderByItem((Map)item)).collect(ImmutableList.toImmutableList());
        org.molgenis.api.model.Sort sort = org.molgenis.api.model.Sort.create((List)orders);
        return Optional.of(this.sortMapper.map(sort, (EntityType)this.attributeFactory.getAttributeMetadata()));
    }

    private Order mapOrderByItem(Map<String, String> orderbyItem) {
        Order.Builder orderBuilder = Order.builder().setId(orderbyItem.get("id"));
        String order = orderbyItem.get("order");
        if (order != null) {
            orderBuilder.setDirection(Order.Direction.valueOf((String)order));
        }
        return orderBuilder.build();
    }

    private Range mapRange(Object value) {
        Long minLong = null;
        Long maxLong = null;
        if (value instanceof Map) {
            Object max;
            Map valueMap = (Map)value;
            Object min = valueMap.get("min");
            if (min != null) {
                minLong = Double.valueOf(min.toString()).longValue();
            }
            if ((max = valueMap.get("max")) != null) {
                maxLong = Double.valueOf(max.toString()).longValue();
            }
        }
        return Range.create(minLong, maxLong);
    }

    private org.molgenis.data.Range map(Range range) {
        return new org.molgenis.data.Range(range.getMin(), range.getMax());
    }

    @Override
    public List<Attribute> toAttributes(List<CreateAttributeRequest> attributes, CreateEntityTypeRequest entityTypeRequest, EntityType entityType) {
        HashMap mappedAttributes = Maps.newHashMapWithExpectedSize((int)attributes.size());
        AtomicInteger index = new AtomicInteger(0);
        for (CreateAttributeRequest attribute : attributes) {
            Attribute mappedAttribute = this.toAttribute(attribute, entityType, index.getAndIncrement());
            mappedAttributes.put(mappedAttribute.getIdentifier(), mappedAttribute);
        }
        this.resolveMappedBy(attributes, mappedAttributes, entityTypeRequest.getExtends());
        return new ArrayList<Attribute>(mappedAttributes.values());
    }

    private void resolveMappedBy(List<CreateAttributeRequest> attributes, Map<String, Attribute> attributeMap, String parentEntityId) {
        for (CreateAttributeRequest attributeRequest : attributes) {
            Attribute mappedBy;
            if (attributeRequest.getMappedByAttribute() == null || (mappedBy = attributeMap.containsKey(attributeRequest.getMappedByAttribute()) ? attributeMap.get(attributeRequest.getMappedByAttribute()) : this.getAttributeFromParent(parentEntityId, attributeRequest)) == null) continue;
            Attribute attr = attributeMap.get(attributeRequest.getId());
            attr.setMappedBy(mappedBy);
        }
    }

    private Attribute getAttributeFromParent(String parentEntityId, CreateAttributeRequest attributeRequest) {
        Optional parentOptional = this.metaDataService.getEntityType(parentEntityId);
        Attribute mappedBy = null;
        if (parentOptional.isPresent()) {
            EntityType parent = (EntityType)parentOptional.get();
            mappedBy = parent.getAttribute(attributeRequest.getMappedByAttribute());
            EntityType parentExtends = parent.getExtends();
            if (mappedBy == null && parentExtends != null) {
                mappedBy = this.getAttributeFromParent(parentExtends.getId(), attributeRequest);
            }
        }
        return mappedBy;
    }

    private Attribute getAttributeFromParent(EntityType parent, String attributeId) {
        Attribute attribute = null;
        if (parent != null) {
            attribute = parent.getAttribute(attributeId);
            EntityType parentExtends = parent.getExtends();
            if (attribute == null && parentExtends != null) {
                attribute = this.getAttributeFromParent(parentExtends, attributeId);
            }
        }
        return attribute;
    }

    private void processI18nLabel(I18nValue i18nValue, Attribute attribute) {
        if (i18nValue != null) {
            attribute.setLabel(i18nValue.getDefaultValue());
            Map<String, String> translations = i18nValue.getTranslations();
            if (translations != null) {
                LanguageService.getLanguageCodes().forEach(languageCode -> attribute.setLabel(languageCode, (String)translations.get(languageCode)));
            }
        }
    }

    private void processI18nDescription(I18nValue i18nValue, Attribute attribute) {
        if (i18nValue != null) {
            attribute.setDescription(i18nValue.getDefaultValue());
            Map<String, String> translations = i18nValue.getTranslations();
            if (translations != null) {
                LanguageService.getLanguageCodes().forEach(languageCode -> attribute.setDescription(languageCode, (String)translations.get(languageCode)));
            }
        }
    }
}

