/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.molgenis.api.metadata.v3.AttributeRequestMapper;
import org.molgenis.api.metadata.v3.EntityTypeRequestMapper;
import org.molgenis.api.metadata.v3.I18nValueMapper;
import org.molgenis.api.metadata.v3.exception.EmptyAttributesException;
import org.molgenis.api.metadata.v3.exception.InvalidKeyException;
import org.molgenis.api.metadata.v3.exception.ReadOnlyFieldException;
import org.molgenis.api.metadata.v3.exception.UnsupportedFieldException;
import org.molgenis.api.metadata.v3.model.CreateAttributeRequest;
import org.molgenis.api.metadata.v3.model.CreateEntityTypeRequest;
import org.molgenis.api.metadata.v3.model.I18nValue;
import org.molgenis.data.InvalidValueTypeException;
import org.molgenis.data.UnknownEntityTypeException;
import org.molgenis.data.UnknownPackageException;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.util.EntityTypeUtils;
import org.molgenis.util.i18n.LanguageService;
import org.springframework.stereotype.Component;

@Component
public class EntityTypeRequestMapperImpl
implements EntityTypeRequestMapper {
    private final EntityTypeFactory entityTypeFactory;
    private final AttributeRequestMapper attributeRequestMapper;
    private final MetaDataService metaDataService;

    EntityTypeRequestMapperImpl(EntityTypeFactory entityTypeFactory, AttributeRequestMapper attributeRequestMapper, MetaDataService metaDataService) {
        this.entityTypeFactory = Objects.requireNonNull(entityTypeFactory);
        this.attributeRequestMapper = Objects.requireNonNull(attributeRequestMapper);
        this.metaDataService = Objects.requireNonNull(metaDataService);
    }

    @Override
    public EntityType toEntityType(CreateEntityTypeRequest entityTypeRequest) {
        EntityType entityType = (EntityType)this.entityTypeFactory.create();
        String entityTypeId = entityTypeRequest.getId();
        if (entityTypeId != null) {
            entityType.setId(entityTypeId);
        }
        String packageId = entityTypeRequest.getPackage();
        Package pack = null;
        if (packageId != null) {
            pack = (Package)this.metaDataService.getPackage(packageId).orElseThrow(() -> new UnknownPackageException(entityTypeRequest.getPackage()));
        }
        entityType.setPackage(pack);
        String extendsEntityTypeId = entityTypeRequest.getExtends();
        if (extendsEntityTypeId != null) {
            EntityType extendsEntityType = (EntityType)this.metaDataService.getEntityType(extendsEntityTypeId).orElseThrow(() -> new UnknownEntityTypeException(extendsEntityTypeId));
            entityType.setExtends(extendsEntityType);
        }
        this.processI18nLabel(entityTypeRequest.getLabel(), entityType);
        this.processI18nDescription(entityTypeRequest.getDescription(), entityType);
        List<Attribute> ownAttributes = this.attributeRequestMapper.toAttributes((List<CreateAttributeRequest>)entityTypeRequest.getAttributes(), entityTypeRequest, entityType);
        entityType.setOwnAllAttributes(ownAttributes);
        Boolean abstractEntityType = entityTypeRequest.getAbstract();
        if (abstractEntityType != null) {
            entityType.setAbstract(abstractEntityType.booleanValue());
        }
        entityType.setBackend(this.metaDataService.getDefaultBackend().getName());
        this.processSelfReferencingAttributes(entityType, ownAttributes);
        return entityType;
    }

    @Override
    public void updateEntityType(EntityType entityType, Map<String, Object> entityTypeValues) {
        for (Map.Entry<String, Object> entry : entityTypeValues.entrySet()) {
            if (entry.getValue() == null) {
                entityType.set(entry.getKey(), null);
                continue;
            }
            this.updateEntityType(entityType, entry);
        }
    }

    private void updateEntityType(EntityType entityType, Map.Entry<String, Object> entry) {
        switch (entry.getKey()) {
            case "package": {
                String packageId = String.valueOf(entry.getValue());
                Package pack = (Package)this.metaDataService.getPackage(packageId).orElseThrow(() -> new UnknownPackageException(packageId));
                entityType.setPackage(pack);
                break;
            }
            case "id": 
            case "abstract": {
                throw new ReadOnlyFieldException(entry.getKey(), "entityType");
            }
            case "extends": {
                String extendsValue = String.valueOf(entry.getValue());
                EntityType parent = (EntityType)this.metaDataService.getEntityType(extendsValue).orElseThrow(() -> new UnknownEntityTypeException(extendsValue));
                entityType.setExtends(parent);
                break;
            }
            case "label": {
                I18nValue label = I18nValueMapper.toI18nValue(entry.getValue());
                this.processI18nLabel(label, entityType);
                break;
            }
            case "description": {
                I18nValue description = I18nValueMapper.toI18nValue(entry.getValue());
                this.processI18nDescription(description, entityType);
                break;
            }
            case "attributes": {
                if (entry.getValue() != null) {
                    Iterable<Attribute> attributes = this.mapAttributes(entityType, entry);
                    entityType.setOwnAllAttributes(attributes);
                    break;
                }
                throw new EmptyAttributesException();
            }
            case "tags": 
            case "backend": {
                throw new UnsupportedFieldException(entry.getKey());
            }
            default: {
                throw new InvalidKeyException("entityType", entry.getKey());
            }
        }
    }

    private Iterable<Attribute> mapAttributes(EntityType entityType, Map.Entry<String, Object> entry) {
        if (!(entry.getValue() instanceof Iterable)) {
            throw new InvalidValueTypeException(entry.getValue().toString(), "list", null);
        }
        List attrValues = (List)entry.getValue();
        ArrayList<Map<String, Object>> requestAttributes = new ArrayList<Map<String, Object>>();
        for (Object attrValue : attrValues) {
            Map valueMap = (Map)attrValue;
            requestAttributes.add(valueMap);
        }
        return this.mapAttributes(requestAttributes, entityType);
    }

    private Iterable<Attribute> mapAttributes(List<Map<String, Object>> values, EntityType entityType) {
        return this.attributeRequestMapper.toAttributes(values, entityType).values();
    }

    private void processSelfReferencingAttributes(EntityType entityType, Collection<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            if (!EntityTypeUtils.isReferenceType((Attribute)attribute) || !attribute.getRefEntity().getId().equals(entityType.getId())) continue;
            attribute.setRefEntity(entityType);
        }
    }

    private void processI18nDescription(I18nValue i18nValue, EntityType entityType) {
        if (i18nValue != null) {
            entityType.setDescription(i18nValue.getDefaultValue());
            LanguageService.getLanguageCodes().forEach(languageCode -> {
                Map<String, String> translations = i18nValue.getTranslations();
                if (translations != null) {
                    entityType.setDescription(languageCode, translations.get(languageCode));
                }
            });
        }
    }

    private void processI18nLabel(I18nValue i18nValue, EntityType entityType) {
        if (i18nValue != null) {
            entityType.setLabel(i18nValue.getDefaultValue());
            LanguageService.getLanguageCodes().forEach(languageCode -> {
                Map<String, String> translations = i18nValue.getTranslations();
                if (translations != null) {
                    entityType.setLabel(languageCode, translations.get(languageCode));
                }
            });
        }
    }
}

