/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import org.molgenis.api.ApiController;
import org.molgenis.api.metadata.v3.AttributeRequestMapper;
import org.molgenis.api.metadata.v3.AttributeResponseMapper;
import org.molgenis.api.metadata.v3.Attributes;
import org.molgenis.api.metadata.v3.EntityTypeRequestMapper;
import org.molgenis.api.metadata.v3.EntityTypeResponseMapper;
import org.molgenis.api.metadata.v3.EntityTypes;
import org.molgenis.api.metadata.v3.MetadataApiService;
import org.molgenis.api.metadata.v3.job.MetadataDeleteJobExecution;
import org.molgenis.api.metadata.v3.job.MetadataUpsertJobExecution;
import org.molgenis.api.metadata.v3.model.AttributeResponse;
import org.molgenis.api.metadata.v3.model.AttributesResponse;
import org.molgenis.api.metadata.v3.model.CreateAttributeRequest;
import org.molgenis.api.metadata.v3.model.CreateEntityTypeRequest;
import org.molgenis.api.metadata.v3.model.DeleteAttributesRequest;
import org.molgenis.api.metadata.v3.model.DeleteEntityTypesRequest;
import org.molgenis.api.metadata.v3.model.EntityTypeResponse;
import org.molgenis.api.metadata.v3.model.EntityTypesResponse;
import org.molgenis.api.metadata.v3.model.ReadAttributesRequest;
import org.molgenis.api.metadata.v3.model.ReadEntityTypeRequest;
import org.molgenis.api.metadata.v3.model.ReadEntityTypesRequest;
import org.molgenis.api.model.Sort;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.jobs.model.JobExecution;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/metadata"})
class MetadataApiController
extends ApiController {
    private static final String API_META_ID = "metadata";
    static final String API_META_PATH = "/api/metadata";
    private final MetadataApiService metadataApiService;
    private final EntityTypeResponseMapper entityTypeResponseMapper;
    private final EntityTypeRequestMapper entityTypeRequestMapper;
    private final AttributeResponseMapper attributeResponseMapper;
    private final AttributeRequestMapper attributeRequestMapper;

    MetadataApiController(MetadataApiService metadataApiService, EntityTypeResponseMapper entityTypeResponseMapper, EntityTypeRequestMapper entityTypeRequestMapper, AttributeResponseMapper attributeResponseMapper, AttributeRequestMapper attributeRequestMapper) {
        super(API_META_ID, Integer.valueOf(3));
        this.metadataApiService = Objects.requireNonNull(metadataApiService);
        this.entityTypeResponseMapper = Objects.requireNonNull(entityTypeResponseMapper);
        this.entityTypeRequestMapper = Objects.requireNonNull(entityTypeRequestMapper);
        this.attributeResponseMapper = Objects.requireNonNull(attributeResponseMapper);
        this.attributeRequestMapper = Objects.requireNonNull(attributeRequestMapper);
    }

    @Transactional(readOnly=true)
    @GetMapping
    public EntityTypesResponse getEntityTypes(@Valid ReadEntityTypesRequest entitiesRequest) {
        int size = entitiesRequest.getSize();
        int page = entitiesRequest.getPage();
        Sort sort = entitiesRequest.getSort();
        EntityTypes entityTypes = this.metadataApiService.findEntityTypes(entitiesRequest.getQ().orElse(null), sort, size, page);
        return this.entityTypeResponseMapper.toEntityTypesResponse(entityTypes, size, page);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{entityTypeId}"})
    public EntityTypeResponse getEntityType(@PathVariable(value="entityTypeId") String entityTypeId, @Valid ReadEntityTypeRequest readEntityTypeRequest) {
        EntityType entityType = this.metadataApiService.findEntityType(entityTypeId);
        return this.entityTypeResponseMapper.toEntityTypeResponse(entityType, readEntityTypeRequest.isFlattenAttributes(), readEntityTypeRequest.isI18n());
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{entityTypeId}/attributes/{attributeId}"})
    public AttributeResponse getAttribute(@PathVariable(value="entityTypeId") String entityTypeId, @PathVariable(value="attributeId") String attributeId) {
        Attribute attribute = this.metadataApiService.findAttribute(entityTypeId, attributeId);
        return this.attributeResponseMapper.toAttributeResponse(attribute, false);
    }

    @Transactional
    @PostMapping
    public ResponseEntity<Void> createEntityType(@Valid @RequestBody CreateEntityTypeRequest createEntityTypeRequest) {
        EntityType entityType = this.entityTypeRequestMapper.toEntityType(createEntityTypeRequest);
        this.metadataApiService.createEntityType(entityType);
        URI location = ServletUriComponentsBuilder.fromCurrentRequestUri().replacePath(API_META_PATH).pathSegment(new String[]{entityType.getId()}).build().toUri();
        return ResponseEntity.created((URI)location).build();
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{entityTypeId}/attributes"})
    public AttributesResponse getAttributes(@PathVariable(value="entityTypeId") String entityTypeId, @Valid ReadAttributesRequest readAttributesRequest) {
        int size = readAttributesRequest.getSize();
        int page = readAttributesRequest.getPage();
        Sort sort = readAttributesRequest.getSort();
        Attributes attributes = this.metadataApiService.findAttributes(entityTypeId, readAttributesRequest.getQ().orElse(null), sort, size, page);
        return this.attributeResponseMapper.toAttributesResponse(attributes, size, page);
    }

    @Transactional
    @PostMapping(value={"/{entityTypeId}/attributes"})
    public ResponseEntity<Void> createAttribute(@PathVariable(value="entityTypeId") String entityTypeId, @Valid @RequestBody CreateAttributeRequest createAttributeRequest) {
        EntityType entityType = this.metadataApiService.findEntityType(entityTypeId);
        Attribute attribute = this.attributeRequestMapper.toAttribute(createAttributeRequest, entityType);
        entityType.addAttribute(attribute, new EntityType.AttributeRole[0]);
        MetadataUpsertJobExecution jobExecution = this.metadataApiService.updateEntityTypeAsync(entityType);
        return this.toLocationResponse(jobExecution);
    }

    @Transactional
    @DeleteMapping(value={"/{entityTypeId}/attributes/{attributeId}"})
    public ResponseEntity<Void> deleteAttribute(@PathVariable(value="entityTypeId") String entityTypeId, @PathVariable(value="attributeId") String attributeId) {
        MetadataUpsertJobExecution jobExecution = this.metadataApiService.deleteAttributeAsync(entityTypeId, attributeId);
        return this.toLocationResponse(jobExecution);
    }

    @Transactional
    @DeleteMapping(value={"/{entityTypeId}/attributes"})
    public ResponseEntity<Void> deleteAttributes(@PathVariable(value="entityTypeId") String entityTypeId, @Valid DeleteAttributesRequest deleteAttributesRequest) {
        MetadataUpsertJobExecution jobExecution = this.metadataApiService.deleteAttributesAsync(entityTypeId, deleteAttributesRequest.getQ());
        return this.toLocationResponse(jobExecution);
    }

    @Transactional
    @PutMapping(value={"/{entityTypeId}"})
    public ResponseEntity<Void> updateEntityType(@PathVariable(value="entityTypeId") String entityTypeId, @Valid @RequestBody CreateEntityTypeRequest createEntityTypeRequest) {
        EntityType entityType = this.entityTypeRequestMapper.toEntityType(createEntityTypeRequest);
        entityType.setId(entityTypeId);
        MetadataUpsertJobExecution jobExecution = this.metadataApiService.updateEntityTypeAsync(entityType);
        return this.toLocationResponse(jobExecution);
    }

    @Transactional
    @PutMapping(value={"/{entityTypeId}/attributes/{attributeId}"})
    public ResponseEntity<Void> updateAttribute(@PathVariable(value="entityTypeId") String entityTypeId, @PathVariable(value="attributeId") String attributeId, @Valid @RequestBody CreateAttributeRequest createAttributeRequest) {
        EntityType entityType = this.metadataApiService.findEntityType(entityTypeId);
        Attribute currentAttribute = entityType.getOwnAttributeById(attributeId);
        Attribute updatedAttribute = this.attributeRequestMapper.toAttribute(createAttributeRequest, entityType);
        updatedAttribute.setIdentifier(attributeId);
        if (updatedAttribute.getSequenceNumber() == null) {
            updatedAttribute.setSequenceNumber(currentAttribute.getSequenceNumber().intValue());
        }
        this.replaceAttribute(entityType, updatedAttribute);
        MetadataUpsertJobExecution jobExecution = this.metadataApiService.updateEntityTypeAsync(entityType);
        return this.toLocationResponse(jobExecution);
    }

    @Transactional
    @PatchMapping(value={"/{entityTypeId}/attributes/{attributeId}"})
    public ResponseEntity<Void> updatePartialAttribute(@PathVariable(value="entityTypeId") String entityTypeId, @PathVariable(value="attributeId") String attributeId, @RequestBody Map<String, Object> attributeValues) {
        EntityType entityType = this.metadataApiService.findEntityType(entityTypeId);
        Attribute attribute = entityType.getOwnAttributeById(attributeId);
        this.attributeRequestMapper.updateAttribute(attribute, attributeValues);
        MetadataUpsertJobExecution jobExecution = this.metadataApiService.updateEntityTypeAsync(entityType);
        return this.toLocationResponse(jobExecution);
    }

    @Transactional
    @PatchMapping(value={"/{entityTypeId}"})
    public ResponseEntity<Void> updatePartialEntityType(@PathVariable(value="entityTypeId") String entityTypeId, @RequestBody Map<String, Object> entityTypeValues) {
        EntityType entityType = this.metadataApiService.findEntityType(entityTypeId);
        this.entityTypeRequestMapper.updateEntityType(entityType, entityTypeValues);
        MetadataUpsertJobExecution jobExecution = this.metadataApiService.updateEntityTypeAsync(entityType);
        return this.toLocationResponse(jobExecution);
    }

    @Transactional
    @DeleteMapping(value={"/{entityTypeId}"})
    public ResponseEntity<Void> deleteEntityType(@PathVariable(value="entityTypeId") String entityTypeId) {
        MetadataDeleteJobExecution jobExecution = this.metadataApiService.deleteEntityTypeAsync(entityTypeId);
        return this.toLocationResponse(jobExecution);
    }

    @Transactional
    @DeleteMapping
    public ResponseEntity<Void> deleteEntityTypes(@Valid DeleteEntityTypesRequest deleteEntityTypesRequest) {
        MetadataDeleteJobExecution jobExecution = this.metadataApiService.deleteEntityTypesAsync(deleteEntityTypesRequest.getQ());
        return this.toLocationResponse(jobExecution);
    }

    private void replaceAttribute(EntityType entityType, Attribute attribute) {
        ArrayList updatedAttributes = new ArrayList();
        entityType.getOwnAllAttributes().forEach(currentAttribute -> {
            if (currentAttribute.getIdentifier().equals(attribute.getIdentifier())) {
                updatedAttributes.add(attribute);
            } else {
                updatedAttributes.add(currentAttribute);
            }
        });
        entityType.setOwnAllAttributes(updatedAttributes);
    }

    private ResponseEntity<Void> toLocationResponse(JobExecution jobExecution) {
        URI location = ServletUriComponentsBuilder.fromCurrentRequestUri().replacePath("/api/data").pathSegment(new String[]{jobExecution.getEntityType().getId(), jobExecution.getIdentifier()}).build().toUri();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(location)).build();
    }
}

