/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.molgenis.api.metadata.v3.MetadataApiJobService;
import org.molgenis.api.metadata.v3.job.EntityTypeSerializer;
import org.molgenis.api.metadata.v3.job.MetadataDeleteJobExecution;
import org.molgenis.api.metadata.v3.job.MetadataDeleteJobExecutionFactory;
import org.molgenis.api.metadata.v3.job.MetadataUpsertJobExecution;
import org.molgenis.api.metadata.v3.job.MetadataUpsertJobExecutionFactory;
import org.molgenis.api.metadata.v3.job.MetadataUpsertJobExecutionMetadata;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.jobs.JobExecutor;
import org.molgenis.jobs.model.JobExecution;
import org.springframework.stereotype.Service;

@Service
public class MetadataApiJobServiceImpl
implements MetadataApiJobService {
    private final MetadataUpsertJobExecutionFactory metadataUpsertJobExecutionFactory;
    private final MetadataDeleteJobExecutionFactory metadataDeleteJobExecutionFactory;
    private final JobExecutor jobExecutor;
    private final EntityTypeSerializer entityTypeSerializer;

    MetadataApiJobServiceImpl(MetadataUpsertJobExecutionFactory metadataUpsertJobExecutionFactory, MetadataDeleteJobExecutionFactory metadataDeleteJobExecutionFactory, JobExecutor jobExecutor, EntityTypeSerializer entityTypeSerializer) {
        this.metadataUpsertJobExecutionFactory = Objects.requireNonNull(metadataUpsertJobExecutionFactory);
        this.metadataDeleteJobExecutionFactory = Objects.requireNonNull(metadataDeleteJobExecutionFactory);
        this.jobExecutor = Objects.requireNonNull(jobExecutor);
        this.entityTypeSerializer = Objects.requireNonNull(entityTypeSerializer);
    }

    @Override
    public MetadataUpsertJobExecution scheduleCreate(EntityType entityType) {
        return this.scheduleUpsert(MetadataUpsertJobExecutionMetadata.Action.CREATE, entityType);
    }

    @Override
    public MetadataUpsertJobExecution scheduleUpdate(EntityType entityType) {
        return this.scheduleUpsert(MetadataUpsertJobExecutionMetadata.Action.UPDATE, entityType);
    }

    @Override
    public MetadataDeleteJobExecution scheduleDelete(EntityType entityType) {
        return this.scheduleDelete(Collections.singletonList(entityType.getId()));
    }

    @Override
    public MetadataDeleteJobExecution scheduleDelete(Collection<EntityType> entityTypes) {
        return this.scheduleDelete(entityTypes.stream().map(EntityType::getId).collect(Collectors.toList()));
    }

    private MetadataDeleteJobExecution scheduleDelete(List<String> entityTypeIds) {
        MetadataDeleteJobExecution jobExecution = (MetadataDeleteJobExecution)this.metadataDeleteJobExecutionFactory.create();
        jobExecution.setIds(entityTypeIds);
        this.jobExecutor.submit((JobExecution)jobExecution);
        return jobExecution;
    }

    private MetadataUpsertJobExecution scheduleUpsert(MetadataUpsertJobExecutionMetadata.Action action, EntityType entityType) {
        MetadataUpsertJobExecution jobExecution = (MetadataUpsertJobExecution)this.metadataUpsertJobExecutionFactory.create();
        jobExecution.setAction(action);
        jobExecution.setEntityTypeData(this.entityTypeSerializer.serializeEntityType(entityType));
        this.jobExecutor.submit((JobExecution)jobExecution);
        return jobExecution;
    }
}

