/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3.exception;

import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.util.Strings;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.util.exception.BadRequestException;

public class UnknownLookupAttributesException
extends BadRequestException {
    private static final String ERROR_CODE = "MAPI05";
    private final String entityTypeId;
    private final List<String> attributeIds;

    public UnknownLookupAttributesException(EntityType entityType, List<String> attributeIds) {
        super(ERROR_CODE);
        this.entityTypeId = Objects.requireNonNull(entityType).getId();
        this.attributeIds = Objects.requireNonNull(attributeIds);
    }

    public String getMessage() {
        return String.format("entityType:%s attributeIds:%s", this.entityTypeId, Strings.join(this.attributeIds, (char)','));
    }

    protected Object[] getLocalizedMessageArguments() {
        return new Object[]{this.entityTypeId, Strings.join(this.attributeIds, (char)',')};
    }
}

