/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3.job;

import java.util.List;
import org.molgenis.api.metadata.v3.job.MetadataDeleteJobExecution;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.jobs.Job;
import org.molgenis.jobs.JobFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetadataDeleteConfig {
    private final MetaDataService metadataService;

    public MetadataDeleteConfig(MetaDataService metaDataService) {
        this.metadataService = metaDataService;
    }

    @Bean
    public JobFactory<MetadataDeleteJobExecution> metadataDeleteJobExecutionJobFactory() {
        return new JobFactory<MetadataDeleteJobExecution>(){

            public Job createJob(MetadataDeleteJobExecution metadataDeleteJobExecution) {
                List<String> ids = metadataDeleteJobExecution.getIds();
                if (ids.size() == 1 && !ids.get(0).isEmpty()) {
                    return progress -> MetadataDeleteConfig.this.deleteEntityType((String)ids.get(0));
                }
                return progress -> MetadataDeleteConfig.this.deleteEntityTypes(ids);
            }
        };
    }

    private Void deleteEntityType(String entityTypeId) {
        this.metadataService.deleteEntityType(entityTypeId);
        return null;
    }

    private Void deleteEntityTypes(List<String> entityTypeIds) {
        this.metadataService.deleteEntityTypes(entityTypeIds);
        return null;
    }
}

