package org.molgenis.api.metadata.v3.job;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SerializableAttribute extends SerializableAttribute {

  private final String id;

  private final String name;

  private final int sequenceNr;

  private final String type;

  private final boolean idAttribute;

  private final boolean labelAttribute;

  private final Integer lookupAttributeIndex;

  private final String refEntityTypeId;

  private final Optional<Boolean> cascadeDelete;

  private final String mappedById;

  private final String orderBy;

  private final String label;

  private final ImmutableMap<String, String> labelI18n;

  private final String description;

  private final ImmutableMap<String, String> descriptionI18n;

  private final boolean nullable;

  private final boolean auto;

  private final boolean visible;

  private final boolean unique;

  private final boolean readOnly;

  private final boolean aggregatable;

  private final String expression;

  private final ImmutableList<String> enumOptions;

  private final Long rangeMin;

  private final Long rangeMax;

  private final String parentId;

  private final ImmutableList<String> tagIds;

  private final String nullableExpression;

  private final String visibleExpression;

  private final String validationExpression;

  private final String defaultValue;

  private AutoValue_SerializableAttribute(
      String id,
      String name,
      int sequenceNr,
      String type,
      boolean idAttribute,
      boolean labelAttribute,
      @Nullable Integer lookupAttributeIndex,
      @Nullable String refEntityTypeId,
      Optional<Boolean> cascadeDelete,
      @Nullable String mappedById,
      @Nullable String orderBy,
      String label,
      ImmutableMap<String, String> labelI18n,
      @Nullable String description,
      ImmutableMap<String, String> descriptionI18n,
      boolean nullable,
      boolean auto,
      boolean visible,
      boolean unique,
      boolean readOnly,
      boolean aggregatable,
      @Nullable String expression,
      @Nullable ImmutableList<String> enumOptions,
      @Nullable Long rangeMin,
      @Nullable Long rangeMax,
      @Nullable String parentId,
      ImmutableList<String> tagIds,
      @Nullable String nullableExpression,
      @Nullable String visibleExpression,
      @Nullable String validationExpression,
      @Nullable String defaultValue) {
    this.id = id;
    this.name = name;
    this.sequenceNr = sequenceNr;
    this.type = type;
    this.idAttribute = idAttribute;
    this.labelAttribute = labelAttribute;
    this.lookupAttributeIndex = lookupAttributeIndex;
    this.refEntityTypeId = refEntityTypeId;
    this.cascadeDelete = cascadeDelete;
    this.mappedById = mappedById;
    this.orderBy = orderBy;
    this.label = label;
    this.labelI18n = labelI18n;
    this.description = description;
    this.descriptionI18n = descriptionI18n;
    this.nullable = nullable;
    this.auto = auto;
    this.visible = visible;
    this.unique = unique;
    this.readOnly = readOnly;
    this.aggregatable = aggregatable;
    this.expression = expression;
    this.enumOptions = enumOptions;
    this.rangeMin = rangeMin;
    this.rangeMax = rangeMax;
    this.parentId = parentId;
    this.tagIds = tagIds;
    this.nullableExpression = nullableExpression;
    this.visibleExpression = visibleExpression;
    this.validationExpression = validationExpression;
    this.defaultValue = defaultValue;
  }

  @Override
  String getId() {
    return id;
  }

  @Override
  String getName() {
    return name;
  }

  @Override
  int getSequenceNr() {
    return sequenceNr;
  }

  @Override
  String getType() {
    return type;
  }

  @Override
  boolean isIdAttribute() {
    return idAttribute;
  }

  @Override
  boolean isLabelAttribute() {
    return labelAttribute;
  }

  @Nullable
  @CheckForNull
  @Override
  Integer getLookupAttributeIndex() {
    return lookupAttributeIndex;
  }

  @Nullable
  @CheckForNull
  @Override
  String getRefEntityTypeId() {
    return refEntityTypeId;
  }

  @Override
  Optional<Boolean> getCascadeDelete() {
    return cascadeDelete;
  }

  @Nullable
  @CheckForNull
  @Override
  String getMappedById() {
    return mappedById;
  }

  @Nullable
  @CheckForNull
  @Override
  String getOrderBy() {
    return orderBy;
  }

  @Override
  String getLabel() {
    return label;
  }

  @Override
  ImmutableMap<String, String> getLabelI18n() {
    return labelI18n;
  }

  @Nullable
  @CheckForNull
  @Override
  String getDescription() {
    return description;
  }

  @Override
  ImmutableMap<String, String> getDescriptionI18n() {
    return descriptionI18n;
  }

  @Override
  boolean isNullable() {
    return nullable;
  }

  @Override
  boolean isAuto() {
    return auto;
  }

  @Override
  boolean isVisible() {
    return visible;
  }

  @Override
  boolean isUnique() {
    return unique;
  }

  @Override
  boolean isReadOnly() {
    return readOnly;
  }

  @Override
  boolean isAggregatable() {
    return aggregatable;
  }

  @Nullable
  @CheckForNull
  @Override
  String getExpression() {
    return expression;
  }

  @Nullable
  @CheckForNull
  @Override
  ImmutableList<String> getEnumOptions() {
    return enumOptions;
  }

  @Nullable
  @CheckForNull
  @Override
  Long getRangeMin() {
    return rangeMin;
  }

  @Nullable
  @CheckForNull
  @Override
  Long getRangeMax() {
    return rangeMax;
  }

  @Nullable
  @CheckForNull
  @Override
  String getParentId() {
    return parentId;
  }

  @Override
  ImmutableList<String> getTagIds() {
    return tagIds;
  }

  @Nullable
  @CheckForNull
  @Override
  String getNullableExpression() {
    return nullableExpression;
  }

  @Nullable
  @CheckForNull
  @Override
  String getVisibleExpression() {
    return visibleExpression;
  }

  @Nullable
  @CheckForNull
  @Override
  String getValidationExpression() {
    return validationExpression;
  }

  @Nullable
  @CheckForNull
  @Override
  String getDefaultValue() {
    return defaultValue;
  }

  @Override
  public String toString() {
    return "SerializableAttribute{"
         + "id=" + id + ", "
         + "name=" + name + ", "
         + "sequenceNr=" + sequenceNr + ", "
         + "type=" + type + ", "
         + "idAttribute=" + idAttribute + ", "
         + "labelAttribute=" + labelAttribute + ", "
         + "lookupAttributeIndex=" + lookupAttributeIndex + ", "
         + "refEntityTypeId=" + refEntityTypeId + ", "
         + "cascadeDelete=" + cascadeDelete + ", "
         + "mappedById=" + mappedById + ", "
         + "orderBy=" + orderBy + ", "
         + "label=" + label + ", "
         + "labelI18n=" + labelI18n + ", "
         + "description=" + description + ", "
         + "descriptionI18n=" + descriptionI18n + ", "
         + "nullable=" + nullable + ", "
         + "auto=" + auto + ", "
         + "visible=" + visible + ", "
         + "unique=" + unique + ", "
         + "readOnly=" + readOnly + ", "
         + "aggregatable=" + aggregatable + ", "
         + "expression=" + expression + ", "
         + "enumOptions=" + enumOptions + ", "
         + "rangeMin=" + rangeMin + ", "
         + "rangeMax=" + rangeMax + ", "
         + "parentId=" + parentId + ", "
         + "tagIds=" + tagIds + ", "
         + "nullableExpression=" + nullableExpression + ", "
         + "visibleExpression=" + visibleExpression + ", "
         + "validationExpression=" + validationExpression + ", "
         + "defaultValue=" + defaultValue
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SerializableAttribute) {
      SerializableAttribute that = (SerializableAttribute) o;
      return this.id.equals(that.getId())
          && this.name.equals(that.getName())
          && this.sequenceNr == that.getSequenceNr()
          && this.type.equals(that.getType())
          && this.idAttribute == that.isIdAttribute()
          && this.labelAttribute == that.isLabelAttribute()
          && (this.lookupAttributeIndex == null ? that.getLookupAttributeIndex() == null : this.lookupAttributeIndex.equals(that.getLookupAttributeIndex()))
          && (this.refEntityTypeId == null ? that.getRefEntityTypeId() == null : this.refEntityTypeId.equals(that.getRefEntityTypeId()))
          && this.cascadeDelete.equals(that.getCascadeDelete())
          && (this.mappedById == null ? that.getMappedById() == null : this.mappedById.equals(that.getMappedById()))
          && (this.orderBy == null ? that.getOrderBy() == null : this.orderBy.equals(that.getOrderBy()))
          && this.label.equals(that.getLabel())
          && this.labelI18n.equals(that.getLabelI18n())
          && (this.description == null ? that.getDescription() == null : this.description.equals(that.getDescription()))
          && this.descriptionI18n.equals(that.getDescriptionI18n())
          && this.nullable == that.isNullable()
          && this.auto == that.isAuto()
          && this.visible == that.isVisible()
          && this.unique == that.isUnique()
          && this.readOnly == that.isReadOnly()
          && this.aggregatable == that.isAggregatable()
          && (this.expression == null ? that.getExpression() == null : this.expression.equals(that.getExpression()))
          && (this.enumOptions == null ? that.getEnumOptions() == null : this.enumOptions.equals(that.getEnumOptions()))
          && (this.rangeMin == null ? that.getRangeMin() == null : this.rangeMin.equals(that.getRangeMin()))
          && (this.rangeMax == null ? that.getRangeMax() == null : this.rangeMax.equals(that.getRangeMax()))
          && (this.parentId == null ? that.getParentId() == null : this.parentId.equals(that.getParentId()))
          && this.tagIds.equals(that.getTagIds())
          && (this.nullableExpression == null ? that.getNullableExpression() == null : this.nullableExpression.equals(that.getNullableExpression()))
          && (this.visibleExpression == null ? that.getVisibleExpression() == null : this.visibleExpression.equals(that.getVisibleExpression()))
          && (this.validationExpression == null ? that.getValidationExpression() == null : this.validationExpression.equals(that.getValidationExpression()))
          && (this.defaultValue == null ? that.getDefaultValue() == null : this.defaultValue.equals(that.getDefaultValue()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= sequenceNr;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= idAttribute ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= labelAttribute ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (lookupAttributeIndex == null) ? 0 : lookupAttributeIndex.hashCode();
    h$ *= 1000003;
    h$ ^= (refEntityTypeId == null) ? 0 : refEntityTypeId.hashCode();
    h$ *= 1000003;
    h$ ^= cascadeDelete.hashCode();
    h$ *= 1000003;
    h$ ^= (mappedById == null) ? 0 : mappedById.hashCode();
    h$ *= 1000003;
    h$ ^= (orderBy == null) ? 0 : orderBy.hashCode();
    h$ *= 1000003;
    h$ ^= label.hashCode();
    h$ *= 1000003;
    h$ ^= labelI18n.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= descriptionI18n.hashCode();
    h$ *= 1000003;
    h$ ^= nullable ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= auto ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= visible ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= unique ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= readOnly ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= aggregatable ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (expression == null) ? 0 : expression.hashCode();
    h$ *= 1000003;
    h$ ^= (enumOptions == null) ? 0 : enumOptions.hashCode();
    h$ *= 1000003;
    h$ ^= (rangeMin == null) ? 0 : rangeMin.hashCode();
    h$ *= 1000003;
    h$ ^= (rangeMax == null) ? 0 : rangeMax.hashCode();
    h$ *= 1000003;
    h$ ^= (parentId == null) ? 0 : parentId.hashCode();
    h$ *= 1000003;
    h$ ^= tagIds.hashCode();
    h$ *= 1000003;
    h$ ^= (nullableExpression == null) ? 0 : nullableExpression.hashCode();
    h$ *= 1000003;
    h$ ^= (visibleExpression == null) ? 0 : visibleExpression.hashCode();
    h$ *= 1000003;
    h$ ^= (validationExpression == null) ? 0 : validationExpression.hashCode();
    h$ *= 1000003;
    h$ ^= (defaultValue == null) ? 0 : defaultValue.hashCode();
    return h$;
  }

  static final class Builder extends SerializableAttribute.Builder {
    private String id;
    private String name;
    private Integer sequenceNr;
    private String type;
    private Boolean idAttribute;
    private Boolean labelAttribute;
    private Integer lookupAttributeIndex;
    private String refEntityTypeId;
    private Optional<Boolean> cascadeDelete = Optional.empty();
    private String mappedById;
    private String orderBy;
    private String label;
    private ImmutableMap<String, String> labelI18n;
    private String description;
    private ImmutableMap<String, String> descriptionI18n;
    private Boolean nullable;
    private Boolean auto;
    private Boolean visible;
    private Boolean unique;
    private Boolean readOnly;
    private Boolean aggregatable;
    private String expression;
    private ImmutableList<String> enumOptions;
    private Long rangeMin;
    private Long rangeMax;
    private String parentId;
    private ImmutableList<String> tagIds;
    private String nullableExpression;
    private String visibleExpression;
    private String validationExpression;
    private String defaultValue;
    Builder() {
    }
    @Override
    public SerializableAttribute.Builder setId(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setSequenceNr(int sequenceNr) {
      this.sequenceNr = sequenceNr;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setType(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setIdAttribute(boolean idAttribute) {
      this.idAttribute = idAttribute;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setLabelAttribute(boolean labelAttribute) {
      this.labelAttribute = labelAttribute;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setLookupAttributeIndex(Integer lookupAttributeIndex) {
      this.lookupAttributeIndex = lookupAttributeIndex;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setRefEntityTypeId(String refEntityTypeId) {
      this.refEntityTypeId = refEntityTypeId;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setCascadeDelete(Optional<Boolean> cascadeDelete) {
      if (cascadeDelete == null) {
        throw new NullPointerException("Null cascadeDelete");
      }
      this.cascadeDelete = cascadeDelete;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setMappedById(String mappedById) {
      this.mappedById = mappedById;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setOrderBy(String orderBy) {
      this.orderBy = orderBy;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setLabel(String label) {
      if (label == null) {
        throw new NullPointerException("Null label");
      }
      this.label = label;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setLabelI18n(ImmutableMap<String, String> labelI18n) {
      if (labelI18n == null) {
        throw new NullPointerException("Null labelI18n");
      }
      this.labelI18n = labelI18n;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setDescription(String description) {
      this.description = description;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setDescriptionI18n(ImmutableMap<String, String> descriptionI18n) {
      if (descriptionI18n == null) {
        throw new NullPointerException("Null descriptionI18n");
      }
      this.descriptionI18n = descriptionI18n;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setNullable(boolean nullable) {
      this.nullable = nullable;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setAuto(boolean auto) {
      this.auto = auto;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setVisible(boolean visible) {
      this.visible = visible;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setUnique(boolean unique) {
      this.unique = unique;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setReadOnly(boolean readOnly) {
      this.readOnly = readOnly;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setAggregatable(boolean aggregatable) {
      this.aggregatable = aggregatable;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setExpression(String expression) {
      this.expression = expression;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setEnumOptions(ImmutableList<String> enumOptions) {
      this.enumOptions = enumOptions;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setRangeMin(Long rangeMin) {
      this.rangeMin = rangeMin;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setRangeMax(Long rangeMax) {
      this.rangeMax = rangeMax;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setParentId(String parentId) {
      this.parentId = parentId;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setTagIds(ImmutableList<String> tagIds) {
      if (tagIds == null) {
        throw new NullPointerException("Null tagIds");
      }
      this.tagIds = tagIds;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setNullableExpression(String nullableExpression) {
      this.nullableExpression = nullableExpression;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setVisibleExpression(String visibleExpression) {
      this.visibleExpression = visibleExpression;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setValidationExpression(String validationExpression) {
      this.validationExpression = validationExpression;
      return this;
    }
    @Override
    public SerializableAttribute.Builder setDefaultValue(String defaultValue) {
      this.defaultValue = defaultValue;
      return this;
    }
    @Override
    public SerializableAttribute build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.sequenceNr == null) {
        missing += " sequenceNr";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (this.idAttribute == null) {
        missing += " idAttribute";
      }
      if (this.labelAttribute == null) {
        missing += " labelAttribute";
      }
      if (this.label == null) {
        missing += " label";
      }
      if (this.labelI18n == null) {
        missing += " labelI18n";
      }
      if (this.descriptionI18n == null) {
        missing += " descriptionI18n";
      }
      if (this.nullable == null) {
        missing += " nullable";
      }
      if (this.auto == null) {
        missing += " auto";
      }
      if (this.visible == null) {
        missing += " visible";
      }
      if (this.unique == null) {
        missing += " unique";
      }
      if (this.readOnly == null) {
        missing += " readOnly";
      }
      if (this.aggregatable == null) {
        missing += " aggregatable";
      }
      if (this.tagIds == null) {
        missing += " tagIds";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SerializableAttribute(
          this.id,
          this.name,
          this.sequenceNr,
          this.type,
          this.idAttribute,
          this.labelAttribute,
          this.lookupAttributeIndex,
          this.refEntityTypeId,
          this.cascadeDelete,
          this.mappedById,
          this.orderBy,
          this.label,
          this.labelI18n,
          this.description,
          this.descriptionI18n,
          this.nullable,
          this.auto,
          this.visible,
          this.unique,
          this.readOnly,
          this.aggregatable,
          this.expression,
          this.enumOptions,
          this.rangeMin,
          this.rangeMax,
          this.parentId,
          this.tagIds,
          this.nullableExpression,
          this.visibleExpression,
          this.validationExpression,
          this.defaultValue);
    }
  }

}
