package org.molgenis.api.metadata.v3.model;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.molgenis.api.model.response.LinksResponse;
import org.molgenis.api.model.response.PageResponse;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AttributesResponse extends AttributesResponse {

  private final LinksResponse links;

  private final List<AttributeResponse> items;

  private final PageResponse page;

  private AutoValue_AttributesResponse(
      LinksResponse links,
      @Nullable List<AttributeResponse> items,
      @Nullable PageResponse page) {
    this.links = links;
    this.items = items;
    this.page = page;
  }

  @Override
  public LinksResponse getLinks() {
    return links;
  }

  @Nullable
  @CheckForNull
  @Override
  public List<AttributeResponse> getItems() {
    return items;
  }

  @Nullable
  @CheckForNull
  @Override
  public PageResponse getPage() {
    return page;
  }

  @Override
  public String toString() {
    return "AttributesResponse{"
         + "links=" + links + ", "
         + "items=" + items + ", "
         + "page=" + page
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AttributesResponse) {
      AttributesResponse that = (AttributesResponse) o;
      return this.links.equals(that.getLinks())
          && (this.items == null ? that.getItems() == null : this.items.equals(that.getItems()))
          && (this.page == null ? that.getPage() == null : this.page.equals(that.getPage()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= links.hashCode();
    h$ *= 1000003;
    h$ ^= (items == null) ? 0 : items.hashCode();
    h$ *= 1000003;
    h$ ^= (page == null) ? 0 : page.hashCode();
    return h$;
  }

  static final class Builder extends AttributesResponse.Builder {
    private LinksResponse links;
    private List<AttributeResponse> items;
    private PageResponse page;
    Builder() {
    }
    @Override
    public AttributesResponse.Builder setLinks(LinksResponse links) {
      if (links == null) {
        throw new NullPointerException("Null links");
      }
      this.links = links;
      return this;
    }
    @Override
    public AttributesResponse.Builder setItems(List<AttributeResponse> items) {
      this.items = items;
      return this;
    }
    @Override
    public AttributesResponse.Builder setPage(PageResponse page) {
      this.page = page;
      return this;
    }
    @Override
    public AttributesResponse build() {
      String missing = "";
      if (this.links == null) {
        missing += " links";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AttributesResponse(
          this.links,
          this.items,
          this.page);
    }
  }

}
