/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3.job;

import com.baggonius.gson.immutable.ImmutableListDeserializer;
import com.baggonius.gson.immutable.ImmutableMapDeserializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.molgenis.api.metadata.v3.MetadataUtils;
import org.molgenis.api.metadata.v3.job.EntityTypeSerializer;
import org.molgenis.api.metadata.v3.job.SerializableAttribute;
import org.molgenis.api.metadata.v3.job.SerializableEntityType;
import org.molgenis.data.DataService;
import org.molgenis.data.Fetch;
import org.molgenis.data.Sort;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.meta.model.Tag;
import org.molgenis.web.converter.AutoValueTypeAdapterFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityTypeSerializerImpl
implements EntityTypeSerializer {
    private final DataService dataService;
    private final EntityTypeFactory entityTypeFactory;
    private final AttributeFactory attributeFactory;
    private final Gson gson;

    EntityTypeSerializerImpl(DataService dataService, EntityTypeFactory entityTypeFactory, AttributeFactory attributeFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.entityTypeFactory = Objects.requireNonNull(entityTypeFactory);
        this.attributeFactory = Objects.requireNonNull(attributeFactory);
        this.gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new AutoValueTypeAdapterFactory()).registerTypeAdapter(ImmutableList.class, (Object)new ImmutableListDeserializer()).registerTypeAdapter(ImmutableMap.class, (Object)new ImmutableMapDeserializer()).create();
    }

    @Override
    public String serializeEntityType(EntityType entityType) {
        SerializableEntityType serializableEntityType = EntityTypeSerializerImpl.toSerializableEntityType(entityType);
        return this.gson.toJson((Object)serializableEntityType);
    }

    @Override
    public EntityType deserializeEntityType(String serializedEntityType) {
        SerializableEntityType serializableEntityType = (SerializableEntityType)this.gson.fromJson(serializedEntityType, SerializableEntityType.class);
        return this.toEntityType(serializableEntityType);
    }

    private static SerializableEntityType toSerializableEntityType(EntityType entityType) {
        Package aPackage = entityType.getPackage();
        String packageId = aPackage != null ? aPackage.getId() : null;
        EntityType anExtends = entityType.getExtends();
        String extendsId = anExtends != null ? anExtends.getId() : null;
        return SerializableEntityType.builder().setId(entityType.getId()).setPackageId(packageId).setLabel(entityType.getLabel()).setLabelI18n(MetadataUtils.getI18n(entityType, "label")).setDescription(entityType.getDescription()).setDescriptionI18n(MetadataUtils.getI18n(entityType, "description")).setAttributes((ImmutableList<SerializableAttribute>)ImmutableList.copyOf((Collection)Streams.stream((Iterable)entityType.getOwnAllAttributes()).map(EntityTypeSerializerImpl::toSerializableAttribute).collect(Collectors.toList()))).setAbstract(entityType.isAbstract()).setExtendsId(extendsId).setTagIds((ImmutableList<String>)ImmutableList.copyOf((Collection)Streams.stream((Iterable)entityType.getTags()).map(Tag::getId).collect(Collectors.toList()))).setBackend(entityType.getBackend()).setIndexingDepth(entityType.getIndexingDepth()).build();
    }

    private static SerializableAttribute toSerializableAttribute(Attribute attribute) {
        EntityType refEntityType = attribute.hasRefEntity() ? attribute.getRefEntity() : null;
        String refEntityTypeId = refEntityType != null ? refEntityType.getId() : null;
        Attribute mappedBy = attribute.getMappedBy();
        String mappedById = mappedBy != null ? mappedBy.getIdentifier() : null;
        Sort sort = attribute.getOrderBy();
        String orderBy = sort != null ? sort.toSortString() : null;
        Attribute parent = attribute.getParent();
        String parentId = parent != null ? parent.getIdentifier() : null;
        return SerializableAttribute.builder().setId(attribute.getIdentifier()).setName(attribute.getName()).setSequenceNr(attribute.getSequenceNumber()).setType(AttributeType.getValueString((AttributeType)attribute.getDataType())).setIdAttribute(attribute.isIdAttribute()).setLabelAttribute(attribute.isLabelAttribute()).setLookupAttributeIndex(attribute.getLookupAttributeIndex()).setRefEntityTypeId(refEntityTypeId).setCascadeDelete(Optional.ofNullable(attribute.getCascadeDelete())).setMappedById(mappedById).setOrderBy(orderBy).setLabel(attribute.getLabel()).setLabelI18n(MetadataUtils.getI18n(attribute, "label")).setDescription(attribute.getDescription()).setDescriptionI18n(MetadataUtils.getI18n(attribute, "description")).setNullable(attribute.isNillable()).setAuto(attribute.isAuto()).setVisible(attribute.isVisible()).setUnique(attribute.isUnique()).setReadOnly(attribute.isReadOnly()).setAggregatable(attribute.isAggregatable()).setExpression(attribute.getExpression()).setEnumOptions((ImmutableList<String>)ImmutableList.copyOf((Collection)attribute.getEnumOptions())).setRangeMin(attribute.getRangeMin()).setRangeMax(attribute.getRangeMax()).setParentId(parentId).setTagIds((ImmutableList<String>)ImmutableList.copyOf((Collection)Streams.stream((Iterable)attribute.getTags()).map(Tag::getId).collect(Collectors.toList()))).setNullableExpression(attribute.getNullableExpression()).setVisibleExpression(attribute.getVisibleExpression()).setValidationExpression(attribute.getValidationExpression()).setDefaultValue(attribute.getDefaultValue()).build();
    }

    private EntityType toEntityType(SerializableEntityType serializableEntityType) {
        String packageId = serializableEntityType.getPackageId();
        Package aPackage = packageId != null ? this.getPackage(packageId) : null;
        String extendsId = serializableEntityType.getExtendsId();
        EntityType anExtends = extendsId != null ? this.getEntityType(extendsId) : null;
        ImmutableList<String> tagIds = serializableEntityType.getTagIds();
        List<Tag> tags = this.getTags(tagIds);
        EntityType entityType = (EntityType)this.entityTypeFactory.create();
        entityType.setId(serializableEntityType.getId());
        entityType.setPackage(aPackage);
        entityType.setLabel(serializableEntityType.getLabel());
        serializableEntityType.getLabelI18n().forEach((arg_0, arg_1) -> ((EntityType)entityType).setLabel(arg_0, arg_1));
        entityType.setDescription(serializableEntityType.getDescription());
        serializableEntityType.getDescriptionI18n().forEach((arg_0, arg_1) -> ((EntityType)entityType).setDescription(arg_0, arg_1));
        entityType.setOwnAllAttributes((Iterable)serializableEntityType.getAttributes().stream().map(this::toAttribute).map(attr -> attr.setEntity(entityType)).collect(Collectors.toList()));
        entityType.setAbstract(serializableEntityType.isAbstract());
        entityType.setExtends(anExtends);
        entityType.setTags(tags);
        entityType.setBackend(serializableEntityType.getBackend());
        entityType.setIndexingDepth(serializableEntityType.getIndexingDepth());
        return entityType;
    }

    private Package getPackage(String packageId) {
        return (Package)this.dataService.findOneById("sys_md_Package", (Object)packageId, new Fetch().field("id"), Package.class);
    }

    private List<Tag> getTags(ImmutableList<String> tagIds) {
        return !tagIds.isEmpty() ? this.dataService.findAll("sys_md_Tag", tagIds.stream(), new Fetch().field("id"), Tag.class).collect(Collectors.toList()) : Collections.emptyList();
    }

    private Attribute toAttribute(SerializableAttribute serializableAttribute) {
        String refEntityTypeId = serializableAttribute.getRefEntityTypeId();
        EntityType refEntityType = refEntityTypeId != null ? this.getEntityType(refEntityTypeId) : null;
        String mappedById = serializableAttribute.getMappedById();
        Attribute mappedByAttr = mappedById != null ? this.getAttribute(mappedById) : null;
        String orderBy = serializableAttribute.getOrderBy();
        Sort sort = orderBy != null ? Sort.parse((String)orderBy) : null;
        String parentId = serializableAttribute.getParentId();
        Attribute parent = parentId != null ? this.getAttribute(parentId) : null;
        ImmutableList<String> tagIds = serializableAttribute.getTagIds();
        List<Tag> tags = this.getTags(tagIds);
        Attribute attribute = this.attributeFactory.create();
        attribute.setIdentifier(serializableAttribute.getId());
        attribute.setName(serializableAttribute.getName());
        attribute.setSequenceNumber(serializableAttribute.getSequenceNr());
        attribute.setDataType(AttributeType.toEnum((String)serializableAttribute.getType()));
        attribute.setIdAttribute(Boolean.valueOf(serializableAttribute.isIdAttribute()));
        attribute.setLabelAttribute(Boolean.valueOf(serializableAttribute.isLabelAttribute()));
        attribute.setLookupAttributeIndex(serializableAttribute.getLookupAttributeIndex());
        attribute.setRefEntity(refEntityType);
        attribute.setCascadeDelete((Boolean)serializableAttribute.getCascadeDelete().orElse(null));
        attribute.setMappedBy(mappedByAttr);
        attribute.setOrderBy(sort);
        attribute.setLabel(serializableAttribute.getLabel());
        serializableAttribute.getLabelI18n().forEach((arg_0, arg_1) -> ((Attribute)attribute).setLabel(arg_0, arg_1));
        attribute.setDescription(serializableAttribute.getDescription());
        serializableAttribute.getDescriptionI18n().forEach((arg_0, arg_1) -> ((Attribute)attribute).setDescription(arg_0, arg_1));
        attribute.setNillable(serializableAttribute.isNullable());
        attribute.setAuto(serializableAttribute.isAuto());
        attribute.setVisible(serializableAttribute.isVisible());
        attribute.setUnique(serializableAttribute.isUnique());
        attribute.setReadOnly(serializableAttribute.isReadOnly());
        attribute.setAggregatable(serializableAttribute.isAggregatable());
        attribute.setExpression(serializableAttribute.getExpression());
        attribute.setEnumOptions(serializableAttribute.getEnumOptions());
        attribute.setRangeMin(serializableAttribute.getRangeMin());
        attribute.setRangeMax(serializableAttribute.getRangeMax());
        attribute.setParent(parent);
        attribute.setTags(tags);
        attribute.setNullableExpression(serializableAttribute.getNullableExpression());
        attribute.setVisibleExpression(serializableAttribute.getVisibleExpression());
        attribute.setValidationExpression(serializableAttribute.getValidationExpression());
        attribute.setDefaultValue(serializableAttribute.getDefaultValue());
        return attribute;
    }

    private Attribute getAttribute(String attributeId) {
        return (Attribute)this.dataService.findOneById("sys_md_Attribute", (Object)attributeId, new Fetch().field("id"), Attribute.class);
    }

    private EntityType getEntityType(String entityTypeId) {
        return (EntityType)this.dataService.findOneById("sys_md_EntityType", (Object)entityTypeId, new Fetch().field("id"), EntityType.class);
    }
}

