package org.molgenis.api.metadata.v3.model;

import com.google.auto.value.AutoValue;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.api.model.response.LinksResponse;
import org.molgenis.util.AutoGson;

@AutoValue
@AutoGson(autoValueClass = AutoValue_AttributeResponse.class)
public abstract class AttributeResponse {

  public abstract LinksResponse getLink();

  // can be null when selecting zero attributes (e.g. for referenced entities)
  @Nullable
  @CheckForNull
  public abstract AttributeResponseData getData();

  public static AttributeResponse create(
      LinksResponse linksResponse, AttributeResponseData newData) {
    return builder().setLink(linksResponse).setData(newData).build();
  }

  public static Builder builder() {
    return new AutoValue_AttributeResponse.Builder();
  }

  @SuppressWarnings(
      "java:S1610") // Abstract classes without fields should be converted to interfaces
  @AutoValue.Builder
  public abstract static class Builder {

    public abstract Builder setLink(LinksResponse linksResponse);

    public abstract Builder setData(AttributeResponseData newData);

    public abstract AttributeResponse build();
  }
}
