/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.molgenis.api.metadata.v3.AttributeResponseMapper;
import org.molgenis.api.metadata.v3.Attributes;
import org.molgenis.api.metadata.v3.MetadataUtils;
import org.molgenis.api.metadata.v3.model.AttributeResponse;
import org.molgenis.api.metadata.v3.model.AttributeResponseData;
import org.molgenis.api.metadata.v3.model.AttributesResponse;
import org.molgenis.api.metadata.v3.model.Category;
import org.molgenis.api.metadata.v3.model.I18nValue;
import org.molgenis.api.metadata.v3.model.Range;
import org.molgenis.api.model.Order;
import org.molgenis.api.model.response.LinksResponse;
import org.molgenis.api.model.response.PageResponse;
import org.molgenis.api.support.LinksUtils;
import org.molgenis.data.Repository;
import org.molgenis.data.Sort;
import org.molgenis.data.UnknownRepositoryException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.util.EntityTypeUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class AttributeResponseMapperImpl
implements AttributeResponseMapper {
    private static final String ATTRIBUTES = "attributes";
    private final MetaDataService metaDataService;

    AttributeResponseMapperImpl(MetaDataService metaDataService) {
        this.metaDataService = Objects.requireNonNull(metaDataService);
    }

    @Override
    public AttributesResponse toAttributesResponse(Attributes attributes, int size, int number) {
        int total = attributes.getTotal();
        return AttributesResponse.create(LinksUtils.createLinksResponse((int)number, (int)size, (int)total), attributes.getAttributes().stream().map((? super T attribute) -> this.toAttributeResponse((Attribute)attribute, false)).collect(Collectors.toList()), PageResponse.create((int)size, (int)total, (int)number));
    }

    @Override
    public List<AttributeResponse> mapInternal(Iterable<Attribute> allAttributes, boolean i18n) {
        ArrayList<AttributeResponse> result = new ArrayList<AttributeResponse>();
        for (Attribute attr : allAttributes) {
            result.add(this.toAttributeResponse(attr, i18n));
        }
        return result;
    }

    @Override
    public AttributeResponse toAttributeResponse(Attribute attr, boolean i18n) {
        AttributeResponseData attribute = this.mapInternal(attr, i18n);
        return AttributeResponse.create(LinksResponse.create(null, (URI)this.createAttributeResponseUri(attr), null), attribute);
    }

    private AttributeResponseData mapInternal(Attribute attr, boolean i18n) {
        Attribute parent;
        org.molgenis.data.Range range;
        AttributeResponseData.Builder builder = AttributeResponseData.builder();
        builder.setId(attr.getIdentifier());
        builder.setName(attr.getName());
        builder.setSequenceNr(attr.getSequenceNumber());
        builder.setType(AttributeType.getValueString((AttributeType)attr.getDataType()));
        builder.setIdAttribute(attr.isIdAttribute());
        builder.setLabelAttribute(attr.isLabelAttribute());
        builder.setLookupAttributeIndex(attr.getLookupAttributeIndex());
        if (EntityTypeUtils.isReferenceType((Attribute)attr)) {
            builder.setRefEntityType(LinksResponse.create(null, (URI)this.createEntityTypeResponseUri(attr.getRefEntity()), null));
        }
        builder.setCascadeDelete(attr.getCascadeDelete());
        builder.setMappedBy(attr.getMappedBy() != null ? this.toAttributeResponse(attr.getMappedBy(), i18n) : null);
        if (attr.getDataType() == AttributeType.ONE_TO_MANY && attr.isMappedBy()) {
            builder.setOrderBy(this.map(attr));
        }
        builder.setLabel(attr.getLabel(LocaleContextHolder.getLocale().getLanguage()));
        builder.setDescription(attr.getDescription(LocaleContextHolder.getLocale().getLanguage()));
        if (i18n) {
            builder.setLabelI18n(this.getI18nAttrLabel(attr));
            this.getI18nAttrDesc(attr).ifPresent(builder::setDescriptionI18n);
        }
        builder.setNullable(attr.isNillable());
        builder.setAuto(attr.isAuto());
        builder.setVisible(attr.isVisible());
        builder.setUnique(attr.isUnique());
        builder.setReadOnly(attr.isReadOnly());
        builder.setAggregatable(attr.isAggregatable());
        builder.setExpression(attr.getExpression());
        if (attr.getDataType() == AttributeType.ENUM) {
            builder.setEnumOptions(attr.getEnumOptions());
        }
        if (attr.getDataType() == AttributeType.CATEGORICAL || attr.getDataType() == AttributeType.CATEGORICAL_MREF) {
            builder.setCategoricalOptions(this.getCategories(attr.getRefEntity()));
        }
        if ((range = attr.getRange()) != null) {
            builder.setRange(Range.create(range.getMin(), range.getMax()));
        }
        builder.setParentAttributeId((parent = attr.getParent()) != null ? parent.getIdentifier() : null);
        builder.setNullableExpression(attr.getNullableExpression());
        builder.setVisibleExpression(attr.getVisibleExpression());
        builder.setValidationExpression(attr.getValidationExpression());
        builder.setDefaultValue(attr.getDefaultValue());
        return builder.build();
    }

    private List<Category> getCategories(EntityType entityType) {
        Repository repository = (Repository)this.metaDataService.getRepository(entityType).orElseThrow(() -> new UnknownRepositoryException(entityType.getId()));
        Attribute idAttribute = entityType.getIdAttribute();
        Attribute labelAttribute = entityType.getLabelAttribute();
        return repository.query().findAll().map((? super T entity) -> Category.builder().setId(entity.get(idAttribute)).setLabel(entity.get(labelAttribute).toString()).build()).collect(Collectors.toList());
    }

    private List<org.molgenis.api.model.Sort> map(Attribute attr) {
        List<org.molgenis.api.model.Sort> orders;
        Sort sort = attr.getOrderBy();
        if (sort == null) {
            orders = Collections.emptyList();
        } else {
            orders = new ArrayList<org.molgenis.api.model.Sort>(Iterables.size((Iterable)sort));
            for (Sort.Order order : sort) {
                orders.add(org.molgenis.api.model.Sort.create((String)order.getAttr(), (Order.Direction)Order.Direction.valueOf((String)order.getDirection().name())));
            }
        }
        return orders;
    }

    private URI createAttributeResponseUri(Attribute attr) {
        UriComponentsBuilder uriComponentsBuilder = ServletUriComponentsBuilder.fromCurrentRequestUri().replacePath(null).path("/api/metadata").pathSegment(new String[]{attr.getEntity().getId()}).pathSegment(new String[]{ATTRIBUTES}).pathSegment(new String[]{attr.getIdentifier()});
        return uriComponentsBuilder.build().toUri();
    }

    private URI createEntityTypeResponseUri(EntityType entityType) {
        UriComponentsBuilder uriComponentsBuilder = ServletUriComponentsBuilder.fromCurrentRequestUri().replacePath(null).path("/api/metadata").pathSegment(new String[]{entityType.getId()});
        return uriComponentsBuilder.build().toUri();
    }

    private I18nValue getI18nAttrLabel(Attribute attr) {
        String defaultValue = attr.getLabel();
        ImmutableMap<String, String> translations = MetadataUtils.getI18n(attr, "label");
        return I18nValue.create(defaultValue, translations);
    }

    private Optional<I18nValue> getI18nAttrDesc(Attribute attr) {
        String defaultValue = attr.getDescription();
        if (defaultValue == null) {
            return Optional.empty();
        }
        ImmutableMap<String, String> translations = MetadataUtils.getI18n(attr, "description");
        return Optional.of(I18nValue.create(defaultValue, translations));
    }
}

