/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.api.data.QueryMapper;
import org.molgenis.api.data.SortMapper;
import org.molgenis.api.metadata.v3.Attributes;
import org.molgenis.api.metadata.v3.EntityTypes;
import org.molgenis.api.metadata.v3.MetadataApiJobService;
import org.molgenis.api.metadata.v3.MetadataApiService;
import org.molgenis.api.metadata.v3.job.MetadataDeleteJobExecution;
import org.molgenis.api.metadata.v3.job.MetadataUpsertJobExecution;
import org.molgenis.api.model.Sort;
import org.molgenis.data.Fetch;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.Repository;
import org.molgenis.data.UnknownAttributeException;
import org.molgenis.data.UnknownEntityTypeException;
import org.molgenis.data.UnknownRepositoryException;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.QueryImpl;
import org.springframework.stereotype.Service;

@Service
public class MetadataApiServiceImpl
implements MetadataApiService {
    private final MetaDataService metadataService;
    private final QueryMapper queryMapper;
    private final SortMapper sortMapper;
    private final MetadataApiJobService metadataApiJobService;

    MetadataApiServiceImpl(MetaDataService metadataService, QueryMapper queryMapperV3, SortMapper sortMapper, MetadataApiJobService metadataApiJobService) {
        this.metadataService = Objects.requireNonNull(metadataService);
        this.queryMapper = Objects.requireNonNull(queryMapperV3);
        this.sortMapper = Objects.requireNonNull(sortMapper);
        this.metadataApiJobService = Objects.requireNonNull(metadataApiJobService);
    }

    @Override
    public EntityTypes findEntityTypes(@Nullable @CheckForNull org.molgenis.api.model.Query query, Sort sort, int size, int number) {
        Repository<EntityType> repository = this.getEntityTypeRepository();
        QueryImpl repositoryQuery = query != null ? this.queryMapper.map(query, repository) : new QueryImpl(repository);
        QueryImpl findQuery = new QueryImpl((Query)repositoryQuery);
        findQuery.offset(number * size);
        findQuery.pageSize(size);
        findQuery.sort(this.sortMapper.map(sort, repository.getEntityType()));
        List<EntityType> entityTypes = repository.findAll((Query)findQuery).collect(Collectors.toList());
        QueryImpl countQuery = new QueryImpl((Query)repositoryQuery);
        countQuery.offset(0);
        countQuery.pageSize(Integer.MAX_VALUE);
        int count = Math.toIntExact(repository.count((Query)countQuery));
        return EntityTypes.builder().setEntityTypes(entityTypes).setTotal(count).build();
    }

    @Override
    public EntityType findEntityType(String identifier) {
        return (EntityType)this.metadataService.getEntityType(identifier).orElseThrow(() -> new UnknownEntityTypeException(identifier));
    }

    @Override
    public Attributes findAttributes(String entityTypeId, @Nullable @CheckForNull org.molgenis.api.model.Query query, Sort sort, int size, int number) {
        if (!this.metadataService.hasEntityType(entityTypeId)) {
            throw new UnknownEntityTypeException(entityTypeId);
        }
        Repository<Attribute> repository = this.getAttributeRepository();
        Query<Attribute> repositoryQuery = this.toAttributeRepositoryQuery(entityTypeId, query, repository);
        QueryImpl findQuery = new QueryImpl(repositoryQuery);
        findQuery.offset(number * size);
        findQuery.pageSize(size);
        findQuery.sort(this.sortMapper.map(sort, repository.getEntityType()));
        List<Attribute> attributes = repository.findAll((Query)findQuery).collect(Collectors.toList());
        QueryImpl countQuery = new QueryImpl(repositoryQuery);
        countQuery.offset(0);
        countQuery.pageSize(Integer.MAX_VALUE);
        int count = Math.toIntExact(repository.count((Query)countQuery));
        return Attributes.builder().setAttributes(attributes).setTotal(count).build();
    }

    @Override
    public Attribute findAttribute(String entityTypeId, String attributeId) {
        EntityType entityType = this.findEntityType(entityTypeId);
        Attribute attribute = entityType.getOwnAttributeById(attributeId);
        if (attribute == null) {
            throw new UnknownAttributeException(entityType, attributeId);
        }
        return attribute;
    }

    @Override
    public MetadataUpsertJobExecution deleteAttributeAsync(String entityTypeId, String attributeId) {
        EntityType entityType = this.findEntityType(entityTypeId);
        Attribute attribute = entityType.getOwnAttributeById(attributeId);
        entityType.removeAttribute(attribute);
        return this.metadataApiJobService.scheduleUpdate(entityType);
    }

    @Override
    public MetadataUpsertJobExecution deleteAttributesAsync(String entityTypeId, org.molgenis.api.model.Query query) {
        EntityType entityType = this.findEntityType(entityTypeId);
        this.findAttributes(entityTypeId, query).forEach(arg_0 -> ((EntityType)entityType).removeAttribute(arg_0));
        return this.metadataApiJobService.scheduleUpdate(entityType);
    }

    @Override
    public void createEntityType(EntityType entityType) {
        this.metadataService.addEntityType(entityType);
    }

    @Override
    public MetadataUpsertJobExecution updateEntityTypeAsync(EntityType entityType) {
        return this.metadataApiJobService.scheduleUpdate(entityType);
    }

    @Override
    public MetadataDeleteJobExecution deleteEntityTypeAsync(String entityTypeId) {
        EntityType entityType = this.findEntityType(entityTypeId);
        return this.metadataApiJobService.scheduleDelete(entityType);
    }

    @Override
    public MetadataDeleteJobExecution deleteEntityTypesAsync(org.molgenis.api.model.Query query) {
        return this.metadataApiJobService.scheduleDelete(this.getEntityTypes(query));
    }

    private List<EntityType> getEntityTypes(org.molgenis.api.model.Query q) {
        Repository<EntityType> entityTypeRepository = this.getEntityTypeRepository();
        Query dataServiceQuery = this.queryMapper.map(q, entityTypeRepository);
        dataServiceQuery.setFetch(new Fetch().field("id"));
        return dataServiceQuery.findAll().collect(Collectors.toList());
    }

    private Query<Attribute> toAttributeRepositoryQuery(String entityTypeId, @Nullable @CheckForNull org.molgenis.api.model.Query query, Repository<Attribute> attributeRepository) {
        boolean nest;
        QueryImpl repositoryQuery = query != null ? this.queryMapper.map(query, attributeRepository) : new QueryImpl(attributeRepository);
        boolean bl = nest = repositoryQuery.getRules().size() > 1;
        if (nest) {
            QueryRule nestedQueryRule = new QueryRule(new ArrayList(repositoryQuery.getRules()));
            QueryImpl nestedRepositoryQuery = new QueryImpl(nestedQueryRule);
            nestedRepositoryQuery.setPageSize(repositoryQuery.getPageSize());
            nestedRepositoryQuery.setOffset(repositoryQuery.getOffset());
            nestedRepositoryQuery.setSort(repositoryQuery.getSort());
            nestedRepositoryQuery.setFetch(repositoryQuery.getFetch());
            repositoryQuery = nestedRepositoryQuery;
        }
        if (!repositoryQuery.getRules().isEmpty()) {
            repositoryQuery.and();
        }
        repositoryQuery.eq("entity", (Object)entityTypeId);
        return repositoryQuery;
    }

    private List<Attribute> findAttributes(String entityTypeId, org.molgenis.api.model.Query q) {
        Query<Attribute> repositoryQuery = this.toAttributeRepositoryQuery(entityTypeId, q, this.getAttributeRepository());
        repositoryQuery.setFetch(new Fetch().field("id"));
        return repositoryQuery.findAll().collect(Collectors.toList());
    }

    private Repository<EntityType> getEntityTypeRepository() {
        return (Repository)this.metadataService.getRepository("sys_md_EntityType", EntityType.class).orElseThrow(() -> new UnknownRepositoryException("sys_md_EntityType"));
    }

    private Repository<Attribute> getAttributeRepository() {
        return (Repository)this.metadataService.getRepository("sys_md_Attribute", Attribute.class).orElseThrow(() -> new UnknownRepositoryException("sys_md_Attribute"));
    }
}

