/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.api.metadata.v3;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.molgenis.data.Entity;
import org.molgenis.data.InvalidValueTypeException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.util.AttributeUtils;
import org.molgenis.util.i18n.LanguageService;

public class MetadataUtils {
    private MetadataUtils() {
    }

    public static <E extends Entity> ImmutableMap<String, String> getI18n(E entity, String attributeName) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        LanguageService.getLanguageCodes().forEach(languageCode -> {
            String value = entity.getString(AttributeUtils.getI18nAttributeName((String)attributeName, (String)languageCode));
            if (value != null) {
                builder.put(languageCode, (Object)value);
            }
        });
        return builder.build();
    }

    static void setSequenceNumber(Attribute attribute, Object value) {
        String sequenceString = MetadataUtils.getStringValue(value);
        if (sequenceString == null) {
            throw new InvalidValueTypeException(sequenceString, "int", null);
        }
        attribute.setSequenceNumber(Double.valueOf(sequenceString).intValue());
    }

    static void setAttributeType(Attribute attribute, Object value) {
        String typeString = MetadataUtils.getStringValue(value);
        if (typeString == null) {
            throw new InvalidValueTypeException(typeString, "AttributeType", null);
        }
        attribute.setDataType(AttributeType.toEnum((String)typeString));
    }

    static void setEnumOptions(Attribute attribute, Object value) {
        if (!(value instanceof List)) {
            throw new InvalidValueTypeException(value.toString(), "list", null);
        }
        List options = (List)value;
        attribute.setEnumOptions(options);
    }

    static void setBooleanValue(Entity entity, Object value, String fieldName) {
        String readOnlyValue = MetadataUtils.getStringValue(value);
        if (readOnlyValue == null) {
            throw new InvalidValueTypeException(readOnlyValue, "boolean", null);
        }
        entity.set(fieldName, (Object)Boolean.valueOf(readOnlyValue));
    }

    static String getStringValue(Object value) {
        return value != null ? value.toString() : null;
    }
}

